/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.store.client.util;

import java.util.PropertyResourceBundle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class HgStoreClientConfig {
    private static final Logger log = LoggerFactory.getLogger(HgStoreClientConfig.class);
    private static final int GRPC_DEFAULT_TIMEOUT_SECONDS = 100;
    private static final int GRPC_DEFAULT_MAX_INBOUND_MESSAGE_SIZE = 0x40000000;
    private static final int GRPC_DEFAULT_MAX_OUTBOUND_MESSAGE_SIZE = 0x40000000;
    private static final int NET_KV_SCANNER_PAGE_SIZE = 10000;
    private static final int NET_KV_SCANNER_HAVE_NEXT_TIMEOUT = 1800;
    private static final String fileName = "hg-store-client";
    private static PropertyResourceBundle prb = null;
    private static HgStoreClientConfig defaultInstance;
    private Integer grpcTimeoutSeconds = 100;
    private Integer grpcMaxInboundMessageSize = 0x40000000;
    private Integer grpcMaxOutboundMessageSize = 0x40000000;
    private Integer netKvScannerPageSize = 10000;
    private Integer netKvScannerHaveNextTimeout = 1800;

    private HgStoreClientConfig() {
    }

    public static synchronized HgStoreClientConfig of() {
        if (defaultInstance != null) {
            return defaultInstance;
        }
        defaultInstance = new HgStoreClientConfig();
        HgStoreClientConfig.overrideViaProperties(defaultInstance);
        return defaultInstance;
    }

    private static void overrideViaProperties(HgStoreClientConfig config) {
        try {
            prb = (PropertyResourceBundle)PropertyResourceBundle.getBundle(fileName);
        }
        catch (Throwable t) {
            log.warn("Failed to load hg-store-client.properties.");
            log.info("Default configuration was activated.");
            return;
        }
        PropertiesWrapper wrapper = new PropertiesWrapper(prb);
        config.grpcTimeoutSeconds = wrapper.getInt("grpc.timeout.seconds", config.grpcTimeoutSeconds);
        log.info("grpc.timeout.seconds = " + config.grpcTimeoutSeconds);
        config.grpcMaxInboundMessageSize = 0x40000000;
        log.info("grpc.max.inbound.message.size = " + config.grpcMaxInboundMessageSize);
        config.grpcMaxOutboundMessageSize = 0x40000000;
        log.info("grpc.max.outbound.message.size = " + config.grpcMaxOutboundMessageSize);
        config.netKvScannerPageSize = wrapper.getInt("net.kv.scanner.page.size", config.netKvScannerPageSize);
        log.info("net.kv.scanner.page.size = " + config.netKvScannerPageSize);
        log.info("net.kv.scanner.have.next.timeout = {}", (Object)config.netKvScannerHaveNextTimeout);
    }

    public Integer getGrpcTimeoutSeconds() {
        return this.grpcTimeoutSeconds;
    }

    public HgStoreClientConfig setGrpcTimeoutSeconds(Integer grpcTimeoutSeconds) {
        this.grpcTimeoutSeconds = grpcTimeoutSeconds;
        return this;
    }

    public Integer getGrpcMaxInboundMessageSize() {
        return this.grpcMaxInboundMessageSize;
    }

    public HgStoreClientConfig setGrpcMaxInboundMessageSize(Integer grpcMaxInboundMessageSize) {
        this.grpcMaxInboundMessageSize = grpcMaxInboundMessageSize;
        return this;
    }

    public Integer getGrpcMaxOutboundMessageSize() {
        return this.grpcMaxOutboundMessageSize;
    }

    public HgStoreClientConfig setGrpcMaxOutboundMessageSize(Integer grpcMaxOutboundMessageSize) {
        this.grpcMaxOutboundMessageSize = grpcMaxOutboundMessageSize;
        return this;
    }

    public Integer getNetKvScannerPageSize() {
        return this.netKvScannerPageSize;
    }

    public HgStoreClientConfig setNetKvScannerPageSize(Integer netKvScannerPageSize) {
        this.netKvScannerPageSize = netKvScannerPageSize;
        return this;
    }

    public Integer getNetKvScannerHaveNextTimeout() {
        return this.netKvScannerHaveNextTimeout;
    }

    public HgStoreClientConfig setNetKvScannerHaveNextTimeout(Integer netKvScannerHaveNextTimeout) {
        this.netKvScannerHaveNextTimeout = netKvScannerHaveNextTimeout;
        return this;
    }

    private static class PropertiesWrapper {
        private final PropertyResourceBundle prb;

        PropertiesWrapper(PropertyResourceBundle prb) {
            this.prb = prb;
        }

        Integer getInt(String key, Integer defaultValue) {
            String buf = this.getStr(key);
            if (buf == null || buf.isEmpty()) {
                return defaultValue;
            }
            Integer res = null;
            try {
                res = Integer.valueOf(buf);
            }
            catch (Throwable t) {
                log.error("Failed to parse a int value[ " + buf + " ] of the key[ " + key + " ].", t);
            }
            return res;
        }

        String getStr(String key, String defaultValue) {
            String res = this.getStr(key);
            if (res == null && defaultValue != null) {
                return defaultValue;
            }
            return res;
        }

        String getStr(String key) {
            String value = null;
            if (!this.prb.containsKey(key)) {
                return null;
            }
            try {
                value = this.prb.getString(key);
            }
            catch (Exception e) {
                log.warn("Failed to get value with key: [" + key + "]");
                return null;
            }
            if (value != null) {
                value = value.trim();
            }
            return value;
        }
    }
}

