/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.structure;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.hugegraph.id.Id;
import org.apache.hugegraph.id.SplicingIdGenerator;
import org.apache.hugegraph.perf.PerfUtil;
import org.apache.hugegraph.struct.schema.SchemaLabel;
import org.apache.hugegraph.struct.schema.VertexLabel;
import org.apache.hugegraph.structure.BaseEdge;
import org.apache.hugegraph.structure.BaseElement;
import org.apache.hugegraph.structure.BaseProperty;
import org.apache.hugegraph.type.HugeType;
import org.apache.hugegraph.type.define.CollectionType;
import org.apache.hugegraph.type.define.HugeKeys;
import org.apache.hugegraph.type.define.IdStrategy;
import org.apache.hugegraph.util.E;
import org.apache.hugegraph.util.collection.CollectionFactory;

public class BaseVertex
extends BaseElement
implements Cloneable {
    private static final List<BaseEdge> EMPTY_LIST = ImmutableList.of();
    protected Collection<BaseEdge> edges = EMPTY_LIST;

    public BaseVertex(Id id) {
        this.id(id);
    }

    public BaseVertex(Id id, SchemaLabel label) {
        this(id);
        this.schemaLabel(label);
    }

    @Override
    public String name() {
        String name;
        E.checkState((this.schemaLabel().idStrategy() == IdStrategy.PRIMARY_KEY ? 1 : 0) != 0, (String)"Only primary key vertex has name, but got '%s' with id strategy '%s'", (Object[])new Object[]{this, this.schemaLabel().idStrategy()});
        if (this.id() != null) {
            String[] parts = SplicingIdGenerator.parse(this.id());
            E.checkState((parts.length == 2 ? 1 : 0) != 0, (String)"Invalid primary key vertex id '%s'", (Object[])new Object[]{this.id()});
            name = parts[1];
        } else {
            assert (this.id() == null);
            List<Object> propValues = this.primaryValues();
            E.checkState((!propValues.isEmpty() ? 1 : 0) != 0, (String)"Primary values must not be empty (has properties %s)", (Object[])new Object[]{this.hasProperties()});
            name = SplicingIdGenerator.concatValues(propValues);
            E.checkArgument((!name.isEmpty() ? 1 : 0) != 0, (String)"The value of primary key can't be empty", (Object[])new Object[0]);
        }
        return name;
    }

    @PerfUtil.Watched(prefix="vertex")
    public List<Object> primaryValues() {
        E.checkArgument((this.schemaLabel().idStrategy() == IdStrategy.PRIMARY_KEY ? 1 : 0) != 0, (String)"The id strategy '%s' don't have primary keys", (Object[])new Object[]{this.schemaLabel().idStrategy()});
        List<Id> primaryKeys = this.schemaLabel().primaryKeys();
        E.checkArgument((!primaryKeys.isEmpty() ? 1 : 0) != 0, (String)"Primary key can't be empty for id strategy '%s'", (Object[])new Object[]{IdStrategy.PRIMARY_KEY});
        ArrayList<Object> propValues = new ArrayList<Object>(primaryKeys.size());
        for (Id pk : primaryKeys) {
            BaseProperty property = this.getProperty(pk);
            E.checkState((property != null ? 1 : 0) != 0, (String)"The value of primary key '%s' can't be null", (Object[])new Object[0]);
            propValues.add(property.serialValue(true));
        }
        return propValues;
    }

    public void addEdge(BaseEdge edge) {
        if (this.edges == EMPTY_LIST) {
            this.edges = CollectionFactory.newList(CollectionType.EC);
        }
        this.edges.add(edge);
    }

    public void correctVertexLabel(VertexLabel correctLabel) {
        E.checkArgumentNotNull((Object)correctLabel, (String)"Vertex label can't be null", (Object[])new Object[0]);
        if (!(this.schemaLabel() == null || this.schemaLabel().undefined() || correctLabel.undefined() || this.schemaLabel().generalVl() || correctLabel.generalVl())) {
            E.checkArgument((boolean)this.schemaLabel().equals(correctLabel), (String)"[%s]'s Vertex label can't be changed from '%s' to '%s'", (Object[])new Object[]{this.id(), this.schemaLabel(), correctLabel});
        }
        this.schemaLabel(correctLabel);
    }

    public Collection<BaseEdge> edges() {
        return this.edges;
    }

    public void edges(Collection<BaseEdge> edges) {
        this.edges = edges;
    }

    @Override
    public Object sysprop(HugeKeys key) {
        switch (key) {
            case ID: {
                return this.id();
            }
            case LABEL: {
                return this.schemaLabel().id();
            }
            case PRIMARY_VALUES: {
                return this.name();
            }
            case PROPERTIES: {
                return this.getPropertiesMap();
            }
        }
        E.checkArgument((boolean)false, (String)"Invalid system property '%s' of Vertex", (Object[])new Object[]{key});
        return null;
    }

    @Override
    public VertexLabel schemaLabel() {
        return (VertexLabel)super.schemaLabel();
    }

    public boolean olap() {
        return VertexLabel.OLAP_VL.equals(this.schemaLabel());
    }

    @Override
    public HugeType type() {
        if (this.schemaLabel() != null && (this.schemaLabel().name().equals("~task") || this.schemaLabel().name().equals("~taskresult") || this.schemaLabel().name().equals("~variables"))) {
            return HugeType.TASK;
        }
        return HugeType.VERTEX;
    }
}

