/*
 * Decompiled with CFR 0.152.
 */
package org.gridkit.jvmtool.cmd;

import com.beust.jcommander.Parameter;
import com.beust.jcommander.Parameters;
import com.beust.jcommander.ParametersDelegate;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TimeZone;
import org.gridkit.jvmtool.AbstractEventDumpSource;
import org.gridkit.jvmtool.cli.CommandLauncher;
import org.gridkit.jvmtool.event.CommonEvent;
import org.gridkit.jvmtool.event.EventReader;
import org.gridkit.jvmtool.event.ShieldedEventReader;
import org.gridkit.jvmtool.event.TagCollection;
import org.gridkit.jvmtool.stacktrace.CounterCollection;
import org.gridkit.util.formating.AsciiTableFormatter;
import org.gridkit.util.formating.CsvTableFormatter;
import org.gridkit.util.formating.TableFormatter;
import org.gridkit.util.formating.TabularDataSink;

public class DumpExportCmd
implements CommandLauncher.CmdRef {
    public String getCommandName() {
        return "dexp";
    }

    public Runnable newCommand(CommandLauncher host) {
        return new DumpExport(host);
    }

    static class SchemaStatComparator
    implements Comparator<SchemaStat> {
        SchemaStatComparator() {
        }

        @Override
        public int compare(SchemaStat o1, SchemaStat o2) {
            if (o1.count < o2.count) {
                return 1;
            }
            if (o1.count > o2.count) {
                return -1;
            }
            return 0;
        }
    }

    static class TagStatComparator
    implements Comparator<TagStat> {
        TagStatComparator() {
        }

        @Override
        public int compare(TagStat o1, TagStat o2) {
            if (o1.count < o2.count) {
                return 1;
            }
            if (o1.count > o2.count) {
                return -1;
            }
            return o1.key.compareTo(o2.key);
        }
    }

    private static class SchemaStat {
        Set<String> schema;
        long count;

        public SchemaStat(Set<String> schema) {
            this.schema = schema;
        }
    }

    private static class TagStat {
        String key;
        long count;
        Set<String> values = new HashSet<String>();

        public TagStat(String key) {
            this.key = key;
        }

        public void addValue(String val) {
            if (this.values != null) {
                this.values.add(val);
            }
            if (this.values.size() > 20) {
                this.values = null;
            }
        }
    }

    private static class SchemaHisto {
        Map<Set<String>, SchemaStat> histo = new HashMap<Set<String>, SchemaStat>();

        private SchemaHisto() {
        }

        public void count(CommonEvent ce) {
            HashSet<String> tagset = new HashSet<String>();
            this.collectTags(ce.tags(), tagset);
            this.collectCounter(ce.counters(), tagset);
            SchemaStat ss = this.histo.get(tagset);
            if (ss == null) {
                ss = new SchemaStat(tagset);
                this.histo.put(ss.schema, ss);
            }
            ++ss.count;
        }

        public void collapse() {
            block0: while (true) {
                for (SchemaStat ss : this.histo.values()) {
                    if (!this.mergeIn(ss)) continue;
                    continue block0;
                }
                break;
            }
        }

        private boolean mergeIn(SchemaStat ss) {
            SchemaStat match = null;
            for (SchemaStat cdt : this.histo.values()) {
                if (ss == cdt || !cdt.schema.containsAll(ss.schema)) continue;
                if (match == null) {
                    match = cdt;
                    continue;
                }
                return false;
            }
            if (match != null) {
                match.count += ss.count;
                this.histo.remove(ss.schema);
                return true;
            }
            return false;
        }

        private void collectTags(TagCollection tags, Set<String> tagset) {
            for (String key : tags) {
                tagset.add(key);
            }
        }

        private void collectCounter(CounterCollection counters, Set<String> tagset) {
            for (String key : counters) {
                tagset.add(key);
            }
        }
    }

    private static class Histo {
        Map<String, TagStat> histo = new HashMap<String, TagStat>();

        private Histo() {
        }

        public void count(CommonEvent ce) {
            this.countTags(ce.tags());
            this.countCounter(ce.counters());
        }

        private void countTags(TagCollection tags) {
            for (String key : tags) {
                TagStat kh = this.histo.get(key);
                if (kh == null) {
                    kh = new TagStat(key);
                    this.histo.put(key, kh);
                }
                ++kh.count;
                if (kh.values == null) continue;
                for (String val : tags.tagsFor(key)) {
                    kh.addValue(val);
                }
            }
        }

        private void countCounter(CounterCollection counters) {
            for (String key : counters) {
                TagStat kh = this.histo.get(key);
                if (kh == null) {
                    kh = new TagStat(key);
                    this.histo.put(key, kh);
                }
                ++kh.count;
                kh.values = null;
            }
        }
    }

    static class DumpInput
    extends AbstractEventDumpSource {
        @Parameter(names={"-f", "--file"}, description="Input files", required=true, variableArity=true)
        private List<String> inputFiles = new ArrayList<String>();

        public DumpInput(CommandLauncher host) {
            super(host);
        }

        @Override
        protected List<String> inputFiles() {
            return this.inputFiles;
        }
    }

    @Parameters(commandDescription="[Dump Export] Extract metrics from compressed dump into tabular format")
    public static class DumpExport
    implements Runnable {
        @ParametersDelegate
        private CommandLauncher host;
        @ParametersDelegate
        private DumpInput input;
        @Parameter(names={"--tags"}, description="Output statistics for tags")
        private boolean printTags;
        @Parameter(names={"-tz", "--timezone"}, required=false, description="Set time zone to be used for date formating")
        private String timezone;
        @Parameter(names={"-o", "--outfile"}, required=false, description="Out data into a file instead of std out")
        private String outfile;
        @Parameter(names={"-cl", "--columns"}, required=false, variableArity=true, description="List of columns (tags) to be exported")
        private List<String> columns = new ArrayList<String>();
        @Parameter(names={"-csv"}, required=false, description="Format output as CSV")
        private boolean csv = false;
        @Parameter(names={"--explain"}, required=false, description="Include additional information into std out")
        private boolean explain = false;
        @Parameter(names={"--export-all"}, required=false, description="Export all columns")
        private boolean exportAll = false;
        private TimeZone tz = TimeZone.getTimeZone("UTC");

        public DumpExport(CommandLauncher host) {
            this.host = host;
            this.input = new DumpInput(host);
        }

        @Override
        public void run() {
            try {
                OutputStreamWriter writer;
                if (this.timezone != null) {
                    this.tz = TimeZone.getTimeZone(this.timezone);
                }
                this.input.setTimeZone(this.tz);
                if (this.explain) {
                    System.out.println("Input files");
                    for (String string : this.input.sourceFiles()) {
                        System.out.println("  " + string);
                    }
                    System.out.println();
                }
                if (this.outfile != null) {
                    File file = new File(this.outfile);
                    if (file.exists()) {
                        this.host.fail(new String[]{"File already exists [" + this.outfile + "]"});
                    }
                    if (file.getParentFile() != null) {
                        file.getParentFile().mkdirs();
                    }
                    FileOutputStream fos = new FileOutputStream(file);
                    writer = new OutputStreamWriter((OutputStream)fos, Charset.forName("UTF8"));
                } else {
                    writer = new OutputStreamWriter((OutputStream)System.out, Charset.forName("UTF8"));
                }
                if (this.printTags) {
                    this.printTags(this.openReader(), writer);
                } else {
                    if (this.exportAll) {
                        this.columns = this.enumColumns(this.openReader());
                    }
                    if (this.columns.isEmpty()) {
                        this.host.fail(new String[]{"Export column list is empty"});
                    }
                    this.export(this.openReader(), writer, this.columns);
                }
                ((Writer)writer).close();
            }
            catch (Exception e) {
                this.host.fail("Unexpected error: " + e.toString(), e);
            }
        }

        private EventReader<CommonEvent> openReader() {
            ShieldedEventReader reader = new ShieldedEventReader(this.input.getFilteredRawReader(), CommonEvent.class);
            return reader;
        }

        private void printTags(EventReader<CommonEvent> openReader, Writer writer) {
            long minTs = Long.MAX_VALUE;
            long maxTs = Long.MIN_VALUE;
            long count = 0L;
            Histo histo = new Histo();
            SchemaHisto schemaHisto = new SchemaHisto();
            for (CommonEvent e : openReader) {
                ++count;
                minTs = Math.min(e.timestamp(), minTs);
                maxTs = Math.max(e.timestamp(), maxTs);
                histo.count(e);
                schemaHisto.count(e);
            }
            schemaHisto.collapse();
            ArrayList<TagStat> tags = new ArrayList<TagStat>(histo.histo.values());
            Collections.sort(tags, new TagStatComparator());
            ArrayList<SchemaStat> schemas = new ArrayList<SchemaStat>(schemaHisto.histo.values());
            Collections.sort(schemas, new SchemaStatComparator());
            PrintWriter pw = new PrintWriter(writer);
            if (count == 0L) {
                pw.println("No events");
            } else {
                pw.println("Event count: " + count);
                pw.println("Time range: " + this.fdate(minTs) + " - " + this.fdate(maxTs));
                pw.println("\nTag summary");
                for (TagStat ts : tags) {
                    pw.print(" @" + ts.key + " - " + ts.count);
                    if (ts.values != null) {
                        String vals = ts.values.toString();
                        if (vals.length() > 40) {
                            vals = vals.substring(0, 36) + " ...";
                        }
                        pw.print("  " + vals);
                    }
                    pw.println();
                }
                pw.println("\nSchema summary");
                for (SchemaStat ss : schemas) {
                    Object[] hdr = ss.schema.toArray(new String[0]);
                    Arrays.sort(hdr);
                    pw.println(" " + ss.count + " - " + this.formatHeader((String[])hdr));
                }
            }
            pw.flush();
        }

        private String formatHeader(String[] hdr) {
            StringBuilder sb = new StringBuilder();
            sb.append("[");
            for (String col : hdr) {
                sb.append(col).append(" ");
            }
            sb.setLength(sb.length() - 1);
            sb.append("]");
            return sb.toString();
        }

        private String fdate(long ts) {
            if (ts == Long.MAX_VALUE || ts == Long.MIN_VALUE) {
                return "";
            }
            SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMdd-HH:mm");
            sdf.setTimeZone(this.tz);
            return sdf.format(ts);
        }

        private void export(EventReader<CommonEvent> openReader, Writer writer, List<String> cols) throws IOException {
            TableFormatter table = this.csv ? new CsvTableFormatter(this.tz) : new AsciiTableFormatter(this.tz);
            boolean exportT = false;
            ArrayList<String> fcols = new ArrayList<String>();
            Iterator<String> i$ = cols.iterator();
            while (i$.hasNext()) {
                String col;
                String cn = col = i$.next();
                String fmt = null;
                if (col.indexOf(58) >= 0) {
                    cn = col.substring(0, col.indexOf(58));
                    fmt = col.substring(cn.length() + 1);
                }
                if (fmt == null) {
                    table.addCol(cn);
                } else {
                    table.addCol(cn, cn, fmt);
                }
                if (cn.equals("T")) {
                    exportT = true;
                    continue;
                }
                fcols.add(cn);
            }
            TabularDataSink.Cursor c = table.newCursor();
            for (CommonEvent ce : openReader) {
                boolean hasValue = false;
                for (String col : fcols) {
                    long lv;
                    if (ce.tags().firstTagFor(col) != null) {
                        StringBuilder sb = new StringBuilder();
                        for (String val : ce.tags().tagsFor(col)) {
                            if (sb.length() != 0) {
                                sb.append(" ");
                            }
                            sb.append(val);
                        }
                        c.setCell(col, sb.toString());
                        hasValue = true;
                    }
                    if ((lv = ce.counters().getValue(col)) < 0L) continue;
                    c.setCell(col, String.valueOf(lv));
                    hasValue = true;
                }
                if (!hasValue) continue;
                if (exportT) {
                    c.setCell("T", ce.timestamp());
                }
                c.submit();
            }
            table.format(writer);
        }

        private List<String> enumColumns(EventReader<CommonEvent> reader) {
            LinkedHashSet<String> cols = new LinkedHashSet<String>();
            for (CommonEvent ce : reader) {
                for (String key : ce.tags()) {
                    cols.add(key);
                }
                for (String key : ce.counters()) {
                    cols.add(key);
                }
            }
            return new ArrayList<String>(cols);
        }
    }
}

