/*
 * Decompiled with CFR 0.152.
 */
package org.gridkit.jvmtool.cmd;

import com.beust.jcommander.IVariableArity;
import com.beust.jcommander.Parameter;
import com.beust.jcommander.Parameters;
import com.beust.jcommander.ParametersDelegate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanOperationInfo;
import javax.management.MBeanParameterInfo;
import javax.management.MBeanServerConnection;
import javax.management.ObjectName;
import org.gridkit.jvmtool.JmxConnectionInfo;
import org.gridkit.jvmtool.MBeanHelper;
import org.gridkit.jvmtool.cli.CommandLauncher;
import org.gridkit.jvmtool.cmd.SjkAgentHelper;
import org.gridkit.jvmtool.cmd.Unsplitter;

public class JCmdCmd
implements CommandLauncher.CmdRef {
    public String getCommandName() {
        return "jcmd";
    }

    public Runnable newCommand(CommandLauncher host) {
        return new JCmdRunner(host);
    }

    @Parameters(commandDescription="jcmd JMX command")
    public static class JCmdRunner
    implements Runnable,
    IVariableArity {
        @ParametersDelegate
        private CommandLauncher host;
        @ParametersDelegate
        private JmxConnectionInfo connInfo;
        @Parameter(names={"-c", "--cmd"}, required=true, variableArity=true, splitter=Unsplitter.class, description="jcmd like command")
        private List<String> command = new ArrayList<String>();

        public JCmdRunner(CommandLauncher host) {
            this.host = host;
            this.connInfo = new JmxConnectionInfo(host);
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void run() {
            try {
                MBeanOperationInfo[] ops;
                if (this.host.isVerbose()) {
                    SjkAgentHelper.enableTrace(true);
                }
                if (this.command.isEmpty()) {
                    this.command = Arrays.asList("help");
                }
                String cmd = this.command.get(0);
                List<String> args = this.command.subList(1, this.command.size());
                ObjectName bname = new ObjectName("com.sun.management:type=DiagnosticCommand");
                MBeanServerConnection conn = this.connInfo.getMServer();
                MBeanHelper helper = new MBeanHelper(conn);
                try {
                    ops = conn.getMBeanInfo(bname).getOperations();
                }
                catch (InstanceNotFoundException e) {
                    this.host.fail(new String[]{"jcmd MBean is not supported by JVM"});
                    return;
                }
                boolean found = false;
                for (MBeanOperationInfo mop : ops) {
                    String result;
                    String op = mop.getName();
                    String opName = this.getOpName(mop);
                    if (!cmd.equals(opName)) continue;
                    found = true;
                    if (mop.getSignature().length == 0) {
                        if (!args.isEmpty()) {
                            this.host.fail(new String[]{"command '" + cmd + "' doesn't take any arguments"});
                            return;
                        }
                        result = helper.invoke(bname, op, new String[0]);
                    } else {
                        MBeanParameterInfo[] meta = mop.getSignature();
                        String[] sig = new String[meta.length];
                        for (int i = 0; i != meta.length; ++i) {
                            sig[i] = meta[i].getType();
                        }
                        result = (String)conn.invoke(bname, op, new Object[]{args.toArray(new String[0])}, sig);
                    }
                    System.out.println(result);
                    break;
                }
                if (found) return;
                this.host.fail(new String[]{"Operation is not available at target JVM '" + cmd + "'"});
                return;
            }
            catch (Exception e) {
                this.host.fail("", e);
            }
        }

        private String getOpName(MBeanOperationInfo mop) {
            String opname = (String)mop.getDescriptor().getFieldValue("dcmd.name");
            return opname;
        }

        public int processVariableArity(String optionName, String[] options) {
            return options.length;
        }
    }
}

