/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.rpc.doc.swagger.generate;

import com.alipay.sofa.rpc.doc.swagger.generate.ReaderContext;
import com.alipay.sofa.rpc.doc.swagger.generate.RpcReaderExtension;
import io.swagger.annotations.Extension;
import io.swagger.annotations.Info;
import io.swagger.annotations.OAuth2Definition;
import io.swagger.annotations.Scope;
import io.swagger.annotations.SwaggerDefinition;
import io.swagger.models.Contact;
import io.swagger.models.ExternalDocs;
import io.swagger.models.License;
import io.swagger.models.Operation;
import io.swagger.models.Path;
import io.swagger.models.Response;
import io.swagger.models.Scheme;
import io.swagger.models.Swagger;
import io.swagger.models.Tag;
import io.swagger.models.auth.ApiKeyAuthDefinition;
import io.swagger.models.auth.BasicAuthDefinition;
import io.swagger.models.auth.In;
import io.swagger.models.auth.OAuth2Definition;
import io.swagger.models.auth.SecuritySchemeDefinition;
import io.swagger.models.parameters.Parameter;
import io.swagger.util.BaseReaderUtils;
import io.swagger.util.PathUtils;
import io.swagger.util.ReflectionUtils;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;

public class Reader {
    private final Swagger swagger;

    private Reader(Swagger swagger) {
        this.swagger = swagger;
    }

    public static void read(Swagger swagger, Set<Class<?>> classes) {
        Reader reader = new Reader(swagger);
        for (Class<?> cls : classes) {
            ReaderContext context = new ReaderContext(swagger, cls, cls, "", null, false, new ArrayList<String>(), new ArrayList<String>(), new ArrayList<String>(), new ArrayList<Parameter>());
            reader.read(context);
        }
    }

    public static void read(Swagger swagger, Map<Class<?>, Object> interfaceMapRef, String httpContext) {
        Reader reader = new Reader(swagger);
        ArrayList arrayList = new ArrayList(interfaceMapRef.entrySet());
        Collections.sort(arrayList, new Comparator<Map.Entry<Class<?>, Object>>(){

            @Override
            public int compare(Map.Entry<Class<?>, Object> o1, Map.Entry<Class<?>, Object> o2) {
                return o1.getKey().getSimpleName().compareTo(o2.getKey().getSimpleName());
            }
        });
        for (Map.Entry entry : arrayList) {
            ReaderContext context = new ReaderContext(swagger, entry.getValue().getClass(), (Class)entry.getKey(), httpContext, null, false, new ArrayList<String>(), new ArrayList<String>(), new ArrayList<String>(), new ArrayList<Parameter>());
            reader.read(context);
        }
    }

    private void read(ReaderContext context) {
        SwaggerDefinition swaggerDefinition = context.getCls().getAnnotation(SwaggerDefinition.class);
        if (swaggerDefinition != null) {
            this.readSwaggerConfig(swaggerDefinition);
        }
        List<Method> interfaceMethodList = Arrays.asList(context.getInterfaceCls().getMethods());
        Collections.sort(interfaceMethodList, new Comparator<Method>(){

            @Override
            public int compare(Method o1, Method o2) {
                return o1.getName().compareTo(o2.getName());
            }
        });
        LinkedHashMap<Method, Method> serviceMethods = new LinkedHashMap<Method, Method>();
        for (Method method : interfaceMethodList) {
            if (ReflectionUtils.isOverriddenMethod((Method)method, context.getCls())) continue;
            serviceMethods.put(method, this.getRefMethod(context, method));
        }
        for (Map.Entry entry : serviceMethods.entrySet()) {
            HashMap regexMap;
            String parsedPath;
            Path path;
            Method method = (Method)entry.getValue();
            Method interfaceMethod = (Method)entry.getKey();
            Operation operation = new Operation();
            String operationPath = null;
            String httpMethod = null;
            RpcReaderExtension extension = new RpcReaderExtension();
            if (operationPath == null) {
                operationPath = extension.getPath(context, method);
            }
            if (httpMethod == null) {
                httpMethod = extension.getHttpMethod(context, method);
            }
            if (operationPath == null || httpMethod == null) continue;
            if (extension.isReadable(context)) {
                extension.setDeprecated(operation, method);
                extension.applyConsumes(context, operation, method);
                extension.applyProduces(context, operation, method);
                extension.applyOperationId(operation, method);
                extension.applySummary(operation, method);
                extension.applyDescription(operation, method);
                extension.applySchemes(context, operation, method);
                extension.applySecurityRequirements(context, operation, method);
                extension.applyTags(context, operation, method);
                extension.applyResponses(context, operation, method);
                extension.applyImplicitParameters(context, operation, method);
                extension.applyParameters(context, operation, method, interfaceMethod);
                extension.applyExtensions(context, operation, method);
            }
            if (httpMethod == null) continue;
            if (operation.getResponses() == null) {
                operation.defaultResponse(new Response().description("successful operation"));
            }
            if ((path = this.swagger.getPath(parsedPath = PathUtils.parsePath((String)operationPath, regexMap = new HashMap()))) == null) {
                path = new Path();
                this.swagger.path(parsedPath, path);
            }
            path.set(httpMethod.toLowerCase(), operation);
        }
    }

    private Method getRefMethod(ReaderContext context, Method method) {
        try {
            return context.getCls().getMethod(method.getName(), method.getParameterTypes());
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
        }
        catch (SecurityException e) {
            e.printStackTrace();
        }
        return method;
    }

    /*
     * WARNING - void declaration
     */
    private void readSwaggerConfig(SwaggerDefinition config) {
        int n;
        this.readInfoConfig(config);
        if (StringUtils.isNotBlank((CharSequence)config.basePath())) {
            this.swagger.setBasePath(config.basePath());
        }
        if (StringUtils.isNotBlank((CharSequence)config.host())) {
            this.swagger.setHost(config.host());
        }
        for (String string : config.consumes()) {
            if (!StringUtils.isNotBlank((CharSequence)string)) continue;
            this.swagger.addConsumes(string);
        }
        for (String string : config.produces()) {
            if (!StringUtils.isNotBlank((CharSequence)string)) continue;
            this.swagger.addProduces(string);
        }
        if (StringUtils.isNotBlank((CharSequence)config.externalDocs().value())) {
            ExternalDocs externalDocs = this.swagger.getExternalDocs();
            if (externalDocs == null) {
                externalDocs = new ExternalDocs();
                this.swagger.setExternalDocs(externalDocs);
            }
            externalDocs.setDescription(config.externalDocs().value());
            if (StringUtils.isNotBlank((CharSequence)config.externalDocs().url())) {
                externalDocs.setUrl(config.externalDocs().url());
            }
        }
        for (String string : config.securityDefinition().oAuth2Definitions()) {
            void var6_18;
            OAuth2Definition oAuth2Definition = new OAuth2Definition();
            OAuth2Definition.Flow flow = string.flow();
            if (flow.equals((Object)OAuth2Definition.Flow.ACCESS_CODE)) {
                OAuth2Definition oAuth2Definition2 = oAuth2Definition.accessCode(string.authorizationUrl(), string.tokenUrl());
            } else if (flow.equals((Object)OAuth2Definition.Flow.APPLICATION)) {
                OAuth2Definition oAuth2Definition3 = oAuth2Definition.application(string.tokenUrl());
            } else if (flow.equals((Object)OAuth2Definition.Flow.IMPLICIT)) {
                OAuth2Definition oAuth2Definition4 = oAuth2Definition.implicit(string.authorizationUrl());
            } else {
                OAuth2Definition oAuth2Definition5 = oAuth2Definition.password(string.tokenUrl());
            }
            for (Scope scope : string.scopes()) {
                var6_18.addScope(scope.name(), scope.description());
            }
            var6_18.setDescription(string.description());
            this.swagger.addSecurityDefinition(string.key(), (SecuritySchemeDefinition)var6_18);
        }
        String[] stringArray = new io.swagger.annotations.ApiKeyAuthDefinition[][]{config.securityDefinition().apiKeyAuthDefintions(), config.securityDefinition().apiKeyAuthDefinitions()};
        int n2 = stringArray.length;
        for (n = 0; n < n2; ++n) {
            String string;
            for (String apiKeyAuthConfig : string = stringArray[n]) {
                ApiKeyAuthDefinition apiKeyAuthDefinition = new ApiKeyAuthDefinition();
                apiKeyAuthDefinition.setName(apiKeyAuthConfig.name());
                apiKeyAuthDefinition.setIn(In.forValue((String)apiKeyAuthConfig.in().toValue()));
                apiKeyAuthDefinition.setDescription(apiKeyAuthConfig.description());
                this.swagger.addSecurityDefinition(apiKeyAuthConfig.key(), (SecuritySchemeDefinition)apiKeyAuthDefinition);
            }
        }
        stringArray = new io.swagger.annotations.BasicAuthDefinition[][]{config.securityDefinition().basicAuthDefinions(), config.securityDefinition().basicAuthDefinitions()};
        n2 = stringArray.length;
        for (n = 0; n < n2; ++n) {
            String string;
            for (String basicAuthConfig : string = stringArray[n]) {
                BasicAuthDefinition basicAuthDefinition = new BasicAuthDefinition();
                basicAuthDefinition.setDescription(basicAuthConfig.description());
                this.swagger.addSecurityDefinition(basicAuthConfig.key(), (SecuritySchemeDefinition)basicAuthDefinition);
            }
        }
        for (String string : config.tags()) {
            if (!StringUtils.isNotBlank((CharSequence)string.name())) continue;
            Tag tag = new Tag();
            tag.setName(string.name());
            tag.setDescription(string.description());
            if (StringUtils.isNotBlank((CharSequence)string.externalDocs().value())) {
                tag.setExternalDocs(new ExternalDocs(string.externalDocs().value(), string.externalDocs().url()));
            }
            tag.getVendorExtensions().putAll(BaseReaderUtils.parseExtensions((Extension[])string.extensions()));
            this.swagger.addTag(tag);
        }
        for (String string : config.schemes()) {
            if (string == SwaggerDefinition.Scheme.DEFAULT) continue;
            this.swagger.addScheme(Scheme.forValue((String)string.name()));
        }
    }

    private void readInfoConfig(SwaggerDefinition config) {
        Info infoConfig = config.info();
        io.swagger.models.Info info = this.swagger.getInfo();
        if (info == null) {
            info = new io.swagger.models.Info();
            this.swagger.setInfo(info);
        }
        if (StringUtils.isNotBlank((CharSequence)infoConfig.description())) {
            info.setDescription(infoConfig.description());
        }
        if (StringUtils.isNotBlank((CharSequence)infoConfig.termsOfService())) {
            info.setTermsOfService(infoConfig.termsOfService());
        }
        if (StringUtils.isNotBlank((CharSequence)infoConfig.title())) {
            info.setTitle(infoConfig.title());
        }
        if (StringUtils.isNotBlank((CharSequence)infoConfig.version())) {
            info.setVersion(infoConfig.version());
        }
        if (StringUtils.isNotBlank((CharSequence)infoConfig.contact().name())) {
            Contact contact = info.getContact();
            if (contact == null) {
                contact = new Contact();
                info.setContact(contact);
            }
            contact.setName(infoConfig.contact().name());
            if (StringUtils.isNotBlank((CharSequence)infoConfig.contact().email())) {
                contact.setEmail(infoConfig.contact().email());
            }
            if (StringUtils.isNotBlank((CharSequence)infoConfig.contact().url())) {
                contact.setUrl(infoConfig.contact().url());
            }
        }
        if (StringUtils.isNotBlank((CharSequence)infoConfig.license().name())) {
            License license = info.getLicense();
            if (license == null) {
                license = new License();
                info.setLicense(license);
            }
            license.setName(infoConfig.license().name());
            if (StringUtils.isNotBlank((CharSequence)infoConfig.license().url())) {
                license.setUrl(infoConfig.license().url());
            }
        }
        info.getVendorExtensions().putAll(BaseReaderUtils.parseExtensions((Extension[])infoConfig.extensions()));
    }
}

