/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fury.codegen;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.fury.codegen.Expression;
import org.apache.fury.reflect.TypeRef;
import org.apache.fury.type.TypeUtils;
import org.apache.fury.util.Preconditions;
import org.apache.fury.util.StringUtils;
import org.apache.fury.util.function.Functions;

public class ExpressionUtils {
    public static Expression newObjectArray(Expression ... expressions) {
        return new Expression.NewArray(TypeRef.of(Object[].class), expressions);
    }

    public static Expression valueOf(TypeRef<?> type, Expression value) {
        return new Expression.StaticInvoke(TypeUtils.getRawType(type), "valueOf", type, false, value);
    }

    public static Expression.IsNull isNull(Expression target) {
        return new Expression.IsNull(target);
    }

    public static Expression notNull(Expression target) {
        return new Expression.Not(new Expression.IsNull(target));
    }

    public static Expression eqNull(Expression target) {
        Preconditions.checkArgument(!target.type().isPrimitive());
        return ExpressionUtils.eq(target, new Expression.Null(target.type()));
    }

    public static Expression.Not not(Expression target) {
        return new Expression.Not(target);
    }

    public static Expression.Literal nullValue(TypeRef<?> type) {
        return new Expression.Literal(null, type);
    }

    public static Expression.Comparator eq(Expression left, Expression right) {
        return ExpressionUtils.eq(left, right, true);
    }

    public static Expression.Comparator eq(Expression left, Expression right, boolean inline) {
        return new Expression.Comparator("==", left, right, inline);
    }

    public static Expression.Comparator eq(Expression left, Expression right, String valuePrefix) {
        Expression.Comparator comparator = new Expression.Comparator("==", left, right, false);
        comparator.valuePrefix = valuePrefix;
        return comparator;
    }

    public static Expression.Comparator neq(Expression left, Expression right) {
        return ExpressionUtils.neq(left, right, true);
    }

    public static Expression.Comparator neq(Expression left, Expression right, String valuePrefix) {
        Expression.Comparator comparator = new Expression.Comparator("!=", left, right, false);
        comparator.valuePrefix = valuePrefix;
        return comparator;
    }

    public static Expression.Comparator neq(Expression left, Expression right, boolean inline) {
        return new Expression.Comparator("!=", left, right, inline);
    }

    public static Expression.Comparator egt(Expression left, Expression right) {
        return new Expression.Comparator(">=", left, right, true);
    }

    public static Expression.Comparator egt(Expression left, Expression right, String valuePrefix) {
        Expression.Comparator comparator = new Expression.Comparator(">=", left, right, false);
        comparator.valuePrefix = valuePrefix;
        return comparator;
    }

    public static Expression.Comparator gt(Expression left, Expression right) {
        Expression.Comparator comparator = new Expression.Comparator(">", left, right, true);
        return comparator;
    }

    public static Expression.Comparator lessThan(Expression left, Expression right) {
        return new Expression.Comparator("<", left, right, true);
    }

    public static Expression.Arithmetic add(Expression left, Expression right) {
        return new Expression.Arithmetic(true, "+", left, right);
    }

    public static Expression.Arithmetic add(Expression left, Expression right, String valuePrefix) {
        Expression.Arithmetic arithmetic = new Expression.Arithmetic(true, "+", left, right);
        arithmetic.valuePrefix = valuePrefix;
        return arithmetic;
    }

    public static Expression.Arithmetic subtract(Expression left, Expression right) {
        return new Expression.Arithmetic(true, "-", left, right);
    }

    public static Expression.Arithmetic subtract(Expression left, Expression right, String valuePrefix) {
        Expression.Arithmetic arithmetic = new Expression.Arithmetic(true, "-", left, right);
        arithmetic.valuePrefix = valuePrefix;
        return arithmetic;
    }

    public static Expression.Cast cast(Expression value, TypeRef<?> typeRef) {
        return new Expression.Cast(value, typeRef);
    }

    public static Expression inline(Expression expression) {
        return ExpressionUtils.inline(expression, true);
    }

    private static Expression inline(Expression expression, boolean inline) {
        if (expression instanceof Expression.Inlineable) {
            ((Expression.Inlineable)expression).inline(inline);
        }
        return expression;
    }

    public static Expression uninline(Expression expression) {
        return ExpressionUtils.inline(expression, false);
    }

    public static Expression.StaticInvoke invokeStaticInline(Class<?> staticObject, String functionName, TypeRef<?> type, Expression ... arguments) {
        return new Expression.StaticInvoke(staticObject, functionName, "", type, false, true, arguments);
    }

    static String callFunc(String type, String resultVal, String target, String functionName, String args, boolean needTryCatch) {
        if (needTryCatch) {
            return StringUtils.format("${type} ${value};\ntry {\n   ${value} = ${target}.${functionName}(${args});\n} catch (Exception e) {\n   throw new RuntimeException(e);\n}", "type", type, "value", resultVal, "target", target, "functionName", functionName, "args", args);
        }
        return StringUtils.format("${type} ${value} = ${target}.${functionName}(${args});", "type", type, "value", resultVal, "target", target, "functionName", functionName, "args", args);
    }

    static String callFunc(String target, String functionName, String args, boolean needTryCatch) {
        if (needTryCatch) {
            return StringUtils.format("try {\n   ${target}.${functionName}(${args});\n} catch (Exception e) {\n   throw new RuntimeException(e);\n}", "target", target, "functionName", functionName, "args", args);
        }
        return StringUtils.format("${target}.${functionName}(${args});", "target", target, "functionName", functionName, "args", args);
    }

    public static List<Expression> extractCapturedExpressions(Serializable closure) {
        ArrayList<Expression> expressions = new ArrayList<Expression>();
        Functions.extractCapturedVariables(closure, capturedArg -> {
            if (capturedArg instanceof Expression) {
                expressions.add((Expression)capturedArg);
            } else if (capturedArg instanceof Expression[]) {
                Collections.addAll(Arrays.asList((Expression[])capturedArg), new Expression[0]);
            }
            return false;
        });
        return expressions;
    }
}

