/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.backend.store.scylladb;

import org.apache.hugegraph.backend.store.BackendFeatures;
import org.apache.hugegraph.backend.store.BackendStore;
import org.apache.hugegraph.backend.store.BackendStoreProvider;
import org.apache.hugegraph.backend.store.cassandra.CassandraMetrics;
import org.apache.hugegraph.backend.store.cassandra.CassandraSessionPool;
import org.apache.hugegraph.backend.store.cassandra.CassandraStore;
import org.apache.hugegraph.backend.store.cassandra.CassandraStoreProvider;
import org.apache.hugegraph.backend.store.cassandra.CassandraTable;
import org.apache.hugegraph.backend.store.scylladb.ScyllaDBFeatures;
import org.apache.hugegraph.backend.store.scylladb.ScyllaDBMetrics;
import org.apache.hugegraph.backend.store.scylladb.ScyllaDBTablesWithMV;
import org.apache.hugegraph.config.HugeConfig;
import org.apache.hugegraph.type.HugeType;
import org.apache.hugegraph.util.E;
import org.apache.hugegraph.util.Log;
import org.slf4j.Logger;

public class ScyllaDBStoreProvider
extends CassandraStoreProvider {
    private static final Logger LOG = Log.logger(CassandraStore.class);
    private static final BackendFeatures FEATURES = new ScyllaDBFeatures();

    public String type() {
        return "scylladb";
    }

    public BackendStore loadSchemaStore(HugeConfig config) {
        String name = "m";
        LOG.debug("ScyllaDBStoreProvider load SchemaStore '{}'", (Object)name);
        if (!this.stores.containsKey(name)) {
            ScyllaDBSchemaStore s = new ScyllaDBSchemaStore((BackendStoreProvider)this, this.keyspace(), name);
            this.stores.putIfAbsent(name, s);
        }
        BackendStore store = (BackendStore)this.stores.get(name);
        E.checkNotNull((Object)store, (String)"store");
        E.checkState((boolean)(store instanceof ScyllaDBSchemaStore), (String)"SchemaStore must be an instance of ScyllaDBSchemaStore", (Object[])new Object[0]);
        return store;
    }

    public BackendStore loadGraphStore(HugeConfig config) {
        String name = "g";
        LOG.debug("ScyllaDBStoreProvider load GraphStore '{}'", (Object)name);
        if (!this.stores.containsKey(name)) {
            ScyllaDBGraphStore s = new ScyllaDBGraphStore((BackendStoreProvider)this, this.keyspace(), name);
            this.stores.putIfAbsent(name, s);
        }
        BackendStore store = (BackendStore)this.stores.get(name);
        E.checkNotNull((Object)store, (String)"store");
        E.checkState((boolean)(store instanceof ScyllaDBGraphStore), (String)"GraphStore must be an instance of ScyllaDBGraphStore", (Object[])new Object[0]);
        return store;
    }

    public BackendStore loadSystemStore(HugeConfig config) {
        String name = "s";
        LOG.debug("ScyllaDBStoreProvider load SystemStore '{}'", (Object)name);
        if (!this.stores.containsKey(name)) {
            ScyllaDBSystemStore s = new ScyllaDBSystemStore((BackendStoreProvider)this, this.keyspace(), name);
            this.stores.putIfAbsent(name, s);
        }
        BackendStore store = (BackendStore)this.stores.get(name);
        E.checkNotNull((Object)store, (String)"store");
        E.checkState((boolean)(store instanceof ScyllaDBSystemStore), (String)"SystemStore must be an instance of ScyllaDBSystemStore", (Object[])new Object[0]);
        return store;
    }

    public static class ScyllaDBSystemStore
    extends CassandraStore.CassandraSystemStore {
        public ScyllaDBSystemStore(BackendStoreProvider provider, String keyspace, String store) {
            super(provider, keyspace, store);
        }

        public BackendFeatures features() {
            return FEATURES;
        }

        protected CassandraMetrics createMetrics(HugeConfig conf, CassandraSessionPool sessions, String keyspace) {
            return new ScyllaDBMetrics(conf, sessions, keyspace);
        }
    }

    public static class ScyllaDBGraphStore
    extends CassandraStore.CassandraGraphStore {
        public ScyllaDBGraphStore(BackendStoreProvider provider, String keyspace, String store) {
            super(provider, keyspace, store);
            this.registerTableManager(HugeType.VERTEX, (CassandraTable)new ScyllaDBTablesWithMV.Vertex(store));
            this.registerTableManager(HugeType.EDGE_OUT, (CassandraTable)ScyllaDBTablesWithMV.Edge.out(store));
            this.registerTableManager(HugeType.EDGE_IN, (CassandraTable)ScyllaDBTablesWithMV.Edge.in(store));
        }

        public BackendFeatures features() {
            return FEATURES;
        }

        protected CassandraMetrics createMetrics(HugeConfig conf, CassandraSessionPool sessions, String keyspace) {
            return new ScyllaDBMetrics(conf, sessions, keyspace);
        }
    }

    public static class ScyllaDBSchemaStore
    extends CassandraStore.CassandraSchemaStore {
        public ScyllaDBSchemaStore(BackendStoreProvider provider, String keyspace, String store) {
            super(provider, keyspace, store);
            this.registerTableManager(HugeType.VERTEX_LABEL, (CassandraTable)new ScyllaDBTablesWithMV.VertexLabel());
            this.registerTableManager(HugeType.EDGE_LABEL, (CassandraTable)new ScyllaDBTablesWithMV.EdgeLabel());
            this.registerTableManager(HugeType.PROPERTY_KEY, (CassandraTable)new ScyllaDBTablesWithMV.PropertyKey());
            this.registerTableManager(HugeType.INDEX_LABEL, (CassandraTable)new ScyllaDBTablesWithMV.IndexLabel());
        }

        public BackendFeatures features() {
            return FEATURES;
        }

        protected CassandraMetrics createMetrics(HugeConfig conf, CassandraSessionPool sessions, String keyspace) {
            return new ScyllaDBMetrics(conf, sessions, keyspace);
        }
    }
}

