/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.pd.client;

import io.grpc.Channel;
import io.grpc.stub.AbstractBlockingStub;
import io.grpc.stub.AbstractStub;
import io.grpc.stub.StreamObserver;
import java.io.Closeable;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Semaphore;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import org.apache.hugegraph.pd.client.AbstractClient;
import org.apache.hugegraph.pd.client.PDConfig;
import org.apache.hugegraph.pd.common.PDException;
import org.apache.hugegraph.pd.grpc.kv.K;
import org.apache.hugegraph.pd.grpc.kv.KResponse;
import org.apache.hugegraph.pd.grpc.kv.Kv;
import org.apache.hugegraph.pd.grpc.kv.KvResponse;
import org.apache.hugegraph.pd.grpc.kv.KvServiceGrpc;
import org.apache.hugegraph.pd.grpc.kv.LockRequest;
import org.apache.hugegraph.pd.grpc.kv.LockResponse;
import org.apache.hugegraph.pd.grpc.kv.ScanPrefixResponse;
import org.apache.hugegraph.pd.grpc.kv.TTLRequest;
import org.apache.hugegraph.pd.grpc.kv.TTLResponse;
import org.apache.hugegraph.pd.grpc.kv.WatchEvent;
import org.apache.hugegraph.pd.grpc.kv.WatchKv;
import org.apache.hugegraph.pd.grpc.kv.WatchRequest;
import org.apache.hugegraph.pd.grpc.kv.WatchResponse;
import org.apache.hugegraph.pd.grpc.kv.WatchType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KvClient<T extends WatchResponse>
extends AbstractClient
implements Closeable {
    private static final Logger log = LoggerFactory.getLogger(KvClient.class);
    private AtomicLong clientId = new AtomicLong(0L);
    private Semaphore semaphore = new Semaphore(1);
    private AtomicBoolean closed = new AtomicBoolean(false);
    private Set<StreamObserver> observers = ConcurrentHashMap.newKeySet();
    BiConsumer<String, Consumer> listenWrapper = (key, consumer) -> {
        try {
            this.listen((String)key, (Consumer<T>)consumer);
        }
        catch (PDException e) {
            try {
                log.warn("start listen with warning:", (Throwable)e);
                Thread.sleep(1000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    };
    BiConsumer<String, Consumer> prefixListenWrapper = (key, consumer) -> {
        try {
            this.listenPrefix((String)key, (Consumer<T>)consumer);
        }
        catch (PDException e) {
            try {
                log.warn("start listenPrefix with warning:", (Throwable)e);
                Thread.sleep(1000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    };

    public KvClient(PDConfig pdConfig) {
        super(pdConfig);
    }

    @Override
    protected AbstractStub createStub() {
        return KvServiceGrpc.newStub((Channel)this.channel);
    }

    @Override
    protected AbstractBlockingStub createBlockingStub() {
        return KvServiceGrpc.newBlockingStub((Channel)this.channel);
    }

    public KvResponse put(String key, String value) throws PDException {
        Kv kv = Kv.newBuilder().setKey(key).setValue(value).build();
        KvResponse response = (KvResponse)this.blockingUnaryCall(KvServiceGrpc.getPutMethod(), kv);
        KvClient.handleErrors(response.getHeader());
        return response;
    }

    public KResponse get(String key) throws PDException {
        K k = K.newBuilder().setKey(key).build();
        KResponse response = (KResponse)this.blockingUnaryCall(KvServiceGrpc.getGetMethod(), k);
        KvClient.handleErrors(response.getHeader());
        return response;
    }

    public KvResponse delete(String key) throws PDException {
        K k = K.newBuilder().setKey(key).build();
        KvResponse response = (KvResponse)this.blockingUnaryCall(KvServiceGrpc.getDeleteMethod(), k);
        KvClient.handleErrors(response.getHeader());
        return response;
    }

    public KvResponse deletePrefix(String prefix) throws PDException {
        K k = K.newBuilder().setKey(prefix).build();
        KvResponse response = (KvResponse)this.blockingUnaryCall(KvServiceGrpc.getDeletePrefixMethod(), k);
        KvClient.handleErrors(response.getHeader());
        return response;
    }

    public ScanPrefixResponse scanPrefix(String prefix) throws PDException {
        K k = K.newBuilder().setKey(prefix).build();
        ScanPrefixResponse response = (ScanPrefixResponse)this.blockingUnaryCall(KvServiceGrpc.getScanPrefixMethod(), k);
        KvClient.handleErrors(response.getHeader());
        return response;
    }

    public TTLResponse keepTTLAlive(String key) throws PDException {
        TTLRequest request = TTLRequest.newBuilder().setKey(key).build();
        TTLResponse response = (TTLResponse)this.blockingUnaryCall(KvServiceGrpc.getKeepTTLAliveMethod(), request);
        KvClient.handleErrors(response.getHeader());
        return response;
    }

    public TTLResponse putTTL(String key, String value, long ttl) throws PDException {
        TTLRequest request = TTLRequest.newBuilder().setKey(key).setValue(value).setTtl(ttl).build();
        TTLResponse response = (TTLResponse)this.blockingUnaryCall(KvServiceGrpc.getPutTTLMethod(), request);
        KvClient.handleErrors(response.getHeader());
        return response;
    }

    private void onEvent(WatchResponse value, Consumer<T> consumer) {
        log.info("receive message for {},event Count:{}", (Object)value, (Object)value.getEventsCount());
        this.clientId.compareAndSet(0L, value.getClientId());
        if (value.getEventsCount() != 0) {
            try {
                consumer.accept(value);
            }
            catch (Exception e) {
                log.info("an error occurred while executing the client callback method, which should not have happened.Please check the callback method of the client", (Throwable)e);
            }
        }
    }

    private StreamObserver<WatchResponse> getObserver(String key, Consumer<T> consumer, BiConsumer<String, Consumer> listenWrapper, long client) {
        StreamObserver<WatchResponse> observer = this.getObserver(key, consumer, listenWrapper);
        this.observers.add(observer);
        return observer;
    }

    private StreamObserver<WatchResponse> getObserver(final String key, final Consumer<T> consumer, final BiConsumer<String, Consumer> listenWrapper) {
        return new StreamObserver<WatchResponse>(){

            public void onNext(WatchResponse value) {
                switch (value.getState()) {
                    case Starting: {
                        boolean b = KvClient.this.clientId.compareAndSet(0L, value.getClientId());
                        if (b) {
                            log.info("set watch client id to :{}", (Object)value.getClientId());
                        }
                        KvClient.this.release();
                        break;
                    }
                    case Started: {
                        KvClient.this.onEvent(value, consumer);
                        break;
                    }
                    case Leader_Changed: {
                        KvClient.this.clientId.set(0L);
                        KvClient.this.release();
                        listenWrapper.accept(key, consumer);
                        break;
                    }
                    case Alive: {
                        break;
                    }
                }
            }

            public void onError(Throwable t) {
                KvClient.this.release();
                if (!KvClient.this.closed.get()) {
                    KvClient.this.clientId.set(0L);
                    listenWrapper.accept(key, consumer);
                }
            }

            public void onCompleted() {
            }
        };
    }

    public void listen(String key, Consumer<T> consumer) throws PDException {
        long value = this.clientId.get();
        StreamObserver<WatchResponse> observer = this.getObserver(key, consumer, this.listenWrapper, value);
        this.acquire();
        try {
            WatchRequest k = WatchRequest.newBuilder().setClientId(this.clientId.get()).setKey(key).build();
            this.streamingCall(KvServiceGrpc.getWatchMethod(), k, observer, 1);
        }
        catch (Exception e) {
            this.release();
            throw new PDException(104, (Throwable)e);
        }
    }

    public void listenPrefix(String prefix, Consumer<T> consumer) throws PDException {
        long value = this.clientId.get();
        StreamObserver<WatchResponse> observer = this.getObserver(prefix, consumer, this.prefixListenWrapper, value);
        this.acquire();
        try {
            WatchRequest k = WatchRequest.newBuilder().setClientId(this.clientId.get()).setKey(prefix).build();
            this.streamingCall(KvServiceGrpc.getWatchPrefixMethod(), k, observer, 1);
        }
        catch (Exception e) {
            this.release();
            throw new PDException(104, (Throwable)e);
        }
    }

    private void acquire() {
        if (this.clientId.get() == 0L) {
            try {
                this.semaphore.acquire();
                if (this.clientId.get() != 0L) {
                    this.semaphore.release();
                }
                log.info("wait for client starting....");
            }
            catch (InterruptedException e) {
                log.error("get semaphore with error:", (Throwable)e);
            }
        }
    }

    private void release() {
        try {
            if (this.semaphore.availablePermits() == 0) {
                this.semaphore.release();
            }
        }
        catch (Exception e) {
            log.warn("release failed:", (Throwable)e);
        }
    }

    public List<String> getWatchList(T response) {
        LinkedList<String> values = new LinkedList<String>();
        List eventsList = response.getEventsList();
        for (WatchEvent event : eventsList) {
            if (event.getType() != WatchType.Put) {
                return null;
            }
            String value = event.getCurrent().getValue();
            values.add(value);
        }
        return values;
    }

    public Map<String, String> getWatchMap(T response) {
        HashMap<String, String> values = new HashMap<String, String>();
        List eventsList = response.getEventsList();
        for (WatchEvent event : eventsList) {
            if (event.getType() != WatchType.Put) {
                return null;
            }
            WatchKv current = event.getCurrent();
            String key = current.getKey();
            String value = current.getValue();
            values.put(key, value);
        }
        return values;
    }

    public LockResponse lock(String key, long ttl) throws PDException {
        LockResponse response;
        this.acquire();
        try {
            LockRequest k = LockRequest.newBuilder().setKey(key).setClientId(this.clientId.get()).setTtl(ttl).build();
            response = (LockResponse)this.blockingUnaryCall(KvServiceGrpc.getLockMethod(), k);
            KvClient.handleErrors(response.getHeader());
            this.clientId.compareAndSet(0L, response.getClientId());
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            this.release();
        }
        return response;
    }

    public LockResponse lockWithoutReentrant(String key, long ttl) throws PDException {
        LockResponse response;
        this.acquire();
        try {
            LockRequest k = LockRequest.newBuilder().setKey(key).setClientId(this.clientId.get()).setTtl(ttl).build();
            response = (LockResponse)this.blockingUnaryCall(KvServiceGrpc.getLockWithoutReentrantMethod(), k);
            KvClient.handleErrors(response.getHeader());
            this.clientId.compareAndSet(0L, response.getClientId());
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            this.release();
        }
        return response;
    }

    public LockResponse isLocked(String key) throws PDException {
        LockRequest k = LockRequest.newBuilder().setKey(key).setClientId(this.clientId.get()).build();
        LockResponse response = (LockResponse)this.blockingUnaryCall(KvServiceGrpc.getIsLockedMethod(), k);
        KvClient.handleErrors(response.getHeader());
        return response;
    }

    public LockResponse unlock(String key) throws PDException {
        assert (this.clientId.get() != 0L);
        LockRequest k = LockRequest.newBuilder().setKey(key).setClientId(this.clientId.get()).build();
        LockResponse response = (LockResponse)this.blockingUnaryCall(KvServiceGrpc.getUnlockMethod(), k);
        KvClient.handleErrors(response.getHeader());
        this.clientId.compareAndSet(0L, response.getClientId());
        assert (this.clientId.get() == response.getClientId());
        return response;
    }

    public LockResponse keepAlive(String key) throws PDException {
        assert (this.clientId.get() != 0L);
        LockRequest k = LockRequest.newBuilder().setKey(key).setClientId(this.clientId.get()).build();
        LockResponse response = (LockResponse)this.blockingUnaryCall(KvServiceGrpc.getKeepAliveMethod(), k);
        KvClient.handleErrors(response.getHeader());
        this.clientId.compareAndSet(0L, response.getClientId());
        assert (this.clientId.get() == response.getClientId());
        return response;
    }

    @Override
    public void close() {
        for (StreamObserver o : this.observers) {
            try {
                if (o == null) continue;
                o.onCompleted();
            }
            catch (Exception exception) {}
        }
        this.observers.clear();
        this.closed.set(true);
        super.close();
    }
}

