/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.pd.client;

import com.google.protobuf.ByteString;
import io.grpc.CallOptions;
import io.grpc.Channel;
import io.grpc.ClientInterceptor;
import io.grpc.ManagedChannel;
import io.grpc.ManagedChannelBuilder;
import io.grpc.MethodDescriptor;
import io.grpc.StatusRuntimeException;
import io.grpc.stub.AbstractBlockingStub;
import io.grpc.stub.ClientCalls;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.TimeUnit;
import org.apache.hugegraph.pd.client.ClientCache;
import org.apache.hugegraph.pd.client.PDConfig;
import org.apache.hugegraph.pd.client.PDConnectionManager;
import org.apache.hugegraph.pd.client.PDPulse;
import org.apache.hugegraph.pd.client.PDWatch;
import org.apache.hugegraph.pd.client.PDWatchImpl;
import org.apache.hugegraph.pd.client.StubProxy;
import org.apache.hugegraph.pd.client.impl.PDPulseImpl2;
import org.apache.hugegraph.pd.client.interceptor.Authentication;
import org.apache.hugegraph.pd.client.listener.PDEventListener;
import org.apache.hugegraph.pd.common.KVPair;
import org.apache.hugegraph.pd.common.PDException;
import org.apache.hugegraph.pd.common.PartitionUtils;
import org.apache.hugegraph.pd.grpc.MetaTask;
import org.apache.hugegraph.pd.grpc.Metapb;
import org.apache.hugegraph.pd.grpc.PDGrpc;
import org.apache.hugegraph.pd.grpc.Pdpb;
import org.apache.hugegraph.pd.grpc.watch.WatchResponse;
import org.apache.hugegraph.pd.grpc.watch.WatchShardGroupResponse;
import org.apache.hugegraph.pd.watch.NodeEvent;
import org.apache.hugegraph.pd.watch.PartitionEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PDClient {
    private static final Logger log = LoggerFactory.getLogger(PDClient.class);
    private static Map<String, ManagedChannel> channels = new ConcurrentHashMap<String, ManagedChannel>();
    private static ManagedChannel channel = null;
    private final PDConfig config;
    private final Pdpb.RequestHeader header;
    private final ClientCache cache;
    private final StubProxy proxy;
    private final List<PDEventListener> listeners;
    private final PDPulse pulse;
    private final PDConnectionManager connectionManager;
    private PDWatch.Watcher partitionWatcher;
    private PDWatch.Watcher storeWatcher;
    private PDWatch.Watcher graphWatcher;
    private PDWatch.Watcher shardGroupWatcher;
    private PDWatch pdWatch;
    private Authentication auth;

    private PDClient(PDConfig config) {
        this.config = config;
        this.header = Pdpb.RequestHeader.getDefaultInstance();
        this.proxy = new StubProxy(config.getServerHost().split(","));
        this.listeners = new CopyOnWriteArrayList<PDEventListener>();
        this.cache = new ClientCache(this);
        this.auth = new Authentication(config.getUserName(), config.getAuthority());
        this.connectionManager = new PDConnectionManager(config, this::getLeaderIp);
        this.pulse = new PDPulseImpl2(this.connectionManager);
    }

    public static PDClient create(PDConfig config) {
        PDClient client = new PDClient(config);
        return client;
    }

    public static void setChannel(ManagedChannel mc) {
        channel = mc;
    }

    public PDPulse getPulse() {
        return this.pulse;
    }

    public void forceReconnect() {
        this.connectionManager.forceReconnect();
    }

    private synchronized void newBlockingStub() throws PDException {
        if (this.proxy.get() != null) {
            return;
        }
        String host = this.newLeaderStub();
        if (host.isEmpty()) {
            throw new PDException(104, "PD unreachable, pd.peers=" + this.config.getServerHost());
        }
        log.info("PDClient enable cache, init PDWatch object");
        this.startWatch(host);
        this.connectionManager.forceReconnect();
    }

    public void startWatch(String leader) {
        if (this.pdWatch != null && Objects.equals(this.pdWatch.getCurrentHost(), leader) && this.pdWatch.checkChannel()) {
            return;
        }
        log.info("PDWatch client connect host:{}", (Object)leader);
        this.pdWatch = new PDWatchImpl(leader, this.config);
        this.partitionWatcher = this.pdWatch.watchPartition(new PDWatch.Listener<PartitionEvent>(){

            @Override
            public void onNext(PartitionEvent response) {
                PDClient.this.invalidPartitionCache(response.getGraph(), response.getPartitionId());
                if (response.getChangeType() == PartitionEvent.ChangeType.DEL) {
                    PDClient.this.cache.removeAll(response.getGraph());
                }
                PDClient.this.listeners.forEach(listener -> listener.onPartitionChanged(response));
            }

            @Override
            public void onError(Throwable throwable) {
                log.error("watchPartition exception {}", (Object)throwable.getMessage());
                PDClient.this.closeStub(false);
            }
        });
        this.storeWatcher = this.pdWatch.watchNode(new PDWatch.Listener<NodeEvent>(){

            @Override
            public void onNext(NodeEvent response) {
                log.info("PDClient receive store event {} {}", (Object)response.getEventType(), (Object)Long.toHexString(response.getNodeId()));
                if (response.getEventType() == NodeEvent.EventType.NODE_PD_LEADER_CHANGE) {
                    String leaderIp = response.getGraph();
                    log.info("watchNode: pd leader changed to {}, current watch:{}", (Object)leaderIp, (Object)PDClient.this.pdWatch.getCurrentHost());
                    PDClient.this.closeStub(!Objects.equals(PDClient.this.pdWatch.getCurrentHost(), leaderIp));
                    PDClient.this.startWatch(leaderIp);
                    PDClient.this.connectionManager.forceReconnect();
                }
                if (response.getEventType() == NodeEvent.EventType.NODE_OFFLINE) {
                    PDClient.this.invalidStoreCache(response.getNodeId());
                } else {
                    try {
                        PDClient.this.getStore(response.getNodeId());
                    }
                    catch (PDException e) {
                        log.error("getStore exception", (Throwable)e);
                    }
                }
                PDClient.this.listeners.forEach(listener -> listener.onStoreChanged(response));
            }

            @Override
            public void onError(Throwable throwable) {
                log.error("watchNode exception {}", (Object)throwable.getMessage());
                PDClient.this.closeStub(false);
            }
        });
        this.graphWatcher = this.pdWatch.watchGraph(new PDWatch.Listener<WatchResponse>(){

            @Override
            public void onNext(WatchResponse response) {
                PDClient.this.listeners.forEach(listener -> listener.onGraphChanged(response));
            }

            @Override
            public void onError(Throwable throwable) {
                log.warn("graphWatcher exception {}", (Object)throwable.getMessage());
            }
        });
        this.shardGroupWatcher = this.pdWatch.watchShardGroup(new PDWatch.Listener<WatchResponse>(){

            @Override
            public void onNext(WatchResponse response) {
                WatchShardGroupResponse shardResponse = response.getShardGroupResponse();
                if (PDClient.this.config.isEnableCache()) {
                    switch (shardResponse.getType()) {
                        case WATCH_CHANGE_TYPE_DEL: {
                            PDClient.this.cache.deleteShardGroup(shardResponse.getShardGroupId());
                            break;
                        }
                        case WATCH_CHANGE_TYPE_ALTER: 
                        case WATCH_CHANGE_TYPE_ADD: {
                            PDClient.this.cache.updateShardGroup(response.getShardGroupResponse().getShardGroup());
                            break;
                        }
                    }
                }
                PDClient.this.listeners.forEach(listener -> listener.onShardGroupChanged(response));
            }

            @Override
            public void onError(Throwable throwable) {
                log.warn("shardGroupWatcher exception {}", (Object)throwable.getMessage());
            }
        });
    }

    private synchronized void closeStub(boolean closeWatcher) {
        this.proxy.set(null);
        this.cache.reset();
        if (closeWatcher) {
            if (this.partitionWatcher != null) {
                this.partitionWatcher.close();
                this.partitionWatcher = null;
            }
            if (this.storeWatcher != null) {
                this.storeWatcher.close();
                this.storeWatcher = null;
            }
            if (this.graphWatcher != null) {
                this.graphWatcher.close();
                this.graphWatcher = null;
            }
            if (this.shardGroupWatcher != null) {
                this.shardGroupWatcher.close();
                this.shardGroupWatcher = null;
            }
            this.pdWatch = null;
        }
    }

    private PDGrpc.PDBlockingStub getStub() throws PDException {
        if (this.proxy.get() == null) {
            this.newBlockingStub();
        }
        return this.getStub(this.proxy.get());
    }

    private PDGrpc.PDBlockingStub getStub(PDGrpc.PDBlockingStub stub) {
        return (PDGrpc.PDBlockingStub)((PDGrpc.PDBlockingStub)((PDGrpc.PDBlockingStub)stub.withDeadlineAfter(this.config.getGrpcTimeOut(), TimeUnit.MILLISECONDS)).withInterceptors(new ClientInterceptor[]{this.auth})).withMaxInboundMessageSize(PDConfig.getInboundMessageSize());
    }

    private PDGrpc.PDBlockingStub newStub() throws PDException {
        if (this.proxy.get() == null) {
            this.newBlockingStub();
        }
        return this.getStub(PDGrpc.newBlockingStub((Channel)this.proxy.get().getChannel()));
    }

    private String newLeaderStub() {
        String leaderHost = "";
        for (int i = 0; i < this.proxy.getHostCount(); ++i) {
            String host = this.proxy.nextHost();
            ManagedChannel channel = this.getChannel(host);
            PDGrpc.PDBlockingStub stub = this.getStub(PDGrpc.newBlockingStub((Channel)channel));
            try {
                String leaderIp = this.getLeaderIp(stub);
                if (!leaderIp.equalsIgnoreCase(host)) {
                    leaderHost = leaderIp;
                    this.proxy.set(this.getStub(PDGrpc.newBlockingStub((Channel)channel)));
                } else {
                    this.proxy.set(stub);
                    leaderHost = host;
                }
                this.proxy.setLeader(leaderIp);
                log.info("PDClient connect to host = {} success", (Object)leaderHost);
                break;
            }
            catch (Exception e) {
                log.error("PDClient connect to {} exception {}, {}", new Object[]{host, e.getMessage(), e.getCause() != null ? e.getCause().getMessage() : ""});
                continue;
            }
        }
        return leaderHost;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ManagedChannel getChannel(String host) {
        ManagedChannel c = channels.get(host);
        if (c == null || c.isTerminated()) {
            Map<String, ManagedChannel> map = channels;
            synchronized (map) {
                c = channels.get(host);
                if (c == null || c.isTerminated()) {
                    c = channel = ManagedChannelBuilder.forTarget((String)host).maxInboundMessageSize(PDConfig.getInboundMessageSize()).usePlaintext().build();
                    channels.put(host, channel);
                }
            }
        }
        channel = c;
        return channel;
    }

    public String getLeaderIp() {
        try {
            return this.getLeaderIp(this.getStub());
        }
        catch (PDException e) {
            throw new RuntimeException(e);
        }
    }

    private String getLeaderIp(PDGrpc.PDBlockingStub stub) {
        if (stub == null) {
            try {
                this.getStub();
                return this.proxy.getLeader();
            }
            catch (PDException e) {
                throw new RuntimeException(e);
            }
        }
        Pdpb.GetMembersRequest request = Pdpb.GetMembersRequest.newBuilder().setHeader(this.header).build();
        Metapb.Member leader = stub.getMembers(request).getLeader();
        return leader.getGrpcUrl();
    }

    public long registerStore(Metapb.Store store) throws PDException {
        Pdpb.RegisterStoreRequest request = Pdpb.RegisterStoreRequest.newBuilder().setHeader(this.header).setStore(store).build();
        Pdpb.RegisterStoreResponse response = (Pdpb.RegisterStoreResponse)this.blockingUnaryCall(PDGrpc.getRegisterStoreMethod(), request);
        this.handleResponseError(response.getHeader());
        return response.getStoreId();
    }

    public Metapb.Store getStore(long storeId) throws PDException {
        Metapb.Store store = this.cache.getStoreById(storeId);
        if (store == null) {
            Pdpb.GetStoreRequest request = Pdpb.GetStoreRequest.newBuilder().setHeader(this.header).setStoreId(storeId).build();
            Pdpb.GetStoreResponse response = this.getStub().getStore(request);
            this.handleResponseError(response.getHeader());
            store = response.getStore();
            if (this.config.isEnableCache()) {
                this.cache.addStore(storeId, store);
            }
        }
        return store;
    }

    public Metapb.Store updateStore(Metapb.Store store) throws PDException {
        Pdpb.SetStoreRequest request = Pdpb.SetStoreRequest.newBuilder().setHeader(this.header).setStore(store).build();
        Pdpb.SetStoreResponse response = this.getStub().setStore(request);
        this.handleResponseError(response.getHeader());
        store = response.getStore();
        if (this.config.isEnableCache()) {
            this.cache.addStore(store.getId(), store);
        }
        return store;
    }

    public List<Metapb.Store> getActiveStores(String graphName) throws PDException {
        HashSet<Metapb.Store> stores = new HashSet<Metapb.Store>();
        KVPair<Metapb.Partition, Metapb.Shard> ptShard = this.getPartitionByCode(graphName, 0L);
        while (ptShard != null) {
            stores.add(this.getStore(((Metapb.Shard)ptShard.getValue()).getStoreId()));
            if (((Metapb.Partition)ptShard.getKey()).getEndKey() < 65535L) {
                ptShard = this.getPartitionByCode(graphName, ((Metapb.Partition)ptShard.getKey()).getEndKey());
                continue;
            }
            ptShard = null;
        }
        return new ArrayList<Metapb.Store>(stores);
    }

    public List<Metapb.Store> getActiveStores() throws PDException {
        Pdpb.GetAllStoresRequest request = Pdpb.GetAllStoresRequest.newBuilder().setHeader(this.header).setGraphName("").setExcludeOfflineStores(true).build();
        Pdpb.GetAllStoresResponse response = this.getStub().getAllStores(request);
        this.handleResponseError(response.getHeader());
        return response.getStoresList();
    }

    public List<Metapb.Store> getAllStores(String graphName) throws PDException {
        Pdpb.GetAllStoresRequest request = Pdpb.GetAllStoresRequest.newBuilder().setHeader(this.header).setGraphName(graphName).setExcludeOfflineStores(false).build();
        Pdpb.GetAllStoresResponse response = this.getStub().getAllStores(request);
        this.handleResponseError(response.getHeader());
        return response.getStoresList();
    }

    public Metapb.ClusterStats storeHeartbeat(Metapb.StoreStats stats) throws PDException {
        Pdpb.StoreHeartbeatRequest request = Pdpb.StoreHeartbeatRequest.newBuilder().setHeader(this.header).setStats(stats).build();
        Pdpb.StoreHeartbeatResponse response = this.getStub().storeHeartbeat(request);
        this.handleResponseError(response.getHeader());
        return response.getClusterStats();
    }

    private KVPair<Metapb.Partition, Metapb.Shard> getKvPair(String graphName, byte[] key, KVPair<Metapb.Partition, Metapb.Shard> partShard) throws PDException {
        if (partShard == null) {
            Pdpb.GetPartitionRequest request = Pdpb.GetPartitionRequest.newBuilder().setHeader(this.header).setGraphName(graphName).setKey(ByteString.copyFrom((byte[])key)).build();
            Pdpb.GetPartitionResponse response = (Pdpb.GetPartitionResponse)this.blockingUnaryCall(PDGrpc.getGetPartitionMethod(), request);
            this.handleResponseError(response.getHeader());
            partShard = new KVPair((Object)response.getPartition(), (Object)response.getLeader());
            this.cache.update(graphName, ((Metapb.Partition)partShard.getKey()).getId(), (Metapb.Partition)partShard.getKey());
        }
        return partShard;
    }

    public KVPair<Metapb.Partition, Metapb.Shard> getPartition(String graphName, byte[] key) throws PDException {
        KVPair<Metapb.Partition, Metapb.Shard> partShard = this.cache.getPartitionByKey(graphName, key);
        partShard = this.getKvPair(graphName, key, partShard);
        return partShard;
    }

    public KVPair<Metapb.Partition, Metapb.Shard> getPartition(String graphName, byte[] key, int code) throws PDException {
        KVPair<Metapb.Partition, Metapb.Shard> partShard = this.cache.getPartitionByCode(graphName, code);
        partShard = this.getKvPair(graphName, key, partShard);
        return partShard;
    }

    public KVPair<Metapb.Partition, Metapb.Shard> getPartitionByCode(String graphName, long hashCode) throws PDException {
        KVPair partShard = this.cache.getPartitionByCode(graphName, hashCode);
        if (partShard == null) {
            Pdpb.GetPartitionByCodeRequest request = Pdpb.GetPartitionByCodeRequest.newBuilder().setHeader(this.header).setGraphName(graphName).setCode(hashCode).build();
            Pdpb.GetPartitionResponse response = (Pdpb.GetPartitionResponse)this.blockingUnaryCall(PDGrpc.getGetPartitionByCodeMethod(), request);
            this.handleResponseError(response.getHeader());
            partShard = new KVPair((Object)response.getPartition(), (Object)response.getLeader());
            this.cache.update(graphName, ((Metapb.Partition)partShard.getKey()).getId(), (Metapb.Partition)partShard.getKey());
            this.cache.updateShardGroup(this.getShardGroup(((Metapb.Partition)partShard.getKey()).getId()));
        }
        if (partShard.getValue() == null) {
            Metapb.ShardGroup shardGroup = this.getShardGroup(((Metapb.Partition)partShard.getKey()).getId());
            if (shardGroup != null) {
                for (Metapb.Shard shard : shardGroup.getShardsList()) {
                    if (shard.getRole() != Metapb.ShardRole.Leader) continue;
                    partShard.setValue((Object)shard);
                }
            } else {
                log.error("getPartitionByCode: get shard group failed, {}", (Object)((Metapb.Partition)partShard.getKey()).getId());
            }
        }
        return partShard;
    }

    public int keyToCode(String graphName, byte[] key) {
        return PartitionUtils.calcHashcode((byte[])key);
    }

    public KVPair<Metapb.Partition, Metapb.Shard> getPartitionById(String graphName, int partId) throws PDException {
        KVPair partShard = this.cache.getPartitionById(graphName, partId);
        if (partShard == null) {
            Pdpb.GetPartitionByIDRequest request = Pdpb.GetPartitionByIDRequest.newBuilder().setHeader(this.header).setGraphName(graphName).setPartitionId(partId).build();
            Pdpb.GetPartitionResponse response = (Pdpb.GetPartitionResponse)this.blockingUnaryCall(PDGrpc.getGetPartitionByIDMethod(), request);
            this.handleResponseError(response.getHeader());
            partShard = new KVPair((Object)response.getPartition(), (Object)response.getLeader());
            if (this.config.isEnableCache()) {
                this.cache.update(graphName, ((Metapb.Partition)partShard.getKey()).getId(), (Metapb.Partition)partShard.getKey());
                this.cache.updateShardGroup(this.getShardGroup(((Metapb.Partition)partShard.getKey()).getId()));
            }
        }
        if (partShard.getValue() == null) {
            Metapb.ShardGroup shardGroup = this.getShardGroup(((Metapb.Partition)partShard.getKey()).getId());
            if (shardGroup != null) {
                for (Metapb.Shard shard : shardGroup.getShardsList()) {
                    if (shard.getRole() != Metapb.ShardRole.Leader) continue;
                    partShard.setValue((Object)shard);
                }
            } else {
                log.error("getPartitionById: get shard group failed, {}", (Object)((Metapb.Partition)partShard.getKey()).getId());
            }
        }
        return partShard;
    }

    public Metapb.ShardGroup getShardGroup(int partId) throws PDException {
        Metapb.ShardGroup group = this.cache.getShardGroup(partId);
        if (group == null) {
            group = this.getShardGroupDirect(partId);
            if (this.config.isEnableCache()) {
                this.cache.updateShardGroup(group);
            }
        }
        return group;
    }

    public Metapb.ShardGroup getShardGroupDirect(int partId) throws PDException {
        Pdpb.GetShardGroupRequest request = Pdpb.GetShardGroupRequest.newBuilder().setHeader(this.header).setGroupId(partId).build();
        Pdpb.GetShardGroupResponse response = (Pdpb.GetShardGroupResponse)this.blockingUnaryCall(PDGrpc.getGetShardGroupMethod(), request);
        this.handleResponseError(response.getHeader());
        return response.getShardGroup();
    }

    public void updateShardGroup(Metapb.ShardGroup shardGroup) throws PDException {
        Pdpb.UpdateShardGroupRequest request = Pdpb.UpdateShardGroupRequest.newBuilder().setHeader(this.header).setShardGroup(shardGroup).build();
        Pdpb.UpdateShardGroupResponse response = (Pdpb.UpdateShardGroupResponse)this.blockingUnaryCall(PDGrpc.getUpdateShardGroupMethod(), request);
        this.handleResponseError(response.getHeader());
        if (this.config.isEnableCache()) {
            this.cache.updateShardGroup(shardGroup);
        }
    }

    public List<KVPair<Metapb.Partition, Metapb.Shard>> scanPartitions(String graphName, byte[] startKey, byte[] endKey) throws PDException {
        ArrayList<KVPair<Metapb.Partition, Metapb.Shard>> partitions = new ArrayList<KVPair<Metapb.Partition, Metapb.Shard>>();
        KVPair<Metapb.Partition, Metapb.Shard> startPartShard = this.getPartition(graphName, startKey);
        KVPair<Metapb.Partition, Metapb.Shard> endPartShard = this.getPartition(graphName, endKey);
        if (startPartShard == null || endPartShard == null) {
            return null;
        }
        partitions.add(startPartShard);
        while (((Metapb.Partition)startPartShard.getKey()).getEndKey() < ((Metapb.Partition)endPartShard.getKey()).getEndKey() && ((Metapb.Partition)startPartShard.getKey()).getEndKey() < 65535L) {
            startPartShard = this.getPartitionByCode(graphName, ((Metapb.Partition)startPartShard.getKey()).getEndKey());
            partitions.add(startPartShard);
        }
        return partitions;
    }

    public List<Metapb.Partition> getPartitionsByStore(long storeId) throws PDException {
        Metapb.PartitionQuery query = Metapb.PartitionQuery.newBuilder().setStoreId(storeId).build();
        Pdpb.QueryPartitionsRequest request = Pdpb.QueryPartitionsRequest.newBuilder().setQuery(query).build();
        Pdpb.QueryPartitionsResponse response = (Pdpb.QueryPartitionsResponse)this.blockingUnaryCall(PDGrpc.getQueryPartitionsMethod(), request);
        this.handleResponseError(response.getHeader());
        return response.getPartitionsList();
    }

    public List<Metapb.Partition> queryPartitions(long storeId, int partitionId) throws PDException {
        Metapb.PartitionQuery query = Metapb.PartitionQuery.newBuilder().setStoreId(storeId).setPartitionId(partitionId).build();
        Pdpb.QueryPartitionsRequest request = Pdpb.QueryPartitionsRequest.newBuilder().setQuery(query).build();
        Pdpb.QueryPartitionsResponse response = (Pdpb.QueryPartitionsResponse)this.blockingUnaryCall(PDGrpc.getQueryPartitionsMethod(), request);
        this.handleResponseError(response.getHeader());
        return response.getPartitionsList();
    }

    public List<Metapb.Partition> getPartitions(long storeId, String graphName) throws PDException {
        Metapb.PartitionQuery query = Metapb.PartitionQuery.newBuilder().setStoreId(storeId).setGraphName(graphName).build();
        Pdpb.QueryPartitionsRequest request = Pdpb.QueryPartitionsRequest.newBuilder().setQuery(query).build();
        Pdpb.QueryPartitionsResponse response = (Pdpb.QueryPartitionsResponse)this.blockingUnaryCall(PDGrpc.getQueryPartitionsMethod(), request);
        this.handleResponseError(response.getHeader());
        return response.getPartitionsList();
    }

    public Metapb.Graph setGraph(Metapb.Graph graph) throws PDException {
        Pdpb.SetGraphRequest request = Pdpb.SetGraphRequest.newBuilder().setGraph(graph).build();
        Pdpb.SetGraphResponse response = (Pdpb.SetGraphResponse)this.blockingUnaryCall(PDGrpc.getSetGraphMethod(), request);
        this.handleResponseError(response.getHeader());
        return response.getGraph();
    }

    public Metapb.Graph getGraph(String graphName) throws PDException {
        Pdpb.GetGraphRequest request = Pdpb.GetGraphRequest.newBuilder().setGraphName(graphName).build();
        Pdpb.GetGraphResponse response = (Pdpb.GetGraphResponse)this.blockingUnaryCall(PDGrpc.getGetGraphMethod(), request);
        this.handleResponseError(response.getHeader());
        return response.getGraph();
    }

    public Metapb.Graph getGraphWithOutException(String graphName) throws PDException {
        Pdpb.GetGraphRequest request = Pdpb.GetGraphRequest.newBuilder().setGraphName(graphName).build();
        Pdpb.GetGraphResponse response = (Pdpb.GetGraphResponse)this.blockingUnaryCall(PDGrpc.getGetGraphMethod(), request);
        return response.getGraph();
    }

    public Metapb.Graph delGraph(String graphName) throws PDException {
        Pdpb.DelGraphRequest request = Pdpb.DelGraphRequest.newBuilder().setGraphName(graphName).build();
        Pdpb.DelGraphResponse response = (Pdpb.DelGraphResponse)this.blockingUnaryCall(PDGrpc.getDelGraphMethod(), request);
        this.handleResponseError(response.getHeader());
        return response.getGraph();
    }

    public List<Metapb.Partition> updatePartition(List<Metapb.Partition> partitions) throws PDException {
        Pdpb.UpdatePartitionRequest request = Pdpb.UpdatePartitionRequest.newBuilder().addAllPartition(partitions).build();
        Pdpb.UpdatePartitionResponse response = (Pdpb.UpdatePartitionResponse)this.blockingUnaryCall(PDGrpc.getUpdatePartitionMethod(), request);
        this.handleResponseError(response.getHeader());
        this.invalidPartitionCache();
        return response.getPartitionList();
    }

    public Metapb.Partition delPartition(String graphName, int partitionId) throws PDException {
        Pdpb.DelPartitionRequest request = Pdpb.DelPartitionRequest.newBuilder().setGraphName(graphName).setPartitionId(partitionId).build();
        Pdpb.DelPartitionResponse response = (Pdpb.DelPartitionResponse)this.blockingUnaryCall(PDGrpc.getDelPartitionMethod(), request);
        this.handleResponseError(response.getHeader());
        this.invalidPartitionCache(graphName, partitionId);
        return response.getPartition();
    }

    public void invalidPartitionCache(String graphName, int partitionId) {
        if (null != this.cache.getPartitionById(graphName, partitionId)) {
            this.cache.removePartition(graphName, partitionId);
        }
    }

    public void invalidPartitionCache() {
        this.cache.removePartitions();
    }

    public void invalidStoreCache(long storeId) {
        this.cache.removeStore(storeId);
    }

    public void updatePartitionLeader(String graphName, int partId, long leaderStoreId) {
        KVPair<Metapb.Partition, Metapb.Shard> partShard = null;
        try {
            partShard = this.getPartitionById(graphName, partId);
            if (partShard != null && ((Metapb.Shard)partShard.getValue()).getStoreId() != leaderStoreId) {
                Metapb.ShardGroup shardGroup = this.getShardGroup(partId);
                Metapb.Shard shard = null;
                ArrayList<Metapb.Shard> shards = new ArrayList<Metapb.Shard>();
                for (Metapb.Shard s : shardGroup.getShardsList()) {
                    if (s.getStoreId() == leaderStoreId) {
                        shard = s;
                        shards.add(Metapb.Shard.newBuilder((Metapb.Shard)s).setStoreId(s.getStoreId()).setRole(Metapb.ShardRole.Leader).build());
                        continue;
                    }
                    shards.add(Metapb.Shard.newBuilder((Metapb.Shard)s).setStoreId(s.getStoreId()).setRole(Metapb.ShardRole.Follower).build());
                }
                if (this.config.isEnableCache()) {
                    if (shard == null) {
                        this.cache.removePartition(graphName, partId);
                    } else {
                        this.cache.updateLeader(partId, shard);
                    }
                }
            }
        }
        catch (PDException e) {
            log.error("getPartitionException: {}", (Object)e.getMessage());
        }
    }

    public void updatePartitionCache(Metapb.Partition partition, Metapb.Shard leader) {
        if (this.config.isEnableCache()) {
            this.cache.update(partition.getGraphName(), partition.getId(), partition);
            this.cache.updateLeader(partition.getId(), leader);
        }
    }

    public Pdpb.GetIdResponse getIdByKey(String key, int delta) throws PDException {
        Pdpb.GetIdRequest request = Pdpb.GetIdRequest.newBuilder().setHeader(this.header).setKey(key).setDelta(delta).build();
        Pdpb.GetIdResponse response = (Pdpb.GetIdResponse)this.blockingUnaryCall(PDGrpc.getGetIdMethod(), request);
        this.handleResponseError(response.getHeader());
        return response;
    }

    public Pdpb.ResetIdResponse resetIdByKey(String key) throws PDException {
        Pdpb.ResetIdRequest request = Pdpb.ResetIdRequest.newBuilder().setHeader(this.header).setKey(key).build();
        Pdpb.ResetIdResponse response = (Pdpb.ResetIdResponse)this.blockingUnaryCall(PDGrpc.getResetIdMethod(), request);
        this.handleResponseError(response.getHeader());
        return response;
    }

    public Metapb.Member getLeader() throws PDException {
        Pdpb.GetMembersRequest request = Pdpb.GetMembersRequest.newBuilder().setHeader(this.header).build();
        Pdpb.GetMembersResponse response = (Pdpb.GetMembersResponse)this.blockingUnaryCall(PDGrpc.getGetMembersMethod(), request);
        this.handleResponseError(response.getHeader());
        return response.getLeader();
    }

    public Pdpb.GetMembersResponse getMembers() throws PDException {
        Pdpb.GetMembersRequest request = Pdpb.GetMembersRequest.newBuilder().setHeader(this.header).build();
        Pdpb.GetMembersResponse response = (Pdpb.GetMembersResponse)this.blockingUnaryCall(PDGrpc.getGetMembersMethod(), request);
        this.handleResponseError(response.getHeader());
        return response;
    }

    public Metapb.ClusterStats getClusterStats() throws PDException {
        Pdpb.GetClusterStatsRequest request = Pdpb.GetClusterStatsRequest.newBuilder().setHeader(this.header).build();
        Pdpb.GetClusterStatsResponse response = (Pdpb.GetClusterStatsResponse)this.blockingUnaryCall(PDGrpc.getGetClusterStatsMethod(), request);
        this.handleResponseError(response.getHeader());
        return response.getCluster();
    }

    private <ReqT, RespT, StubT extends AbstractBlockingStub<StubT>> RespT blockingUnaryCall(MethodDescriptor<ReqT, RespT> method, ReqT req) throws PDException {
        return this.blockingUnaryCall(method, req, 1);
    }

    private <ReqT, RespT, StubT extends AbstractBlockingStub<StubT>> RespT blockingUnaryCall(MethodDescriptor<ReqT, RespT> method, ReqT req, int retry) throws PDException {
        PDGrpc.PDBlockingStub stub = this.getStub();
        try {
            Object resp = ClientCalls.blockingUnaryCall((Channel)stub.getChannel(), method, (CallOptions)stub.getCallOptions(), req);
            return (RespT)resp;
        }
        catch (Exception e) {
            log.error(method.getFullMethodName() + " exception, {}", (Object)e.getMessage());
            if (e instanceof StatusRuntimeException) {
                StatusRuntimeException se = (StatusRuntimeException)((Object)e);
                if (retry < this.proxy.getHostCount()) {
                    this.closeStub(true);
                    return this.blockingUnaryCall(method, req, ++retry);
                }
            }
            return null;
        }
    }

    private void handleResponseError(Pdpb.ResponseHeader header) throws PDException {
        Pdpb.ErrorType errorType = header.getError().getType();
        if (header.hasError() && errorType != Pdpb.ErrorType.OK) {
            throw new PDException(header.getError().getTypeValue(), String.format("PD request error, error code = %d, msg = %s", header.getError().getTypeValue(), header.getError().getMessage()));
        }
    }

    public void addEventListener(PDEventListener listener) {
        this.listeners.add(listener);
    }

    public PDWatch getWatchClient() {
        return new PDWatchImpl(this.proxy.getHost(), this.config);
    }

    public List<Metapb.Store> getStoreStatus(boolean offlineExcluded) throws PDException {
        Pdpb.GetAllStoresRequest request = Pdpb.GetAllStoresRequest.newBuilder().setHeader(this.header).setExcludeOfflineStores(offlineExcluded).build();
        Pdpb.GetAllStoresResponse response = this.getStub().getStoreStatus(request);
        this.handleResponseError(response.getHeader());
        List stores = response.getStoresList();
        return stores;
    }

    public void setGraphSpace(String graphSpaceName, long storageLimit) throws PDException {
        Metapb.GraphSpace graphSpace = Metapb.GraphSpace.newBuilder().setName(graphSpaceName).setStorageLimit(storageLimit).setTimestamp(System.currentTimeMillis()).build();
        Pdpb.SetGraphSpaceRequest request = Pdpb.SetGraphSpaceRequest.newBuilder().setHeader(this.header).setGraphSpace(graphSpace).build();
        Pdpb.SetGraphSpaceResponse response = this.getStub().setGraphSpace(request);
        this.handleResponseError(response.getHeader());
    }

    public List<Metapb.GraphSpace> getGraphSpace(String graphSpaceName) throws PDException {
        Pdpb.GetGraphSpaceRequest.Builder builder = Pdpb.GetGraphSpaceRequest.newBuilder();
        builder.setHeader(this.header);
        if (graphSpaceName != null && graphSpaceName.length() > 0) {
            builder.setGraphSpaceName(graphSpaceName);
        }
        Pdpb.GetGraphSpaceRequest request = builder.build();
        Pdpb.GetGraphSpaceResponse response = this.getStub().getGraphSpace(request);
        List graphSpaceList = response.getGraphSpaceList();
        this.handleResponseError(response.getHeader());
        return graphSpaceList;
    }

    public void setPDConfig(int partitionCount, String peerList, int shardCount, long version) throws PDException {
        Metapb.PDConfig pdConfig = Metapb.PDConfig.newBuilder().setPartitionCount(partitionCount).setPeersList(peerList).setShardCount(shardCount).setVersion(version).setTimestamp(System.currentTimeMillis()).build();
        Pdpb.SetPDConfigRequest request = Pdpb.SetPDConfigRequest.newBuilder().setHeader(this.header).setPdConfig(pdConfig).build();
        Pdpb.SetPDConfigResponse response = this.getStub().setPDConfig(request);
        this.handleResponseError(response.getHeader());
    }

    public Metapb.PDConfig getPDConfig() throws PDException {
        Pdpb.GetPDConfigRequest request = Pdpb.GetPDConfigRequest.newBuilder().setHeader(this.header).build();
        Pdpb.GetPDConfigResponse response = this.getStub().getPDConfig(request);
        this.handleResponseError(response.getHeader());
        return response.getPdConfig();
    }

    public void setPDConfig(Metapb.PDConfig pdConfig) throws PDException {
        Pdpb.SetPDConfigRequest request = Pdpb.SetPDConfigRequest.newBuilder().setHeader(this.header).setPdConfig(pdConfig).build();
        Pdpb.SetPDConfigResponse response = this.getStub().setPDConfig(request);
        this.handleResponseError(response.getHeader());
    }

    public Metapb.PDConfig getPDConfig(long version) throws PDException {
        Pdpb.GetPDConfigRequest request = Pdpb.GetPDConfigRequest.newBuilder().setHeader(this.header).setVersion(version).build();
        Pdpb.GetPDConfigResponse response = this.getStub().getPDConfig(request);
        this.handleResponseError(response.getHeader());
        return response.getPdConfig();
    }

    public void changePeerList(String peerList) throws PDException {
        Pdpb.ChangePeerListRequest request = Pdpb.ChangePeerListRequest.newBuilder().setPeerList(peerList).setHeader(this.header).build();
        Pdpb.getChangePeerListResponse response = (Pdpb.getChangePeerListResponse)this.blockingUnaryCall(PDGrpc.getChangePeerListMethod(), request);
        this.handleResponseError(response.getHeader());
    }

    public void splitData() throws PDException {
        Pdpb.SplitDataRequest request = Pdpb.SplitDataRequest.newBuilder().setHeader(this.header).setMode(Pdpb.OperationMode.Auto).build();
        Pdpb.SplitDataResponse response = this.getStub().splitData(request);
        this.handleResponseError(response.getHeader());
    }

    public void splitData(Pdpb.OperationMode mode, List<Pdpb.SplitDataParam> params) throws PDException {
        Pdpb.SplitDataRequest request = Pdpb.SplitDataRequest.newBuilder().setHeader(this.header).setMode(mode).addAllParam(params).build();
        Pdpb.SplitDataResponse response = this.getStub().splitData(request);
        this.handleResponseError(response.getHeader());
    }

    public void splitGraphData(String graphName, int toCount) throws PDException {
        Pdpb.SplitGraphDataRequest request = Pdpb.SplitGraphDataRequest.newBuilder().setHeader(this.header).setGraphName(graphName).setToCount(toCount).build();
        Pdpb.SplitDataResponse response = this.getStub().splitGraphData(request);
        this.handleResponseError(response.getHeader());
    }

    public void balancePartition() throws PDException {
        Pdpb.MovePartitionRequest request = Pdpb.MovePartitionRequest.newBuilder().setHeader(this.header).setMode(Pdpb.OperationMode.Auto).build();
        Pdpb.MovePartitionResponse response = this.getStub().movePartition(request);
        this.handleResponseError(response.getHeader());
    }

    public void movePartition(Pdpb.OperationMode mode, List<Pdpb.MovePartitionParam> params) throws PDException {
        Pdpb.MovePartitionRequest request = Pdpb.MovePartitionRequest.newBuilder().setHeader(this.header).setMode(mode).addAllParam(params).build();
        Pdpb.MovePartitionResponse response = this.getStub().movePartition(request);
        this.handleResponseError(response.getHeader());
    }

    public void reportTask(MetaTask.Task task) throws PDException {
        Pdpb.ReportTaskRequest request = Pdpb.ReportTaskRequest.newBuilder().setHeader(this.header).setTask(task).build();
        Pdpb.ReportTaskResponse response = (Pdpb.ReportTaskResponse)this.blockingUnaryCall(PDGrpc.getReportTaskMethod(), request);
        this.handleResponseError(response.getHeader());
    }

    public Metapb.PartitionStats getPartitionsStats(String graph, int partId) throws PDException {
        Pdpb.GetPartitionStatsRequest request = Pdpb.GetPartitionStatsRequest.newBuilder().setHeader(this.header).setGraphName(graph).setPartitionId(partId).build();
        Pdpb.GetPartitionStatsResponse response = this.getStub().getPartitionStats(request);
        this.handleResponseError(response.getHeader());
        return response.getPartitionStats();
    }

    public void balanceLeaders() throws PDException {
        Pdpb.BalanceLeadersRequest request = Pdpb.BalanceLeadersRequest.newBuilder().setHeader(this.header).build();
        Pdpb.BalanceLeadersResponse response = this.getStub().balanceLeaders(request);
        this.handleResponseError(response.getHeader());
    }

    public Metapb.Store delStore(long storeId) throws PDException {
        Pdpb.DetStoreRequest request = Pdpb.DetStoreRequest.newBuilder().setHeader(this.header).setStoreId(storeId).build();
        Pdpb.DetStoreResponse response = this.getStub().delStore(request);
        this.handleResponseError(response.getHeader());
        return response.getStore();
    }

    public void dbCompaction() throws PDException {
        Pdpb.DbCompactionRequest request = Pdpb.DbCompactionRequest.newBuilder().setHeader(this.header).build();
        Pdpb.DbCompactionResponse response = this.getStub().dbCompaction(request);
        this.handleResponseError(response.getHeader());
    }

    public void dbCompaction(String tableName) throws PDException {
        Pdpb.DbCompactionRequest request = Pdpb.DbCompactionRequest.newBuilder().setHeader(this.header).setTableName(tableName).build();
        Pdpb.DbCompactionResponse response = this.getStub().dbCompaction(request);
        this.handleResponseError(response.getHeader());
    }

    public void combineCluster(int toCount) throws PDException {
        Pdpb.CombineClusterRequest request = Pdpb.CombineClusterRequest.newBuilder().setHeader(this.header).setToCount(toCount).build();
        Pdpb.CombineClusterResponse response = this.getStub().combineCluster(request);
        this.handleResponseError(response.getHeader());
    }

    public void combineGraph(String graphName, int toCount) throws PDException {
        Pdpb.CombineGraphRequest request = Pdpb.CombineGraphRequest.newBuilder().setHeader(this.header).setGraphName(graphName).setToCount(toCount).build();
        Pdpb.CombineGraphResponse response = this.getStub().combineGraph(request);
        this.handleResponseError(response.getHeader());
    }

    public void deleteShardGroup(int groupId) throws PDException {
        Pdpb.DeleteShardGroupRequest request = Pdpb.DeleteShardGroupRequest.newBuilder().setHeader(this.header).setGroupId(groupId).build();
        Pdpb.DeleteShardGroupResponse response = (Pdpb.DeleteShardGroupResponse)this.blockingUnaryCall(PDGrpc.getDeleteShardGroupMethod(), request);
        this.handleResponseError(response.getHeader());
    }

    public void updateShardGroupOp(int groupId, List<Metapb.Shard> shards) throws PDException {
        Pdpb.ChangeShardRequest request = Pdpb.ChangeShardRequest.newBuilder().setHeader(this.header).setGroupId(groupId).addAllShards(shards).build();
        Pdpb.ChangeShardResponse response = this.getStub().updateShardGroupOp(request);
        this.handleResponseError(response.getHeader());
    }

    public void changeShard(int groupId, List<Metapb.Shard> shards) throws PDException {
        Pdpb.ChangeShardRequest request = Pdpb.ChangeShardRequest.newBuilder().setHeader(this.header).setGroupId(groupId).addAllShards(shards).build();
        Pdpb.ChangeShardResponse response = this.getStub().changeShard(request);
        this.handleResponseError(response.getHeader());
    }

    public ClientCache getCache() {
        return this.cache;
    }

    public Pdpb.CacheResponse getClientCache() throws PDException {
        Pdpb.GetGraphRequest request = Pdpb.GetGraphRequest.newBuilder().setHeader(this.header).build();
        Pdpb.CacheResponse cache = this.getStub().getCache(request);
        this.handleResponseError(cache.getHeader());
        return cache;
    }

    public Pdpb.CachePartitionResponse getPartitionCache(String graph) throws PDException {
        Pdpb.GetGraphRequest request = Pdpb.GetGraphRequest.newBuilder().setHeader(this.header).setGraphName(graph).build();
        Pdpb.CachePartitionResponse ps = this.getStub().getPartitions(request);
        this.handleResponseError(ps.getHeader());
        return ps;
    }

    public void updatePdRaft(String raftConfig) throws PDException {
        Pdpb.UpdatePdRaftRequest request = Pdpb.UpdatePdRaftRequest.newBuilder().setHeader(this.header).setConfig(raftConfig).build();
        Pdpb.UpdatePdRaftResponse response = this.getStub().updatePdRaft(request);
        this.handleResponseError(response.getHeader());
    }

    public Pdpb.GraphStatsResponse getGraphStats(String graphName) throws PDException {
        Pdpb.GetGraphRequest request = Pdpb.GetGraphRequest.newBuilder().setHeader(this.header).setGraphName(graphName).build();
        Pdpb.GraphStatsResponse graphStats = this.getStub().getGraphStats(request);
        this.handleResponseError(graphStats.getHeader());
        return graphStats;
    }

    public long submitBuildIndexTask(Metapb.BuildIndexParam param) throws PDException {
        Pdpb.IndexTaskCreateRequest request = Pdpb.IndexTaskCreateRequest.newBuilder().setHeader(this.header).setParam(param).build();
        Pdpb.IndexTaskCreateResponse response = this.getStub().submitTask(request);
        this.handleResponseError(response.getHeader());
        return response.getTaskId();
    }

    public Pdpb.IndexTaskQueryResponse queryBuildIndexTaskStatus(long taskId) throws PDException {
        Pdpb.IndexTaskQueryRequest request = Pdpb.IndexTaskQueryRequest.newBuilder().setHeader(this.header).setTaskId(taskId).build();
        Pdpb.IndexTaskQueryResponse response = this.getStub().queryTaskState(request);
        this.handleResponseError(response.getHeader());
        return response;
    }

    public Pdpb.IndexTaskQueryResponse retryBuildIndexTask(long taskId) throws PDException {
        Pdpb.IndexTaskQueryRequest request = Pdpb.IndexTaskQueryRequest.newBuilder().setHeader(this.header).setTaskId(taskId).build();
        Pdpb.IndexTaskQueryResponse response = this.getStub().retryIndexTask(request);
        this.handleResponseError(response.getHeader());
        return response;
    }
}

