/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.pd.client;

import java.io.Closeable;
import java.util.function.Consumer;
import org.apache.hugegraph.pd.grpc.pulse.PartitionHeartbeatRequest;
import org.apache.hugegraph.pd.grpc.pulse.PulseResponse;
import org.apache.hugegraph.pd.pulse.PulseServerNotice;

public interface PDPulse {
    public static <T> Listener<T> listener(Consumer<T> onNext) {
        return PDPulse.listener(onNext, t -> {}, () -> {});
    }

    public static <T> Listener<T> listener(Consumer<T> onNext, Consumer<Throwable> onError) {
        return PDPulse.listener(onNext, onError, () -> {});
    }

    public static <T> Listener<T> listener(Consumer<T> onNext, Runnable onCompleted) {
        return PDPulse.listener(onNext, t -> {}, onCompleted);
    }

    public static <T> Listener<T> listener(final Consumer<T> onNext, final Consumer<Throwable> onError, final Runnable onCompleted) {
        return new Listener<T>(){

            @Override
            public void onNext(T response) {
                onNext.accept(response);
            }

            @Override
            public void onNotice(PulseServerNotice<T> notice) {
            }

            @Override
            public void onError(Throwable throwable) {
                onError.accept(throwable);
            }

            @Override
            public void onCompleted() {
                onCompleted.run();
            }
        };
    }

    public Notifier<PartitionHeartbeatRequest.Builder> connectPartition(Listener<PulseResponse> var1);

    public boolean resetStub(String var1, Notifier var2);

    public static interface Notifier<T>
    extends Closeable {
        @Override
        public void close();

        public void notifyServer(T var1);

        public void crash(String var1);
    }

    public static interface Listener<T> {
        @Deprecated
        default public void onNext(T response) {
        }

        default public void onNotice(PulseServerNotice<T> notice) {
            notice.ack();
        }

        public void onError(Throwable var1);

        public void onCompleted();
    }
}

