/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.pd.client.impl;

import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.google.protobuf.GeneratedMessageV3;
import io.grpc.stub.StreamObserver;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import org.apache.hugegraph.pd.client.PDConnectionManager;
import org.apache.hugegraph.pd.client.PDPulse;
import org.apache.hugegraph.pd.common.HgAssert;
import org.apache.hugegraph.pd.grpc.pulse.HgPdPulseGrpc;
import org.apache.hugegraph.pd.grpc.pulse.PartitionHeartbeatRequest;
import org.apache.hugegraph.pd.grpc.pulse.PulseAckRequest;
import org.apache.hugegraph.pd.grpc.pulse.PulseCreateRequest;
import org.apache.hugegraph.pd.grpc.pulse.PulseNoticeRequest;
import org.apache.hugegraph.pd.grpc.pulse.PulseRequest;
import org.apache.hugegraph.pd.grpc.pulse.PulseResponse;
import org.apache.hugegraph.pd.grpc.pulse.PulseType;
import org.apache.hugegraph.pd.pulse.PartitionNotice;
import org.apache.hugegraph.pd.pulse.PulseServerNotice;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PDPulseImpl2
implements PDPulse {
    private static final Logger log = LoggerFactory.getLogger(PDPulseImpl2.class);
    private static final long RECONNECT_WAITING_SEC = 3L;
    private static final ExecutorService reconnectPool = Executors.newSingleThreadExecutor(new ThreadFactoryBuilder().setDaemon(true).setNameFormat("reconnecting-server-pool-%d").build());
    private final PDConnectionManager connectionManager;
    private final Map<PulseType, PDPulse.Listener<PulseResponse>> listenerMap = new ConcurrentHashMap<PulseType, PDPulse.Listener<PulseResponse>>();
    private final Map<PulseType, Sender<?>> senderMap = new ConcurrentHashMap();
    private final Map<PulseType, Receiver> receiverMap = new ConcurrentHashMap<PulseType, Receiver>();
    private final Map<PulseType, Function<PulseResponse, PulseServerNotice<PulseResponse>>> noticeParserMap = new HashMap<PulseType, Function<PulseResponse, PulseServerNotice<PulseResponse>>>();
    private final ExecutorService threadPool;
    private final byte[] lock = new byte[0];
    private final AtomicBoolean isReconnecting = new AtomicBoolean();

    public PDPulseImpl2(PDConnectionManager connectionManager) {
        HgAssert.isArgumentNotNull((Object)connectionManager, (String)"PDConnectionManager");
        this.connectionManager = connectionManager;
        this.threadPool = Executors.newSingleThreadExecutor(new ThreadFactoryBuilder().setNameFormat("ack-notice-pool-%d").build());
        this.init();
    }

    private void init() {
        this.noticeParserMap.put(PulseType.PULSE_TYPE_PARTITION_HEARTBEAT, this::toPartitionNotice);
        this.connectionManager.addReconnectionTask(this::reconnectServer);
    }

    @Override
    public PDPulse.Notifier<PartitionHeartbeatRequest.Builder> connectPartition(PDPulse.Listener<PulseResponse> listener) {
        HgAssert.isArgumentNotNull(listener, (String)"listener");
        this.listenerMap.put(PulseType.PULSE_TYPE_PARTITION_HEARTBEAT, listener);
        return this.connectServer(PulseType.PULSE_TYPE_PARTITION_HEARTBEAT, PartitionHeartbeatRequest.Builder.class);
    }

    @Override
    public boolean resetStub(String host, PDPulse.Notifier notifier) {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private <T extends GeneratedMessageV3.Builder<PartitionHeartbeatRequest.Builder>> Sender<T> connectServer(PulseType pulseType, Class<T> t) {
        Sender sender = this.senderMap.get(pulseType);
        if (sender != null) return sender;
        byte[] byArray = this.lock;
        synchronized (this.lock) {
            return this.senderMap.computeIfAbsent(pulseType, k -> new Sender<GeneratedMessageV3.Builder>(pulseType, this.newServerObserver(pulseType), this::toNotifyServerReq));
        }
    }

    public void reconnectServer() {
        if (this.isReconnecting.get()) {
            log.info("[PULSE] Already in reconnecting state, skip reconnectServer");
            return;
        }
        reconnectPool.execute(this::reconnecting);
    }

    private void reconnecting() {
        if (!this.isReconnecting.compareAndSet(false, true)) {
            log.info("[PULSE] Already in reconnecting state, skip reconnecting");
            return;
        }
        log.info("[PULSE] Try to reconnect server...");
        AtomicBoolean isConnected = new AtomicBoolean(false);
        int count = 0;
        while (!isConnected.get()) {
            log.info("[PULSE] The [ {} ]th attempt to connect...", (Object)(++count));
            boolean allDone = this.senderMap.entrySet().stream().allMatch(this::doEntryReconnect);
            if (allDone) {
                isConnected.set(true);
                break;
            }
            log.error("[PULSE] Failed to reconnect to the server; waiting [ {} ] seconds for the next attempt.", (Object)3L);
            isConnected.set(false);
            try {
                Thread.sleep(3000L);
            }
            catch (InterruptedException e) {
                log.error("[PULSE] Failed to sleep thread and cancel the reconnecting process.", (Throwable)e);
                break;
            }
        }
        this.isReconnecting.set(false);
        if (isConnected.get()) {
            log.info("[PULSE] Reconnect server successfully!");
        } else {
            log.error("[PULSE] Reconnect server failed!");
        }
    }

    private boolean doEntryReconnect(Map.Entry<PulseType, Sender<?>> entry) {
        PulseType pulseType = entry.getKey();
        Sender<?> sender = entry.getValue();
        try {
            sender.close();
            sender.setReqStream(this.newServerObserver(pulseType));
            return true;
        }
        catch (Exception e) {
            log.error("[PULSE] Failed to reconnect server with pulse [ {} ], caused by: ", (Object)pulseType, (Object)e);
            return false;
        }
    }

    private StreamObserver<PulseRequest> newServerObserver(PulseType pulseType) {
        HgPdPulseGrpc.HgPdPulseStub stub = this.connectionManager.newStub(HgPdPulseGrpc::newStub);
        Receiver receiver = this.receiverMap.compute(pulseType, (k, v) -> new Receiver((PulseType)k));
        return stub.pulse((StreamObserver)receiver);
    }

    private <T> PulseRequest toNotifyServerReq(T requestBuilder) {
        PulseNoticeRequest.Builder builder = PulseNoticeRequest.newBuilder();
        if (!PartitionHeartbeatRequest.Builder.class.isInstance(requestBuilder)) {
            throw new IllegalStateException("Unregistered request type: " + String.valueOf(requestBuilder.getClass()));
        }
        builder.setPartitionHeartbeatRequest((PartitionHeartbeatRequest.Builder)requestBuilder);
        return PulseRequest.newBuilder().setNoticeRequest(builder).build();
    }

    private PDPulse.Listener<PulseResponse> getListener(PulseType pulseType) {
        return this.listenerMap.get(pulseType);
    }

    private PulseServerNotice<PulseResponse> toPartitionNotice(PulseResponse pulseResponse) {
        return new PartitionNotice(pulseResponse.getNoticeId(), e -> this.ackNotice(PulseType.PULSE_TYPE_PARTITION_HEARTBEAT, pulseResponse.getNoticeId(), pulseResponse.getObserverId()), pulseResponse);
    }

    private void handleOnNext(PulseType pulseType, PulseResponse response) {
        Function<PulseResponse, PulseServerNotice<PulseResponse>> parser = this.noticeParserMap.get(pulseType);
        if (parser == null) {
            log.error("[PULSE] Notice parser is null, pulse type: {}", (Object)pulseType);
            throw new IllegalStateException("Notice parser is null, pulse type: " + String.valueOf(pulseType));
        }
        PulseServerNotice<PulseResponse> notice = parser.apply(response);
        PDPulse.Listener<PulseResponse> listener = this.getListener(pulseType);
        if (listener != null) {
            try {
                listener.onNext(response);
                listener.onNotice(notice);
            }
            catch (Throwable e) {
                log.error("[PULSE] Listener failed to handle notice: \n{}, caused by: ", (Object)response, (Object)e);
            }
        }
    }

    private void handleOnComplete(PulseType pulseType) {
    }

    private void handleOnError(PulseType pulseType, Throwable t) {
        this.reconnectServer();
    }

    private void ackNotice(PulseType pulseType, long noticeId, long observerId) {
        Sender<?> sender = this.senderMap.get(pulseType);
        if (sender == null) {
            log.error("[PULSE] Sender is null, pulse type: {}", (Object)pulseType);
            throw new IllegalStateException("Sender is null, pulse type: " + String.valueOf(pulseType));
        }
        this.sendingAck(sender, noticeId, observerId);
    }

    private void sendingAck(Sender<?> sender, long noticeId, long observerId) {
        this.threadPool.execute(() -> {
            log.info("[PULSE] Sending ack, notice id: {}, observer id: {}, ts: {}", new Object[]{noticeId, observerId, System.currentTimeMillis()});
            sender.ack(noticeId, observerId);
        });
    }

    private class Sender<T>
    implements PDPulse.Notifier<T> {
        private final PulseType pulseType;
        private final Function<T, PulseRequest> notifyServerProvider;
        private final AtomicBoolean isClosed = new AtomicBoolean(false);
        private AtomicReference<StreamObserver<PulseRequest>> reqStream = new AtomicReference();

        public Sender(PulseType pulseType, StreamObserver<PulseRequest> reqStream, Function<T, PulseRequest> notifyServerProvider) {
            this.pulseType = pulseType;
            this.notifyServerProvider = notifyServerProvider;
            this.setReqStream(reqStream);
        }

        public void setReqStream(StreamObserver<PulseRequest> reqStream) {
            this.reqStream.set(reqStream);
            this.start();
            this.isClosed.set(false);
        }

        void start() {
            this.send(PulseRequest.newBuilder().setCreateRequest(PulseCreateRequest.newBuilder().setPulseType(this.pulseType)));
        }

        void ack(long noticeId, long observerId) {
            this.send(PulseRequest.newBuilder().setAckRequest(PulseAckRequest.newBuilder().setNoticeId(noticeId).setObserverId(observerId)));
        }

        private void send(PulseRequest.Builder builder) {
            this.reqStream.get().onNext((Object)builder.build());
        }

        @Override
        public void close() {
            if (this.isClosed.get()) {
                return;
            }
            this.isClosed.set(true);
            try {
                this.reqStream.get().onCompleted();
            }
            catch (Throwable e) {
                log.error("[PULSE] Sender failed to invoke [onCompleted], caused by: ", e);
            }
        }

        @Override
        public void notifyServer(T request) {
            HgAssert.isArgumentNotNull(request, (String)"request");
            try {
                this.reqStream.get().onNext((Object)this.notifyServerProvider.apply(request));
            }
            catch (Throwable e) {
                log.error("[PULSE] Sender failed to invoke [notifyServer], caused by: ", e);
                throw new RuntimeException(e);
            }
        }

        @Override
        public void crash(String error) {
            this.isClosed.set(true);
            this.reqStream.get().onError(new Throwable(error));
        }
    }

    private class Receiver
    implements StreamObserver<PulseResponse> {
        private final PulseType pulseType;

        Receiver(PulseType pulseType) {
            this.pulseType = pulseType;
        }

        public void onNext(PulseResponse pulseResponse) {
            log.info("[PULSE] Receiving a notice [ {} ], notice_id: {}, observer_id: {}", new Object[]{pulseResponse.getPulseType(), pulseResponse.getNoticeId(), pulseResponse.getObserverId()});
            PDPulseImpl2.this.handleOnNext(this.pulseType, pulseResponse);
        }

        public void onError(Throwable t) {
            log.error("[PULSE] Receiving an [ onError ], pulse type: {}, error:", (Object)this.pulseType, (Object)t);
            PDPulseImpl2.this.handleOnError(this.pulseType, t);
        }

        public void onCompleted() {
            log.info("[PULSE] Receiving an [ onCompleted ], pulse type: {}", (Object)this.pulseType);
            PDPulseImpl2.this.handleOnComplete(this.pulseType);
        }
    }
}

