/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.backend.store.palo;

import java.util.List;
import java.util.stream.Collectors;
import org.apache.hugegraph.backend.store.BackendStoreProvider;
import org.apache.hugegraph.backend.store.BackendTable;
import org.apache.hugegraph.backend.store.mysql.MysqlStore;
import org.apache.hugegraph.backend.store.palo.PaloSessions;
import org.apache.hugegraph.config.HugeConfig;
import org.apache.hugegraph.util.Log;
import org.slf4j.Logger;

public abstract class PaloStore
extends MysqlStore {
    private static final Logger LOG = Log.logger(PaloStore.class);

    public PaloStore(BackendStoreProvider provider, String database, String name) {
        super(provider, database, name);
    }

    protected PaloSessions openSessionPool(HugeConfig config) {
        LOG.info("Open palo session pool for {}", (Object)this);
        return new PaloSessions(config, this.database(), this.store(), this.tableNames());
    }

    private List<String> tableNames() {
        return this.tables().stream().map(BackendTable::table).collect(Collectors.toList());
    }
}

