/*
 * Decompiled with CFR 0.152.
 */
package org.caffinitas.ohc.linked;

import java.lang.reflect.InvocationTargetException;
import org.caffinitas.ohc.HashAlgorithm;
import org.caffinitas.ohc.linked.Crc32Hash;
import org.caffinitas.ohc.linked.Crc32cHash;
import org.caffinitas.ohc.linked.Murmur3Hash;
import org.caffinitas.ohc.linked.XxHash;

abstract class Hasher {
    Hasher() {
    }

    static Hasher create(HashAlgorithm hashAlgorithm) {
        switch (hashAlgorithm) {
            case XX: {
                try {
                    return new XxHash();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            case CRC32C: {
                try {
                    return Crc32cHash.newInstance();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            case CRC32: {
                return new Crc32Hash();
            }
            case MURMUR3: {
                return new Murmur3Hash();
            }
        }
        throw new UnsupportedOperationException("Incomplete implementation of Hasher.create()");
    }

    private static Hasher newHasher(HashAlgorithm hashAlgorithm) throws InstantiationException, IllegalAccessException, InvocationTargetException, NoSuchMethodException, ClassNotFoundException {
        String cls = Hasher.forAlg(hashAlgorithm);
        return (Hasher)Class.forName(cls).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
    }

    private static String forAlg(HashAlgorithm hashAlgorithm) {
        return Hasher.class.getName().substring(0, Hasher.class.getName().lastIndexOf(46) + 1) + hashAlgorithm.name().charAt(0) + hashAlgorithm.name().substring(1).toLowerCase() + "Hash";
    }

    abstract long hash(byte[] var1);

    abstract long hash(long var1, long var3, int var5);
}

