/*
 * Decompiled with CFR 0.152.
 */
package org.caffinitas.ohc.linked;

import java.nio.ByteBuffer;
import java.util.Arrays;
import org.caffinitas.ohc.linked.HashEntries;
import org.caffinitas.ohc.linked.Hasher;
import org.caffinitas.ohc.linked.Uns;

final class KeyBuffer {
    final byte[] buffer;
    private long hash;

    KeyBuffer(int size) {
        this.buffer = new byte[size];
    }

    long hash() {
        return this.hash;
    }

    KeyBuffer finish(Hasher hasher) {
        this.hash = hasher.hash(this.buffer);
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        KeyBuffer keyBuffer = (KeyBuffer)o;
        return this.buffer.length == keyBuffer.buffer.length && Arrays.equals(keyBuffer.buffer, this.buffer);
    }

    public int hashCode() {
        return (int)this.hash;
    }

    private static String pad(int val) {
        String str = Integer.toHexString(val & 0xFF);
        while (str.length() == 1) {
            str = '0' + str;
        }
        return str;
    }

    public String toString() {
        byte[] b = this.buffer;
        StringBuilder sb = new StringBuilder(b.length * 3);
        for (int ii = 0; ii < b.length; ++ii) {
            if (ii % 8 == 0 && ii != 0) {
                sb.append('\n');
            }
            sb.append(KeyBuffer.pad(b[ii]));
            sb.append(' ');
        }
        return sb.toString();
    }

    ByteBuffer byteBuffer() {
        return ByteBuffer.wrap(this.buffer);
    }

    boolean sameKey(long hashEntryAdr) {
        if (HashEntries.getHash(hashEntryAdr) != this.hash()) {
            return false;
        }
        long serKeyLen = HashEntries.getKeyLen(hashEntryAdr);
        return serKeyLen == (long)this.buffer.length && this.compareKey(hashEntryAdr);
    }

    private boolean compareKey(long hashEntryAdr) {
        int blkOff = 64;
        int p = 0;
        int endIdx = this.buffer.length - 1;
        while (p <= endIdx - 8) {
            if (Uns.getLong(hashEntryAdr, blkOff) != Uns.getLongFromByteArray(this.buffer, p)) {
                return false;
            }
            p += 8;
            blkOff += 8;
        }
        while (p <= endIdx - 4) {
            if (Uns.getInt(hashEntryAdr, blkOff) != Uns.getIntFromByteArray(this.buffer, p)) {
                return false;
            }
            p += 4;
            blkOff += 4;
        }
        while (p <= endIdx - 2) {
            if (Uns.getShort(hashEntryAdr, blkOff) != Uns.getShortFromByteArray(this.buffer, p)) {
                return false;
            }
            p += 2;
            blkOff += 2;
        }
        while (p < endIdx) {
            if (Uns.getByte(hashEntryAdr, blkOff) != this.buffer[p]) {
                return false;
            }
            ++p;
            ++blkOff;
        }
        return true;
    }
}

