/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ozhera.monitor.controller;

import com.xiaomi.mone.tpc.login.util.UserUtil;
import com.xiaomi.mone.tpc.login.vo.AuthUserVo;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.apache.ozhera.monitor.bo.AlertHistory;
import org.apache.ozhera.monitor.bo.AlertHistoryDetailed;
import org.apache.ozhera.monitor.bo.AlertHistoryParam;
import org.apache.ozhera.monitor.result.ErrorCode;
import org.apache.ozhera.monitor.result.Result;
import org.apache.ozhera.monitor.service.AlertHistoryService;
import org.apache.ozhera.monitor.service.model.PageData;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/history"})
public class AlertHistoryController {
    private static final Logger log = LoggerFactory.getLogger(AlertHistoryController.class);
    @Autowired
    private AlertHistoryService alertHistoryService;

    @RequestMapping(value={"/metric/query"})
    public Result<PageData<List<AlertHistory>>> metricQuery(HttpServletRequest request, @RequestBody AlertHistoryParam param) {
        AuthUserVo userInfo = null;
        try {
            log.info("AlertHistoryController.metricQuery param : {} ", (Object)param);
            param.pageQryInit();
            userInfo = UserUtil.getUser();
            if (userInfo == null) {
                log.info("AlertHistoryController.metricQuery request info error no user info found! param : {} ", (Object)param);
                return Result.fail((ErrorCode)ErrorCode.unknownError);
            }
            String user = userInfo.genFullAccount();
            log.info("AlertHistoryController.metricQuery param : {} ,user : {}", (Object)param, (Object)user);
            return this.alertHistoryService.metricList(user, param);
        }
        catch (Exception e) {
            log.error("AlertHistoryController.metricQuery\u5f02\u5e38 param : {} ,userInfo :{}", new Object[]{param, userInfo, e});
            return Result.fail((ErrorCode)ErrorCode.unknownError);
        }
    }

    @Deprecated
    @RequestMapping(value={"/metric/detailed"})
    public Result<AlertHistoryDetailed> metricDetailed(HttpServletRequest request, @RequestBody AlertHistoryParam param) {
        AuthUserVo userInfo = null;
        try {
            log.info("AlertHistoryController.metricDetailed param : {} ", (Object)param);
            if (StringUtils.isBlank((CharSequence)param.getId()) || param.getIamTreeId() == null) {
                log.info("AlertHistoryController.metricDetailed request info error no arg error! param : {} ", (Object)param);
                return Result.fail((ErrorCode)ErrorCode.invalidParamError);
            }
            userInfo = UserUtil.getUser();
            if (userInfo == null) {
                log.info("AlertHistoryController.metricDetailed request info error no user info found! param : {} ", (Object)param);
                return Result.fail((ErrorCode)ErrorCode.unknownError);
            }
            String user = userInfo.genFullAccount();
            log.info("AlertHistoryController.metricDetailed param : {} ,user : {}", (Object)param, (Object)user);
            return this.alertHistoryService.metricDetailed(user, param);
        }
        catch (Exception e) {
            log.error("AlertHistoryController.metricDetailed\u5f02\u5e38 param : {} ,userInfo :{}", new Object[]{param, userInfo, e});
            return Result.fail((ErrorCode)ErrorCode.unknownError);
        }
    }

    @Deprecated
    @RequestMapping(value={"/metric/resolved"})
    public Result metricResolved(HttpServletRequest request, @RequestBody AlertHistoryParam param) {
        AuthUserVo userInfo = null;
        try {
            log.info("AlertHistoryController.metricResolved param : {} ", (Object)param);
            if (StringUtils.isNotBlank((CharSequence)param.getAlertName()) || StringUtils.isNotBlank((CharSequence)param.getComment()) || param.getIamTreeId() == null || param.getStartTime() == null || param.getEndTime() == null) {
                log.info("AlertHistoryController.metricResolved request info error no arg error! param : {} ", (Object)param);
                return Result.fail((ErrorCode)ErrorCode.invalidParamError);
            }
            userInfo = UserUtil.getUser();
            if (userInfo == null) {
                log.info("AlertHistoryController.metricResolved request info error no user info found! param : {} ", (Object)param);
                return Result.fail((ErrorCode)ErrorCode.unknownError);
            }
            String user = userInfo.genFullAccount();
            log.info("AlertHistoryController.metricResolved param : {} ,user : {}", (Object)param, (Object)user);
            return this.alertHistoryService.metricResolved(user, param);
        }
        catch (Exception e) {
            log.error("AlertHistoryController.metricResolved\u5f02\u5e38 param : {} ,userInfo :{}", new Object[]{param, userInfo, e});
            return Result.fail((ErrorCode)ErrorCode.unknownError);
        }
    }
}

