/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ozhera.app.service.impl;

import com.google.gson.Gson;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.ozhera.app.api.model.HeraAppBaseInfoModel;
import org.apache.ozhera.app.api.model.HeraAppBaseInfoParticipant;
import org.apache.ozhera.app.api.model.HeraAppBaseQuery;
import org.apache.ozhera.app.dao.HeraBaseInfoDao;
import org.apache.ozhera.app.model.HeraAppBaseInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class HeraAppBaseInfoService {
    private static final Logger log = LoggerFactory.getLogger(HeraAppBaseInfoService.class);
    @Autowired
    HeraBaseInfoDao heraBaseInfoDao;

    public HeraAppBaseInfo queryById(Long id) {
        return this.heraBaseInfoDao.getById(id.intValue());
    }

    public Long count(HeraAppBaseInfoModel baseInfo) {
        return this.heraBaseInfoDao.count(baseInfo);
    }

    public List<HeraAppBaseInfo> query(HeraAppBaseInfoModel baseInfo, Integer pageCount, Integer pageNum) {
        return this.heraBaseInfoDao.query(baseInfo, pageCount, pageNum);
    }

    public HeraAppBaseInfo getById(Integer id) {
        return this.heraBaseInfoDao.getById(id);
    }

    public int delById(Integer id) {
        return this.heraBaseInfoDao.delById(id);
    }

    public int create(HeraAppBaseInfo heraAppBaseInfo) {
        return this.heraBaseInfoDao.create(heraAppBaseInfo);
    }

    public int update(HeraAppBaseInfo heraAppBaseInfo) {
        return this.heraBaseInfoDao.update(heraAppBaseInfo);
    }

    public void deleAppByBindIdAndPlat(String bindId, Integer plat) {
        if (StringUtils.isBlank((CharSequence)bindId) || plat == null) {
            log.error("invalid param,bindId:{},plat:{}", (Object)bindId, (Object)plat);
            return;
        }
        HeraAppBaseInfoModel query = new HeraAppBaseInfoModel();
        query.setBindId(bindId);
        query.setPlatformType(plat);
        List<HeraAppBaseInfo> list = this.heraBaseInfoDao.query(query, null, null);
        if (CollectionUtils.isEmpty(list)) {
            log.info("deleAppByBindIdAndPlat no data found! bindId:{},plat:{}", (Object)bindId, (Object)plat);
        }
        for (HeraAppBaseInfo baseInfo : list) {
            Integer integer = this.heraBaseInfoDao.delById(baseInfo.getId());
            if (integer > 0) {
                log.info("deleAppByBindIdAndPlat success!baseInfo:{}", (Object)new Gson().toJson((Object)baseInfo));
                continue;
            }
            log.error("deleAppByBindIdAndPlat success!baseInfo:{}", (Object)new Gson().toJson((Object)baseInfo));
        }
    }

    public Long countByParticipant(HeraAppBaseQuery query) {
        if (!"yes".equals(query.getMyParticipant())) {
            query.setMyParticipant(null);
        }
        if (StringUtils.isBlank((CharSequence)query.getAppName())) {
            query.setAppName(null);
        }
        Long aLong = this.heraBaseInfoDao.countByParticipant(query);
        log.info("countByParticipant query:{},result:{}", (Object)query.toString(), (Object)aLong);
        return aLong;
    }

    public List<HeraAppBaseInfoParticipant> queryByParticipant(HeraAppBaseQuery query) {
        if (!"yes".equals(query.getMyParticipant())) {
            query.setMyParticipant(null);
        }
        if (StringUtils.isBlank((CharSequence)query.getAppName())) {
            query.setAppName(null);
        }
        List<HeraAppBaseInfoParticipant> heraAppBaseInfoParticipants = this.heraBaseInfoDao.queryByParticipant(query);
        log.info("queryByParticipant query:{},result:{}", (Object)new Gson().toJson((Object)query), (Object)new Gson().toJson(heraAppBaseInfoParticipants));
        return heraAppBaseInfoParticipants;
    }
}

