/*
 * Decompiled with CFR 0.152.
 */
package org.mybatis.generator.runtime.dynamic.sql.elements;

import java.util.HashSet;
import org.mybatis.generator.api.dom.java.FullyQualifiedJavaType;
import org.mybatis.generator.api.dom.java.Interface;
import org.mybatis.generator.api.dom.java.Method;
import org.mybatis.generator.api.dom.java.Parameter;
import org.mybatis.generator.runtime.dynamic.sql.elements.AbstractMethodGenerator;
import org.mybatis.generator.runtime.dynamic.sql.elements.FragmentGenerator;
import org.mybatis.generator.runtime.dynamic.sql.elements.MethodAndImports;
import org.mybatis.generator.runtime.dynamic.sql.elements.MethodParts;

public class BasicSelectOneMethodGenerator
extends AbstractMethodGenerator {
    private FullyQualifiedJavaType recordType;
    private String resultMapId;
    private FragmentGenerator fragmentGenerator;

    private BasicSelectOneMethodGenerator(Builder builder) {
        super(builder);
        this.recordType = builder.recordType;
        this.resultMapId = builder.resultMapId;
        this.fragmentGenerator = builder.fragmentGenerator;
    }

    @Override
    public MethodAndImports generateMethodAndImports() {
        if (!this.introspectedTable.getRules().generateSelectByPrimaryKey()) {
            return null;
        }
        HashSet<FullyQualifiedJavaType> imports = new HashSet<FullyQualifiedJavaType>();
        boolean reuseResultMap = this.introspectedTable.getRules().generateSelectByExampleWithBLOBs() || this.introspectedTable.getRules().generateSelectByExampleWithoutBLOBs();
        FullyQualifiedJavaType parameterType = new FullyQualifiedJavaType("org.mybatis.dynamic.sql.select.render.SelectStatementProvider");
        FullyQualifiedJavaType adapter = new FullyQualifiedJavaType("org.mybatis.dynamic.sql.util.SqlProviderAdapter");
        FullyQualifiedJavaType annotation = new FullyQualifiedJavaType("org.apache.ibatis.annotations.SelectProvider");
        imports.add(parameterType);
        imports.add(adapter);
        imports.add(annotation);
        Method method = new Method("selectOne");
        imports.add(this.recordType);
        method.setReturnType(this.recordType);
        method.addParameter(new Parameter(parameterType, "selectStatement"));
        this.context.getCommentGenerator().addGeneralMethodAnnotation(method, this.introspectedTable, imports);
        method.addAnnotation("@SelectProvider(type=SqlProviderAdapter.class, method=\"select\")");
        MethodAndImports.Builder builder = MethodAndImports.withMethod(method).withImports(imports);
        if (this.introspectedTable.isConstructorBased()) {
            MethodParts methodParts = this.fragmentGenerator.getAnnotatedConstructorArgs();
            this.acceptParts(builder, method, methodParts);
        } else if (reuseResultMap) {
            FullyQualifiedJavaType rmAnnotation = new FullyQualifiedJavaType("org.apache.ibatis.annotations.ResultMap");
            builder.withImport(rmAnnotation);
            method.addAnnotation("@ResultMap(\"" + this.resultMapId + "\")");
        } else {
            MethodParts methodParts = this.fragmentGenerator.getAnnotatedResults();
            this.acceptParts(builder, method, methodParts);
        }
        return builder.build();
    }

    @Override
    public boolean callPlugins(Method method, Interface interfaze) {
        return true;
    }

    public static class Builder
    extends AbstractMethodGenerator.BaseBuilder<Builder, BasicSelectOneMethodGenerator> {
        private FullyQualifiedJavaType recordType;
        private String resultMapId;
        private FragmentGenerator fragmentGenerator;

        public Builder withRecordType(FullyQualifiedJavaType recordType) {
            this.recordType = recordType;
            return this;
        }

        public Builder withResultMapId(String resultMapId) {
            this.resultMapId = resultMapId;
            return this;
        }

        public Builder withFragmentGenerator(FragmentGenerator fragmentGenerator) {
            this.fragmentGenerator = fragmentGenerator;
            return this;
        }

        @Override
        public Builder getThis() {
            return this;
        }

        @Override
        public BasicSelectOneMethodGenerator build() {
            return new BasicSelectOneMethodGenerator(this);
        }
    }
}

