/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ozhera.log.stream.job.extension;

import com.xiaomi.youpin.docean.anno.Component;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.apache.ozhera.log.stream.job.LogSendFilter;
import org.apache.ozhera.log.stream.plugin.nacos.LevelFilterConfigListener;
import org.apache.ozhera.log.stream.plugin.nacos.LogFilterConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component
public class DefaultLogSendFilter
implements LogSendFilter {
    private static final Logger log = LoggerFactory.getLogger(DefaultLogSendFilter.class);
    @Resource
    private LevelFilterConfigListener configListener;

    @Override
    public boolean sendMessageSwitch(Map<String, Object> dataMap) {
        try {
            LogFilterConfig logFilterConfig;
            Long tailId = DefaultLogSendFilter.extractTailId(dataMap);
            if (null != tailId && (logFilterConfig = this.configListener.queryFilterConfig(tailId)) != null && logFilterConfig.isEnableFilter()) {
                return this.shouldSendMessage(dataMap, logFilterConfig.getLogFieldFilterList());
            }
        }
        catch (Exception e) {
            log.error("sendMessageSwitch error", (Throwable)e);
        }
        return true;
    }

    private static Long extractTailId(Map<String, Object> dataMap) {
        Object tailIdObj = dataMap.get("tailId");
        if (null == tailIdObj || StringUtils.isEmpty((CharSequence)String.valueOf(tailIdObj))) {
            return null;
        }
        if (tailIdObj instanceof Long) {
            return (Long)tailIdObj;
        }
        return Long.valueOf(String.valueOf(tailIdObj));
    }

    private boolean shouldSendMessage(Map<String, Object> dataMap, List<LogFilterConfig.LogFieldFilter> fieldFilterList) {
        for (LogFilterConfig.LogFieldFilter logFieldFilter : fieldFilterList) {
            Object fieldValue = dataMap.get(logFieldFilter.getLogField());
            if (fieldValue == null || !fieldValue.toString().equals(logFieldFilter.getFilterKeyWord())) continue;
            return false;
        }
        return true;
    }
}

