/*
 * Decompiled with CFR 0.152.
 */
package com.xiaomi.data.push.rpc;

import com.alibaba.nacos.api.exception.NacosException;
import com.alibaba.nacos.api.naming.pojo.Instance;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.xiaomi.data.push.bo.ClientInfo;
import com.xiaomi.data.push.common.SafeRun;
import com.xiaomi.data.push.common.Service;
import com.xiaomi.data.push.nacos.NacosNaming;
import com.xiaomi.data.push.rpc.RpcException;
import com.xiaomi.data.push.rpc.RpcVersion;
import com.xiaomi.data.push.rpc.common.InvokeCallback;
import com.xiaomi.data.push.rpc.common.Pair;
import com.xiaomi.data.push.rpc.common.RpcClientVersion;
import com.xiaomi.data.push.rpc.netty.NettyClientConfig;
import com.xiaomi.data.push.rpc.netty.NettyRemotingClient;
import com.xiaomi.data.push.rpc.netty.NettyRequestProcessor;
import com.xiaomi.data.push.rpc.protocol.RemotingCommand;
import com.xiaomi.data.push.task.Task;
import io.netty.channel.ChannelHandlerContext;
import java.net.InetAddress;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.PostConstruct;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RpcClient
implements Service {
    private static final Logger logger = LoggerFactory.getLogger(RpcClient.class);
    private NettyRemotingClient client;
    private final String nacosAddrs;
    private final String serverName;
    private String serverIp;
    private int serverPort;
    private NacosNaming nacosNaming;
    private List<Pair<Integer, NettyRequestProcessor>> processorList = Lists.newLinkedList();
    private AtomicReference<String> serverAddrs = new AtomicReference<String>("");
    private AtomicReference<List<String>> serverList = new AtomicReference<ArrayList>(Lists.newArrayList());
    private int pooSize = Runtime.getRuntime().availableProcessors() * 2 + 1;
    private ExecutorService defaultPool = new ThreadPoolExecutor(this.pooSize, this.pooSize, 0L, TimeUnit.MILLISECONDS, new ArrayBlockingQueue<Runnable>(1000));
    private ScheduledExecutorService pool;
    private AtomicBoolean init = new AtomicBoolean(false);
    private boolean clearServerAddr = true;
    private String clientIp;
    private int clientPort;
    private List<Task> tasks = Lists.newArrayList();
    private boolean reconnection = true;
    private ClientInfo clientInfo;
    private boolean useNacos = true;
    public static CountDownLatch startLatch = new CountDownLatch(1);

    public void waitStarted() {
        startLatch.await();
    }

    public RpcClient(String nacosAddrs, String serverName) {
        logger.info("rpc client version:{}", (Object)new RpcVersion());
        this.nacosAddrs = nacosAddrs;
        this.serverName = serverName;
        this.nacosNaming = new NacosNaming();
    }

    public RpcClient(String serverAddr) {
        this.serverAddrs.set(serverAddr);
        this.useNacos = false;
        this.serverName = "";
        this.nacosAddrs = "";
    }

    public String getServerAddrs() {
        String address = this.serverAddrs.get();
        return address;
    }

    public void start(Consumer<NettyClientConfig> consumer) {
        logger.info("client version:{}", (Object)new RpcClientVersion());
        NettyClientConfig config = new NettyClientConfig();
        config.setReconnection(this.reconnection);
        consumer.accept(config);
        this.client = new NettyRemotingClient(config);
        this.client.setGetAddrsFunc(str -> this.getServerAddrs());
        this.registerProcessor();
        this.client.start();
        if (this.useNacos) {
            logger.info("nacos addr:{}", (Object)this.nacosAddrs);
            this.nacosNaming.setServerAddr(this.nacosAddrs);
            this.nacosNaming.init();
            logger.info("refresh server addrs");
            this.refreshServerAddrs();
            logger.info("reg");
            Executors.newSingleThreadExecutor().submit(() -> this.reg());
        }
    }

    @Override
    public void start() {
        this.start(config -> {});
    }

    public void registerProcessor() {
        this.processorList.stream().forEach(it -> this.client.registerProcessor((Integer)it.getObject1(), (NettyRequestProcessor)it.getObject2(), this.defaultPool));
    }

    private void reg() {
        Optional.ofNullable(this.clientInfo).ifPresent(it -> {
            try {
                Instance instance = new Instance();
                instance.setIp(it.getIp());
                instance.setPort(it.getPort());
                HashMap meta = Maps.newHashMap();
                meta.put("ctime", new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(new Date()));
                meta.put("version", new RpcVersion().toString() + ":" + it.getVersion());
                SafeRun.run(() -> meta.put("hostname", InetAddress.getLocalHost().getHostName()));
                instance.setMetadata((Map)meta);
                this.nacosNaming.registerInstance(it.getName(), instance);
                logger.info("reg:{}", (Object)it.getName());
            }
            catch (NacosException e) {
                logger.error(e.getMessage());
            }
        });
    }

    private void initAddr() {
        try {
            List list = this.nacosNaming.getAllInstances(this.serverName).stream().filter(it -> it.isHealthy() && it.isEnabled()).collect(Collectors.toList());
            if (list.size() > 0) {
                List addrList = list.stream().map(it -> {
                    String addr = it.getIp() + ":" + it.getPort();
                    return addr;
                }).collect(Collectors.toList());
                this.serverList.set(addrList);
            }
            if (list.size() > 0) {
                String serverIp = ((Instance)list.get(0)).getIp();
                int serverPort = ((Instance)list.get(0)).getPort();
                logger.info("serverIp:{} serverPort:{}", (Object)serverIp, (Object)serverPort);
                String old = this.serverAddrs.get();
                this.serverAddrs.set(serverIp + ":" + serverPort);
                if (StringUtils.isNotEmpty((CharSequence)old) && !old.equals(this.serverAddrs.get())) {
                    if (!list.stream().filter(it -> (it.getIp() + ":" + it.getPort()).equals(old)).findAny().isPresent()) {
                        logger.info("server ip change:{}->{}", (Object)old, (Object)this.serverAddrs.get());
                        this.logout();
                    } else {
                        this.serverAddrs.set(old);
                    }
                }
            } else if (this.clearServerAddr) {
                logger.warn("server size = 0,serverName:{}", (Object)this.serverName);
                this.serverAddrs.set("");
            }
        }
        catch (Throwable e) {
            logger.warn("initAddr erro:" + e.getMessage());
        }
    }

    private void refreshServerAddrs() {
        new Thread(() -> {
            while (true) {
                this.initAddr();
                RpcClient.sleep(5L);
            }
        }).start();
    }

    private static void sleep(long timeout) {
        try {
            TimeUnit.SECONDS.sleep(timeout);
        }
        catch (InterruptedException e) {
            logger.warn(e.getMessage());
        }
    }

    @Override
    @PostConstruct
    public void init() {
        int size = this.tasks.size();
        if (size > 0 && this.init.compareAndSet(false, true)) {
            this.pool = Executors.newScheduledThreadPool(size);
            this.tasks.forEach(task -> this.pool.scheduleAtFixedRate(() -> {
                try {
                    task.getRunnable().run();
                }
                catch (Throwable ex) {
                    logger.warn(ex.getMessage());
                }
            }, 5L, task.getDelay(), TimeUnit.SECONDS));
        }
    }

    @Override
    public void shutdown() {
        if (null != this.client) {
            try {
                this.pool.shutdown();
                this.client.shutdown();
            }
            catch (Exception ex) {
                logger.info("rpc client shutdwon error:{}", (Object)ex.getMessage());
            }
        }
    }

    public void sendMessage(String addr, int code, String message) {
        if (StringUtils.isEmpty((CharSequence)addr)) {
            logger.warn("addr is empty");
            return;
        }
        try {
            RemotingCommand req = RemotingCommand.createRequestCommand(code);
            req.setBody(message.getBytes());
            this.client.invokeAsync(addr, req, TimeUnit.SECONDS.toMillis(3L), responseFuture -> {});
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage());
        }
    }

    public void sendMessage(RemotingCommand req) {
        String addr = this.serverAddrs.get();
        if (StringUtils.isEmpty((CharSequence)addr)) {
            logger.warn("send message addr is null");
            return;
        }
        try {
            this.client.invokeOneway(addr, req, req.getTimeout());
        }
        catch (Exception e) {
            throw new RpcException(e.getMessage(), e);
        }
    }

    public void sendToAllMessage(RemotingCommand req) {
        this.serverList.get().stream().forEach(addr -> {
            if (StringUtils.isEmpty((CharSequence)addr)) {
                logger.warn("send message addr is null");
                return;
            }
            try {
                this.client.invokeOneway((String)addr, req, req.getTimeout());
            }
            catch (Exception e) {
                throw new RpcException(e.getMessage(), e);
            }
        });
    }

    public void sendToAllMessage(int code, byte[] body, InvokeCallback invokeCallback) {
        this.serverList.get().stream().forEach(addr -> {
            if (StringUtils.isEmpty((CharSequence)addr)) {
                logger.warn("send message addr is null");
                return;
            }
            try {
                RemotingCommand req = RemotingCommand.createRequestCommand(code);
                req.setBody(body);
                this.client.invokeAsync((String)addr, req, req.getTimeout(), invokeCallback);
            }
            catch (Exception e) {
                throw new RpcException(e.getMessage(), e);
            }
        });
    }

    public void sendMessageWithSelect(int code, byte[] body, Function<List<String>, String> function, InvokeCallback invokeCallback) {
        List<String> list = this.serverList.get();
        String addr = function.apply(list);
        if (StringUtils.isEmpty((CharSequence)addr)) {
            logger.warn("send message addr is null");
            return;
        }
        try {
            RemotingCommand req = RemotingCommand.createRequestCommand(code);
            req.setBody(body);
            this.client.invokeAsync(addr, req, req.getTimeout(), invokeCallback);
        }
        catch (Exception e) {
            throw new RpcException(e.getMessage(), e);
        }
    }

    public void tell(String addr, int code, String message) {
        try {
            RemotingCommand req = RemotingCommand.createRequestCommand(code);
            req.setBody(message.getBytes());
            this.client.invokeOneway(addr, req, req.getTimeout());
        }
        catch (Exception e) {
            throw new RpcException(e.getMessage(), e);
        }
    }

    public void tell(String addr, int code, byte[] message, Consumer<RemotingCommand> consumer) {
        try {
            RemotingCommand req = RemotingCommand.createRequestCommand(code);
            consumer.accept(req);
            req.setBody(message);
            this.client.invokeOneway(addr, req, req.getTimeout());
        }
        catch (Exception e) {
            throw new RpcException(e.getMessage(), e);
        }
    }

    public void oneway(String addr, RemotingCommand req) {
        try {
            this.client.createChannel(addr, false);
            this.client.invokeOneway(addr, req, 1000L);
        }
        catch (Exception e) {
            throw new RpcException(e.getMessage(), e);
        }
    }

    public RemotingCommand sendMessage(String addr, int code, String message, long timeout) {
        return this.sendMessage(addr, code, message, timeout, false);
    }

    public RemotingCommand sendMessage(String addr, int code, String message, long timeout, boolean createChannel) {
        return this.sendMessage(addr, code, message, timeout, createChannel, (RemotingCommand req) -> {});
    }

    public RemotingCommand sendMessage(String addr, int code, String message, long timeout, boolean createChannel, Consumer<RemotingCommand> consumer) {
        try {
            RemotingCommand req = RemotingCommand.createRequestCommand(code);
            consumer.accept(req);
            req.setBody(message.getBytes());
            return this.client.invokeSync(addr, req, timeout, createChannel);
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage());
        }
    }

    public RemotingCommand sendMessage(String addr, int code, byte[] message, long timeout, boolean createChannel) {
        return this.sendMessage(addr, code, message, timeout, createChannel, (RemotingCommand req) -> {});
    }

    public RemotingCommand sendMessage(String addr, int code, byte[] message, long timeout, boolean createChannel, Consumer<RemotingCommand> consumer) {
        try {
            RemotingCommand req = RemotingCommand.createRequestCommand(code);
            consumer.accept(req);
            req.setBody(message);
            return this.client.invokeSync(addr, req, timeout, createChannel);
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage());
        }
    }

    public void sendMessage(String addr, RemotingCommand req, InvokeCallback callback) {
        try {
            this.client.invokeAsync(addr, req, TimeUnit.SECONDS.toMillis(3L), callback);
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage());
        }
    }

    public void ping(String addr) {
        this.sendMessage(addr, 1001, "ping");
    }

    public void logout() {
        logger.info("client logout");
        this.client.closeAllChannel();
    }

    public NettyRemotingClient getClient() {
        return this.client;
    }

    public NettyRequestProcessor getProcessor(Integer cmd) {
        return this.processorList.stream().filter(it -> ((Integer)it.getObject1()).equals(cmd)).map(it -> (NettyRequestProcessor)it.getObject2()).findAny().orElse(new NettyRequestProcessor(this){

            @Override
            public RemotingCommand processRequest(ChannelHandlerContext ctx, RemotingCommand request) throws Exception {
                return null;
            }

            @Override
            public boolean rejectRequest() {
                return false;
            }
        });
    }

    @Override
    public RemotingCommand call(RemotingCommand command) {
        return null;
    }

    public String getNacosAddrs() {
        return this.nacosAddrs;
    }

    public String getServerName() {
        return this.serverName;
    }

    public String getServerIp() {
        return this.serverIp;
    }

    public int getServerPort() {
        return this.serverPort;
    }

    public List<Pair<Integer, NettyRequestProcessor>> getProcessorList() {
        return this.processorList;
    }

    public AtomicReference<List<String>> getServerList() {
        return this.serverList;
    }

    public int getPooSize() {
        return this.pooSize;
    }

    public ExecutorService getDefaultPool() {
        return this.defaultPool;
    }

    public ScheduledExecutorService getPool() {
        return this.pool;
    }

    public AtomicBoolean getInit() {
        return this.init;
    }

    public boolean isClearServerAddr() {
        return this.clearServerAddr;
    }

    public List<Task> getTasks() {
        return this.tasks;
    }

    public boolean isReconnection() {
        return this.reconnection;
    }

    public ClientInfo getClientInfo() {
        return this.clientInfo;
    }

    public boolean isUseNacos() {
        return this.useNacos;
    }

    public void setClient(NettyRemotingClient client) {
        this.client = client;
    }

    public void setServerIp(String serverIp) {
        this.serverIp = serverIp;
    }

    public void setServerPort(int serverPort) {
        this.serverPort = serverPort;
    }

    public void setNacosNaming(NacosNaming nacosNaming) {
        this.nacosNaming = nacosNaming;
    }

    public void setServerAddrs(AtomicReference<String> serverAddrs) {
        this.serverAddrs = serverAddrs;
    }

    public void setServerList(AtomicReference<List<String>> serverList) {
        this.serverList = serverList;
    }

    public void setPooSize(int pooSize) {
        this.pooSize = pooSize;
    }

    public void setDefaultPool(ExecutorService defaultPool) {
        this.defaultPool = defaultPool;
    }

    public void setPool(ScheduledExecutorService pool) {
        this.pool = pool;
    }

    public void setInit(AtomicBoolean init) {
        this.init = init;
    }

    public void setClientIp(String clientIp) {
        this.clientIp = clientIp;
    }

    public void setClientPort(int clientPort) {
        this.clientPort = clientPort;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RpcClient)) {
            return false;
        }
        RpcClient other = (RpcClient)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getServerPort() != other.getServerPort()) {
            return false;
        }
        if (this.getPooSize() != other.getPooSize()) {
            return false;
        }
        if (this.isClearServerAddr() != other.isClearServerAddr()) {
            return false;
        }
        if (this.getClientPort() != other.getClientPort()) {
            return false;
        }
        if (this.isReconnection() != other.isReconnection()) {
            return false;
        }
        if (this.isUseNacos() != other.isUseNacos()) {
            return false;
        }
        NettyRemotingClient this$client = this.getClient();
        NettyRemotingClient other$client = other.getClient();
        if (this$client == null ? other$client != null : !this$client.equals(other$client)) {
            return false;
        }
        String this$nacosAddrs = this.getNacosAddrs();
        String other$nacosAddrs = other.getNacosAddrs();
        if (this$nacosAddrs == null ? other$nacosAddrs != null : !this$nacosAddrs.equals(other$nacosAddrs)) {
            return false;
        }
        String this$serverName = this.getServerName();
        String other$serverName = other.getServerName();
        if (this$serverName == null ? other$serverName != null : !this$serverName.equals(other$serverName)) {
            return false;
        }
        String this$serverIp = this.getServerIp();
        String other$serverIp = other.getServerIp();
        if (this$serverIp == null ? other$serverIp != null : !this$serverIp.equals(other$serverIp)) {
            return false;
        }
        NacosNaming this$nacosNaming = this.getNacosNaming();
        NacosNaming other$nacosNaming = other.getNacosNaming();
        if (this$nacosNaming == null ? other$nacosNaming != null : !this$nacosNaming.equals(other$nacosNaming)) {
            return false;
        }
        List<Pair<Integer, NettyRequestProcessor>> this$processorList = this.getProcessorList();
        List<Pair<Integer, NettyRequestProcessor>> other$processorList = other.getProcessorList();
        if (this$processorList == null ? other$processorList != null : !((Object)this$processorList).equals(other$processorList)) {
            return false;
        }
        String this$serverAddrs = this.getServerAddrs();
        String other$serverAddrs = other.getServerAddrs();
        if (this$serverAddrs == null ? other$serverAddrs != null : !this$serverAddrs.equals(other$serverAddrs)) {
            return false;
        }
        AtomicReference<List<String>> this$serverList = this.getServerList();
        AtomicReference<List<String>> other$serverList = other.getServerList();
        if (this$serverList == null ? other$serverList != null : !this$serverList.equals(other$serverList)) {
            return false;
        }
        ExecutorService this$defaultPool = this.getDefaultPool();
        ExecutorService other$defaultPool = other.getDefaultPool();
        if (this$defaultPool == null ? other$defaultPool != null : !this$defaultPool.equals(other$defaultPool)) {
            return false;
        }
        ScheduledExecutorService this$pool = this.getPool();
        ScheduledExecutorService other$pool = other.getPool();
        if (this$pool == null ? other$pool != null : !this$pool.equals(other$pool)) {
            return false;
        }
        AtomicBoolean this$init = this.getInit();
        AtomicBoolean other$init = other.getInit();
        if (this$init == null ? other$init != null : !this$init.equals(other$init)) {
            return false;
        }
        String this$clientIp = this.getClientIp();
        String other$clientIp = other.getClientIp();
        if (this$clientIp == null ? other$clientIp != null : !this$clientIp.equals(other$clientIp)) {
            return false;
        }
        List<Task> this$tasks = this.getTasks();
        List<Task> other$tasks = other.getTasks();
        if (this$tasks == null ? other$tasks != null : !((Object)this$tasks).equals(other$tasks)) {
            return false;
        }
        ClientInfo this$clientInfo = this.getClientInfo();
        ClientInfo other$clientInfo = other.getClientInfo();
        return !(this$clientInfo == null ? other$clientInfo != null : !((Object)this$clientInfo).equals(other$clientInfo));
    }

    protected boolean canEqual(Object other) {
        return other instanceof RpcClient;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getServerPort();
        result = result * 59 + this.getPooSize();
        result = result * 59 + (this.isClearServerAddr() ? 79 : 97);
        result = result * 59 + this.getClientPort();
        result = result * 59 + (this.isReconnection() ? 79 : 97);
        result = result * 59 + (this.isUseNacos() ? 79 : 97);
        NettyRemotingClient $client = this.getClient();
        result = result * 59 + ($client == null ? 43 : $client.hashCode());
        String $nacosAddrs = this.getNacosAddrs();
        result = result * 59 + ($nacosAddrs == null ? 43 : $nacosAddrs.hashCode());
        String $serverName = this.getServerName();
        result = result * 59 + ($serverName == null ? 43 : $serverName.hashCode());
        String $serverIp = this.getServerIp();
        result = result * 59 + ($serverIp == null ? 43 : $serverIp.hashCode());
        NacosNaming $nacosNaming = this.getNacosNaming();
        result = result * 59 + ($nacosNaming == null ? 43 : $nacosNaming.hashCode());
        List<Pair<Integer, NettyRequestProcessor>> $processorList = this.getProcessorList();
        result = result * 59 + ($processorList == null ? 43 : ((Object)$processorList).hashCode());
        String $serverAddrs = this.getServerAddrs();
        result = result * 59 + ($serverAddrs == null ? 43 : $serverAddrs.hashCode());
        AtomicReference<List<String>> $serverList = this.getServerList();
        result = result * 59 + ($serverList == null ? 43 : $serverList.hashCode());
        ExecutorService $defaultPool = this.getDefaultPool();
        result = result * 59 + ($defaultPool == null ? 43 : $defaultPool.hashCode());
        ScheduledExecutorService $pool = this.getPool();
        result = result * 59 + ($pool == null ? 43 : $pool.hashCode());
        AtomicBoolean $init = this.getInit();
        result = result * 59 + ($init == null ? 43 : $init.hashCode());
        String $clientIp = this.getClientIp();
        result = result * 59 + ($clientIp == null ? 43 : $clientIp.hashCode());
        List<Task> $tasks = this.getTasks();
        result = result * 59 + ($tasks == null ? 43 : ((Object)$tasks).hashCode());
        ClientInfo $clientInfo = this.getClientInfo();
        result = result * 59 + ($clientInfo == null ? 43 : ((Object)$clientInfo).hashCode());
        return result;
    }

    public String toString() {
        return "RpcClient(client=" + String.valueOf(this.getClient()) + ", nacosAddrs=" + this.getNacosAddrs() + ", serverName=" + this.getServerName() + ", serverIp=" + this.getServerIp() + ", serverPort=" + this.getServerPort() + ", nacosNaming=" + String.valueOf(this.getNacosNaming()) + ", processorList=" + String.valueOf(this.getProcessorList()) + ", serverAddrs=" + this.getServerAddrs() + ", serverList=" + String.valueOf(this.getServerList()) + ", pooSize=" + this.getPooSize() + ", defaultPool=" + String.valueOf(this.getDefaultPool()) + ", pool=" + String.valueOf(this.getPool()) + ", init=" + String.valueOf(this.getInit()) + ", clearServerAddr=" + this.isClearServerAddr() + ", clientIp=" + this.getClientIp() + ", clientPort=" + this.getClientPort() + ", tasks=" + String.valueOf(this.getTasks()) + ", reconnection=" + this.isReconnection() + ", clientInfo=" + String.valueOf(this.getClientInfo()) + ", useNacos=" + this.isUseNacos() + ")";
    }

    public NacosNaming getNacosNaming() {
        return this.nacosNaming;
    }

    public void setProcessorList(List<Pair<Integer, NettyRequestProcessor>> processorList) {
        this.processorList = processorList;
    }

    public void setClearServerAddr(boolean clearServerAddr) {
        this.clearServerAddr = clearServerAddr;
    }

    public String getClientIp() {
        return this.clientIp;
    }

    public int getClientPort() {
        return this.clientPort;
    }

    public void setTasks(List<Task> tasks) {
        this.tasks = tasks;
    }

    public void setReconnection(boolean reconnection) {
        this.reconnection = reconnection;
    }

    public void setClientInfo(ClientInfo clientInfo) {
        this.clientInfo = clientInfo;
    }

    public void setUseNacos(boolean useNacos) {
        this.useNacos = useNacos;
    }
}

