/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ozhera.log.manager.service.extension.dictionary;

import com.google.common.collect.Lists;
import com.xiaomi.youpin.docean.anno.Service;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.ozhera.log.api.enums.DeployWayEnum;
import org.apache.ozhera.log.api.enums.MQSourceEnum;
import org.apache.ozhera.log.api.enums.MachineRegionEnum;
import org.apache.ozhera.log.api.enums.ProjectTypeEnum;
import org.apache.ozhera.log.api.enums.ResourceEnum;
import org.apache.ozhera.log.manager.dao.MilogMiddlewareConfigDao;
import org.apache.ozhera.log.manager.model.dto.DictionaryDTO;
import org.apache.ozhera.log.manager.model.pojo.MilogLogTailDo;
import org.apache.ozhera.log.manager.model.pojo.MilogMiddlewareConfig;
import org.apache.ozhera.log.manager.service.extension.dictionary.DictionaryExtensionService;
import org.apache.ozhera.log.manager.service.impl.KafkaMqConfigService;
import org.apache.ozhera.log.manager.service.impl.RocketMqConfigService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Service(name="defaultDictionaryExtensionService")
public class DefaultDictionaryExtensionService
implements DictionaryExtensionService {
    private static final Logger log = LoggerFactory.getLogger(DefaultDictionaryExtensionService.class);
    @Resource
    private MilogMiddlewareConfigDao milogMiddlewareConfigDao;
    @Resource
    private RocketMqConfigService rocketMqConfigService;
    @Resource
    private KafkaMqConfigService kafkaMqConfigService;

    @Override
    public List<DictionaryDTO<?>> queryMiddlewareConfigDictionary(String monitorRoomEn) {
        List<MilogMiddlewareConfig> milogMiddlewareConfigs = this.milogMiddlewareConfigDao.queryCurrentMontorRoomMQ(monitorRoomEn);
        ArrayList dictionaryDTOS = Lists.newArrayList();
        Arrays.stream(MQSourceEnum.values()).forEach(sourceEnum -> {
            DictionaryDTO<Integer> dictionaryDTO = new DictionaryDTO<Integer>();
            dictionaryDTO.setValue(sourceEnum.getCode());
            dictionaryDTO.setLabel(sourceEnum.getName());
            if (CollectionUtils.isNotEmpty((Collection)milogMiddlewareConfigs)) {
                dictionaryDTO.setChildren(milogMiddlewareConfigs.stream().filter(middlewareConfig -> sourceEnum.getCode().equals(middlewareConfig.getType())).map(middlewareConfig -> {
                    DictionaryDTO<Long> childDictionaryDTO = new DictionaryDTO<Long>();
                    childDictionaryDTO.setValue(middlewareConfig.getId());
                    childDictionaryDTO.setLabel(middlewareConfig.getAlias());
                    return childDictionaryDTO;
                }).collect(Collectors.toList()));
            }
            dictionaryDTOS.add(dictionaryDTO);
        });
        return dictionaryDTOS;
    }

    @Override
    public List<DictionaryDTO<?>> queryResourceDictionary() {
        return this.generateCommonDictionary(middlewareEnum -> Boolean.TRUE);
    }

    @Override
    public List<DictionaryDTO<?>> queryAppType() {
        return Arrays.stream(ProjectTypeEnum.values()).map(projectTypeEnum -> {
            DictionaryDTO<Integer> dictionaryDTO = new DictionaryDTO<Integer>();
            dictionaryDTO.setValue(projectTypeEnum.getCode());
            dictionaryDTO.setLabel(projectTypeEnum.getType());
            dictionaryDTO.setShowDeploymentType(Boolean.TRUE);
            dictionaryDTO.setShowEnvGroup(Boolean.TRUE);
            dictionaryDTO.setShowServiceIp(Boolean.TRUE);
            dictionaryDTO.setShowMqConfig(Boolean.TRUE);
            return dictionaryDTO;
        }).collect(Collectors.toList());
    }

    @Override
    public List<MilogLogTailDo> querySpecialTails() {
        return Lists.newArrayList();
    }

    @Override
    public List<DictionaryDTO<?>> queryMachineRegion() {
        ArrayList dictionaryDTOS = Lists.newArrayList();
        for (MachineRegionEnum value : MachineRegionEnum.values()) {
            DictionaryDTO<String> dictionaryDTO = new DictionaryDTO<String>();
            dictionaryDTO.setLabel(value.getCn());
            dictionaryDTO.setValue(value.getEn());
            dictionaryDTOS.add(dictionaryDTO);
        }
        return dictionaryDTOS;
    }

    @Override
    public List<DictionaryDTO<?>> queryDeployWay() {
        ArrayList dictionaryDTOS = Lists.newArrayList();
        for (DeployWayEnum value : DeployWayEnum.values()) {
            DictionaryDTO<Integer> dictionaryDTO = new DictionaryDTO<Integer>();
            dictionaryDTO.setLabel(value.getName());
            dictionaryDTO.setValue(value.getCode());
            dictionaryDTOS.add(dictionaryDTO);
        }
        return dictionaryDTOS;
    }

    @Override
    public List<DictionaryDTO<?>> queryResourceTypeDictionary() {
        return this.generateCommonDictionary(middlewareEnum -> ResourceEnum.MQ == middlewareEnum | ResourceEnum.STORAGE == middlewareEnum);
    }

    @Override
    public List<DictionaryDTO> queryExistsTopic(String ak, String sk, String nameServer, String serviceUrl, String authorization, String orgId, String teamId) {
        return Lists.newArrayList();
    }

    @Override
    public List<DictionaryDTO<?>> queryMQDictionary() {
        return Arrays.stream(MQSourceEnum.values()).map(mqSourceEnum -> {
            DictionaryDTO<Integer> dictionaryDTO = new DictionaryDTO<Integer>();
            dictionaryDTO.setValue(mqSourceEnum.getCode());
            dictionaryDTO.setLabel(mqSourceEnum.getName());
            if (MQSourceEnum.ROCKETMQ == mqSourceEnum) {
                dictionaryDTO.setShowBrokerName(Boolean.TRUE);
            }
            return dictionaryDTO;
        }).collect(Collectors.toList());
    }

    private List<DictionaryDTO<?>> generateCommonDictionary(Predicate<ResourceEnum> filter) {
        List rDictionaryDTOS = Arrays.stream(MachineRegionEnum.values()).map(machineRegionEnum -> DictionaryDTO.Of(machineRegionEnum.getEn(), machineRegionEnum.getCn())).collect(Collectors.toList());
        return Arrays.stream(ResourceEnum.values()).filter(filter).map(middlewareEnum -> {
            DictionaryDTO<Integer> dictionaryDTO = new DictionaryDTO<Integer>();
            dictionaryDTO.setValue(middlewareEnum.getCode());
            dictionaryDTO.setLabel(middlewareEnum.getName());
            dictionaryDTO.setChildren(rDictionaryDTOS);
            return dictionaryDTO;
        }).collect(Collectors.toList());
    }
}

