/*
 * Decompiled with CFR 0.152.
 */
package com.xiaomi.youpin.docean.common;

import com.google.common.base.Charsets;
import java.util.concurrent.ThreadLocalRandom;

public abstract class Uuid {
    static final byte[] DIGITS = new byte[]{48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 97, 98, 99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90};

    public static String getUUID() {
        ThreadLocalRandom random = ThreadLocalRandom.current();
        long lsb = random.nextLong();
        long msb = random.nextLong();
        byte[] buf = new byte[32];
        Uuid.formatUnsignedLong(lsb, buf, 20, 12);
        Uuid.formatUnsignedLong(lsb >>> 48, buf, 16, 4);
        Uuid.formatUnsignedLong(msb, buf, 12, 4);
        Uuid.formatUnsignedLong(msb >>> 16, buf, 8, 4);
        Uuid.formatUnsignedLong(msb >>> 32, buf, 0, 8);
        return new String(buf, Charsets.UTF_8);
    }

    private static void formatUnsignedLong(long val, byte[] buf, int offset, int len) {
        int charPos = offset + len;
        int radix = 16;
        int mask = radix - 1;
        do {
            buf[--charPos] = DIGITS[(int)val & mask];
            val >>>= 4;
        } while (charPos > offset);
    }
}

