/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.common.config;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.apache.dubbo.common.config.CompositeConfiguration;
import org.apache.dubbo.common.config.Configuration;
import org.apache.dubbo.common.config.EnvironmentConfiguration;
import org.apache.dubbo.common.config.InmemoryConfiguration;
import org.apache.dubbo.common.config.PropertiesConfiguration;
import org.apache.dubbo.common.config.SystemConfiguration;
import org.apache.dubbo.common.config.configcenter.DynamicConfiguration;
import org.apache.dubbo.common.context.FrameworkExt;
import org.apache.dubbo.common.context.LifecycleAdapter;
import org.apache.dubbo.common.extension.DisableInject;
import org.apache.dubbo.common.logger.Logger;
import org.apache.dubbo.common.logger.LoggerFactory;
import org.apache.dubbo.config.AbstractConfig;
import org.apache.dubbo.config.ConfigCenterConfig;
import org.apache.dubbo.config.context.ConfigConfigurationAdapter;
import org.apache.dubbo.config.context.ConfigManager;
import org.apache.dubbo.rpc.model.ApplicationModel;

public class Environment
extends LifecycleAdapter
implements FrameworkExt {
    private static final Logger logger = LoggerFactory.getLogger(Environment.class);
    public static final String NAME = "environment";
    private final PropertiesConfiguration propertiesConfiguration;
    private final SystemConfiguration systemConfiguration;
    private final EnvironmentConfiguration environmentConfiguration;
    private final InmemoryConfiguration externalConfiguration;
    private final InmemoryConfiguration appExternalConfiguration;
    private CompositeConfiguration globalConfiguration;
    private CompositeConfiguration dynamicGlobalConfiguration;
    private Map<String, String> externalConfigurationMap = new HashMap<String, String>();
    private Map<String, String> appExternalConfigurationMap = new HashMap<String, String>();
    private boolean configCenterFirst = true;
    private DynamicConfiguration dynamicConfiguration;

    public Environment() {
        this.propertiesConfiguration = new PropertiesConfiguration();
        this.systemConfiguration = new SystemConfiguration();
        this.environmentConfiguration = new EnvironmentConfiguration();
        this.externalConfiguration = new InmemoryConfiguration();
        this.appExternalConfiguration = new InmemoryConfiguration();
    }

    @Override
    public void initialize() throws IllegalStateException {
        ConfigManager configManager = ApplicationModel.getConfigManager();
        Optional<Collection<ConfigCenterConfig>> defaultConfigs = configManager.getDefaultConfigCenter();
        defaultConfigs.ifPresent(configs -> {
            for (ConfigCenterConfig config : configs) {
                this.setExternalConfigMap(config.getExternalConfiguration());
                this.setAppExternalConfigMap(config.getAppExternalConfiguration());
            }
        });
        this.externalConfiguration.setProperties(this.externalConfigurationMap);
        this.appExternalConfiguration.setProperties(this.appExternalConfigurationMap);
    }

    @DisableInject
    public void setExternalConfigMap(Map<String, String> externalConfiguration) {
        if (externalConfiguration != null) {
            this.externalConfigurationMap = externalConfiguration;
        }
    }

    @DisableInject
    public void setAppExternalConfigMap(Map<String, String> appExternalConfiguration) {
        if (appExternalConfiguration != null) {
            this.appExternalConfigurationMap = appExternalConfiguration;
        }
    }

    public Map<String, String> getExternalConfigurationMap() {
        return this.externalConfigurationMap;
    }

    public Map<String, String> getAppExternalConfigurationMap() {
        return this.appExternalConfigurationMap;
    }

    public void updateExternalConfigurationMap(Map<String, String> externalMap) {
        this.externalConfigurationMap.putAll(externalMap);
    }

    public void updateAppExternalConfigurationMap(Map<String, String> externalMap) {
        this.appExternalConfigurationMap.putAll(externalMap);
    }

    public synchronized CompositeConfiguration getPrefixedConfiguration(AbstractConfig config) {
        CompositeConfiguration prefixedConfiguration = new CompositeConfiguration(config.getPrefix(), config.getId());
        ConfigConfigurationAdapter configuration = new ConfigConfigurationAdapter(config);
        if (this.isConfigCenterFirst()) {
            prefixedConfiguration.addConfiguration(this.systemConfiguration);
            prefixedConfiguration.addConfiguration(this.environmentConfiguration);
            prefixedConfiguration.addConfiguration(this.appExternalConfiguration);
            prefixedConfiguration.addConfiguration(this.externalConfiguration);
            prefixedConfiguration.addConfiguration(configuration);
            prefixedConfiguration.addConfiguration(this.propertiesConfiguration);
        } else {
            prefixedConfiguration.addConfiguration(this.systemConfiguration);
            prefixedConfiguration.addConfiguration(this.environmentConfiguration);
            prefixedConfiguration.addConfiguration(configuration);
            prefixedConfiguration.addConfiguration(this.appExternalConfiguration);
            prefixedConfiguration.addConfiguration(this.externalConfiguration);
            prefixedConfiguration.addConfiguration(this.propertiesConfiguration);
        }
        return prefixedConfiguration;
    }

    public Configuration getConfiguration() {
        if (this.globalConfiguration == null) {
            this.globalConfiguration = new CompositeConfiguration();
            this.globalConfiguration.addConfiguration(this.systemConfiguration);
            this.globalConfiguration.addConfiguration(this.environmentConfiguration);
            this.globalConfiguration.addConfiguration(this.appExternalConfiguration);
            this.globalConfiguration.addConfiguration(this.externalConfiguration);
            this.globalConfiguration.addConfiguration(this.propertiesConfiguration);
        }
        return this.globalConfiguration;
    }

    public Configuration getDynamicGlobalConfiguration() {
        if (this.dynamicGlobalConfiguration == null) {
            if (this.dynamicConfiguration == null) {
                if (logger.isWarnEnabled()) {
                    logger.warn("dynamicConfiguration is null , return globalConfiguration.");
                }
                return this.globalConfiguration;
            }
            this.dynamicGlobalConfiguration = new CompositeConfiguration();
            this.dynamicGlobalConfiguration.addConfiguration(this.dynamicConfiguration);
            this.dynamicGlobalConfiguration.addConfiguration(this.getConfiguration());
        }
        return this.dynamicGlobalConfiguration;
    }

    public boolean isConfigCenterFirst() {
        return this.configCenterFirst;
    }

    @DisableInject
    public void setConfigCenterFirst(boolean configCenterFirst) {
        this.configCenterFirst = configCenterFirst;
    }

    public Optional<DynamicConfiguration> getDynamicConfiguration() {
        return Optional.ofNullable(this.dynamicConfiguration);
    }

    @DisableInject
    public void setDynamicConfiguration(DynamicConfiguration dynamicConfiguration) {
        this.dynamicConfiguration = dynamicConfiguration;
    }

    @Override
    public void destroy() throws IllegalStateException {
        this.clearExternalConfigs();
        this.clearAppExternalConfigs();
    }

    public PropertiesConfiguration getPropertiesConfiguration() {
        return this.propertiesConfiguration;
    }

    public SystemConfiguration getSystemConfiguration() {
        return this.systemConfiguration;
    }

    public EnvironmentConfiguration getEnvironmentConfiguration() {
        return this.environmentConfiguration;
    }

    public InmemoryConfiguration getExternalConfiguration() {
        return this.externalConfiguration;
    }

    public InmemoryConfiguration getAppExternalConfiguration() {
        return this.appExternalConfiguration;
    }

    public void clearExternalConfigs() {
        this.externalConfiguration.clear();
        this.externalConfigurationMap.clear();
    }

    public void clearAppExternalConfigs() {
        this.appExternalConfiguration.clear();
        this.appExternalConfigurationMap.clear();
    }
}

