/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.config.utils;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.dubbo.common.BaseServiceMetadata;
import org.apache.dubbo.common.utils.CollectionUtils;
import org.apache.dubbo.common.utils.StringUtils;
import org.apache.dubbo.config.AbstractConfig;
import org.apache.dubbo.config.ReferenceConfigBase;
import org.apache.dubbo.rpc.model.ApplicationModel;
import org.apache.dubbo.rpc.service.Destroyable;

public class ReferenceConfigCache {
    public static final String DEFAULT_NAME = "_DEFAULT_";
    public static final KeyGenerator DEFAULT_KEY_GENERATOR = referenceConfig -> {
        String iName = referenceConfig.getInterface();
        if (StringUtils.isBlank(iName)) {
            Class<?> clazz = referenceConfig.getInterfaceClass();
            iName = clazz.getName();
        }
        if (StringUtils.isBlank(iName)) {
            throw new IllegalArgumentException("No interface info in ReferenceConfig" + referenceConfig);
        }
        return BaseServiceMetadata.buildServiceKey(iName, referenceConfig.getGroup(), referenceConfig.getVersion());
    };
    static final ConcurrentMap<String, ReferenceConfigCache> CACHE_HOLDER = new ConcurrentHashMap<String, ReferenceConfigCache>();
    private final String name;
    private final KeyGenerator generator;
    private final ConcurrentMap<String, ReferenceConfigBase<?>> referredReferences = new ConcurrentHashMap();
    private final ConcurrentMap<Class<?>, ConcurrentMap<String, Object>> proxies = new ConcurrentHashMap();

    private ReferenceConfigCache(String name, KeyGenerator generator) {
        this.name = name;
        this.generator = generator;
    }

    public static ReferenceConfigCache getCache() {
        return ReferenceConfigCache.getCache(DEFAULT_NAME);
    }

    public static ReferenceConfigCache getCache(String name) {
        return ReferenceConfigCache.getCache(name, DEFAULT_KEY_GENERATOR);
    }

    public static ReferenceConfigCache getCache(String name, KeyGenerator keyGenerator) {
        return CACHE_HOLDER.computeIfAbsent(name, k -> new ReferenceConfigCache((String)k, keyGenerator));
    }

    public static final String getKey(String iName, String group, String version) {
        if (StringUtils.isBlank(iName)) {
            throw new IllegalArgumentException("No interface info in ReferenceConfig" + iName);
        }
        StringBuilder ret = new StringBuilder();
        if (!StringUtils.isBlank(group)) {
            ret.append(group).append("/");
        }
        ret.append(iName);
        if (!StringUtils.isBlank(version)) {
            ret.append(":").append(version);
        }
        return ret.toString();
    }

    public <T> T get(ReferenceConfigBase<T> referenceConfig) {
        String key = this.generator.generateKey(referenceConfig);
        Class<?> type = referenceConfig.getInterfaceClass();
        this.proxies.computeIfAbsent(type, _t -> new ConcurrentHashMap());
        ConcurrentMap proxiesOfType = (ConcurrentMap)this.proxies.get(type);
        proxiesOfType.computeIfAbsent(key, _k -> {
            Object proxy = referenceConfig.get();
            this.referredReferences.put(key, referenceConfig);
            return proxy;
        });
        return (T)proxiesOfType.get(key);
    }

    public <T> T get(String key, Class<T> type) {
        Map proxiesOfType = (Map)this.proxies.get(type);
        if (CollectionUtils.isEmptyMap(proxiesOfType)) {
            return null;
        }
        return (T)proxiesOfType.get(key);
    }

    public <T> T get(String key) {
        ReferenceConfigBase rc = (ReferenceConfigBase)this.referredReferences.get(key);
        if (rc == null) {
            return null;
        }
        return (T)this.get(key, rc.getInterfaceClass());
    }

    public <T> List<T> getAll(Class<T> type) {
        Map proxiesOfType = (Map)this.proxies.get(type);
        if (CollectionUtils.isEmptyMap(proxiesOfType)) {
            return Collections.emptyList();
        }
        ArrayList proxySet = new ArrayList();
        proxiesOfType.values().forEach(obj -> proxySet.add(obj));
        return proxySet;
    }

    public <T> T get(Class<T> type) {
        Map proxiesOfType = (Map)this.proxies.get(type);
        if (CollectionUtils.isEmptyMap(proxiesOfType)) {
            return null;
        }
        return (T)proxiesOfType.values().iterator().next();
    }

    public void destroy(String key, Class<?> type) {
        ReferenceConfigBase rc = (ReferenceConfigBase)this.referredReferences.remove(key);
        if (rc == null) {
            return;
        }
        ApplicationModel.getConfigManager().removeConfig(rc);
        rc.destroy();
        Map proxiesOftype = (Map)this.proxies.get(type);
        if (CollectionUtils.isNotEmptyMap(proxiesOftype)) {
            proxiesOftype.remove(key);
            if (proxiesOftype.isEmpty()) {
                this.proxies.remove(type);
            }
        }
    }

    public void destroy(Class<?> type) {
        Map proxiesOfType = (Map)this.proxies.remove(type);
        proxiesOfType.forEach((k, v) -> {
            ReferenceConfigBase rc = (ReferenceConfigBase)this.referredReferences.remove(k);
            rc.destroy();
        });
    }

    public <T> void destroy(ReferenceConfigBase<T> referenceConfig) {
        String key = this.generator.generateKey(referenceConfig);
        Class<?> type = referenceConfig.getInterfaceClass();
        this.destroy(key, type);
    }

    public void destroyAll() {
        if (CollectionUtils.isEmptyMap(this.referredReferences)) {
            return;
        }
        this.referredReferences.forEach((_k, referenceConfig) -> {
            referenceConfig.destroy();
            ApplicationModel.getConfigManager().removeConfig((AbstractConfig)referenceConfig);
        });
        this.proxies.forEach((_type, proxiesOfType) -> proxiesOfType.forEach((_k, v) -> {
            Destroyable proxy = (Destroyable)v;
            proxy.$destroy();
        }));
        this.referredReferences.clear();
        this.proxies.clear();
    }

    public ConcurrentMap<String, ReferenceConfigBase<?>> getReferredReferences() {
        return this.referredReferences;
    }

    public ConcurrentMap<Class<?>, ConcurrentMap<String, Object>> getProxies() {
        return this.proxies;
    }

    public String toString() {
        return "ReferenceConfigCache(name: " + this.name + ")";
    }

    public static interface KeyGenerator {
        public String generateKey(ReferenceConfigBase<?> var1);
    }
}

