/*
 * Decompiled with CFR 0.152.
 */
package com.xiaomi.mone.tpc.common.enums;

import com.xiaomi.mone.tpc.common.enums.ApplyTypeEnum;
import com.xiaomi.mone.tpc.common.enums.Base;
import com.xiaomi.mone.tpc.common.enums.NodeUserRelTypeEnum;
import com.xiaomi.mone.tpc.common.util.ListUtil;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;

public enum NodeTypeEnum implements Base
{
    TOP_TYPE(1, "\u6839\u76ee\u5f55", ListUtil.list(3)),
    PRO_GROUP_TYPE(3, "\u9879\u76ee\u7ec4", ListUtil.list(4)),
    PRO_TYPE(4, "\u9879\u76ee", ListUtil.list(5, 6, 7)),
    PART_TYPE(5, "\u90e8\u7f72\u7a7a\u95f4", ListUtil.list(6)),
    RES_GROUP_TYPE(6, "\u73af\u5883", null),
    PRO_SUB_GROUP(7, "\u4e1a\u52a1\u7a7a\u95f4", ListUtil.list(7));

    private Integer code;
    private String desc;
    private List<Integer> subNodeTypes;

    private NodeTypeEnum(Integer code, String desc, List<Integer> subNodeTypes) {
        this.code = code;
        this.desc = desc;
        this.subNodeTypes = subNodeTypes;
    }

    public static boolean supportResPoolNode(Integer nodeType) {
        return PRO_GROUP_TYPE.getCode().equals(nodeType) || TOP_TYPE.getCode().equals(nodeType) || PRO_SUB_GROUP.getCode().equals(nodeType);
    }

    public static boolean supportMemberNode(Integer nodeType) {
        for (NodeUserRelTypeEnum relTypeEnum : NodeUserRelTypeEnum.values()) {
            if (relTypeEnum.getNodeTypes() == null || relTypeEnum.getNodeTypes().isEmpty() || !relTypeEnum.getNodeTypes().contains(nodeType)) continue;
            return true;
        }
        return false;
    }

    public static boolean supportOrgNode(Integer type) {
        return NodeTypeEnum.getSupportOrgNode().contains(type);
    }

    public static List<Integer> getSupportOrgNode() {
        ArrayList<Integer> list = new ArrayList<Integer>();
        list.add(TOP_TYPE.getCode());
        list.add(PRO_GROUP_TYPE.getCode());
        list.add(PRO_TYPE.getCode());
        list.add(PRO_SUB_GROUP.getCode());
        return list;
    }

    public static boolean supportIamNode(Integer type) {
        return NodeTypeEnum.getSupportIamNode().contains(type);
    }

    public static List<Integer> getSupportIamNode() {
        ArrayList<Integer> list = new ArrayList<Integer>();
        list.add(TOP_TYPE.getCode());
        list.add(PRO_GROUP_TYPE.getCode());
        list.add(PRO_TYPE.getCode());
        return list;
    }

    public static boolean supportGrantUserNode(Integer type) {
        return TOP_TYPE.getCode().equals(type) || PRO_GROUP_TYPE.getCode().equals(type) || PRO_TYPE.getCode().equals(type) || PRO_SUB_GROUP.getCode().equals(type);
    }

    public static boolean supportResNodeType(Integer nodeType) {
        return RES_GROUP_TYPE.getCode().equals(nodeType);
    }

    public static final NodeTypeEnum getEnum(Integer code) {
        if (code == null) {
            return null;
        }
        for (NodeTypeEnum userTypeEnum : NodeTypeEnum.values()) {
            if (!code.equals(userTypeEnum.code)) continue;
            return userTypeEnum;
        }
        return null;
    }

    @Override
    public Integer getCode() {
        return this.code;
    }

    @Override
    public String getDesc() {
        return this.desc;
    }

    public List<Integer> getSubNodeTypes() {
        return this.subNodeTypes;
    }

    public List<Integer> getNodeUserTypes() {
        ArrayList<Integer> list = new ArrayList<Integer>();
        for (NodeUserRelTypeEnum nodeUserRelTypeEnum : NodeUserRelTypeEnum.values()) {
            if (nodeUserRelTypeEnum.getNodeTypes() == null || !nodeUserRelTypeEnum.getNodeTypes().contains(this.code)) continue;
            list.add(nodeUserRelTypeEnum.getCode());
        }
        return list;
    }

    public boolean supportNodeUserGroupTypes() {
        List<Integer> nodeTypes = NodeUserRelTypeEnum.MEMBER.getNodeTypes();
        return nodeTypes != null && nodeTypes.contains(this.code);
    }

    public static List<Integer> getSupportMemberNode() {
        HashSet<Integer> set = new HashSet<Integer>();
        for (NodeUserRelTypeEnum nodeUserRelTypeEnum : NodeUserRelTypeEnum.values()) {
            if (nodeUserRelTypeEnum.getNodeTypes() == null) continue;
            set.addAll(nodeUserRelTypeEnum.getNodeTypes());
        }
        return new ArrayList<Integer>(set);
    }

    public List<Integer> getApplyTypes() {
        ArrayList<Integer> list = new ArrayList<Integer>();
        for (ApplyTypeEnum applyTypeEnum : ApplyTypeEnum.values()) {
            if (!applyTypeEnum.isPageShow() || applyTypeEnum.getNodeTypes() == null || !applyTypeEnum.getNodeTypes().contains(this.code)) continue;
            list.add(applyTypeEnum.getCode());
        }
        return list;
    }

    public boolean supportSubNodeType(int code) {
        if (this.subNodeTypes == null) {
            return false;
        }
        return this.subNodeTypes.contains(code);
    }

    public boolean supportNodeUserType(int type) {
        NodeUserRelTypeEnum nodeUserRelType = NodeUserRelTypeEnum.getEnum(type);
        if (nodeUserRelType == null) {
            return false;
        }
        List<Integer> nodeTypes = nodeUserRelType.getNodeTypes();
        if (nodeTypes == null) {
            return false;
        }
        return nodeTypes.contains(this.code);
    }

    public boolean supportApplyType(int type) {
        ApplyTypeEnum applyType = ApplyTypeEnum.getEnum(type);
        if (applyType == null) {
            return false;
        }
        List<Integer> nodeTypes = applyType.getNodeTypes();
        if (nodeTypes == null) {
            return false;
        }
        return nodeTypes.contains(this.code);
    }

    public String toString() {
        return "NodeTypeEnum." + this.name() + "(code=" + this.getCode() + ", desc=" + this.getDesc() + ", subNodeTypes=" + String.valueOf(this.getSubNodeTypes()) + ")";
    }
}

