/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ozhera.prometheus.agent.controller;

import com.google.gson.Gson;
import org.apache.commons.lang3.StringUtils;
import org.apache.ozhera.prometheus.agent.Commons;
import org.apache.ozhera.prometheus.agent.enums.ErrorCode;
import org.apache.ozhera.prometheus.agent.param.alert.RuleAlertParam;
import org.apache.ozhera.prometheus.agent.result.Result;
import org.apache.ozhera.prometheus.agent.service.prometheus.RuleAlertService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/v1/rules"})
public class PrometheusAlertController {
    private static final Logger log = LoggerFactory.getLogger(PrometheusAlertController.class);
    @Autowired
    RuleAlertService ruleAlertService;
    public static final Gson gson = new Gson();

    @RequestMapping(value={"/alert"}, method={RequestMethod.POST})
    public Result createRuleAlert(@RequestBody RuleAlertParam param) {
        if (param == null) {
            return Result.fail((ErrorCode)ErrorCode.invalidParamError);
        }
        Result result = this.ruleAlertService.CreateRuleAlert(param);
        return result;
    }

    @RequestMapping(value={"/alert/{id}"}, method={RequestMethod.PUT})
    public Result UpdateRuleAlert(@PathVariable String id, @RequestBody RuleAlertParam param) {
        if (id == null || param == null) {
            return Result.fail((ErrorCode)ErrorCode.invalidParamError);
        }
        Result result = this.ruleAlertService.UpdateRuleAlert(id, param);
        return result;
    }

    @RequestMapping(value={"/alert/{id}"}, method={RequestMethod.DELETE})
    public Result DeleteRuleAlert(@PathVariable String id) {
        if (id == null) {
            return Result.fail((ErrorCode)ErrorCode.invalidParamError);
        }
        Result result = this.ruleAlertService.DeleteRuleAlert(id);
        return result;
    }

    @RequestMapping(value={"/alert/{id}"}, method={RequestMethod.GET})
    public Result GetRuleAlert(@PathVariable String id) {
        if (id == null) {
            return Result.fail((ErrorCode)ErrorCode.invalidParamError);
        }
        Result result = this.ruleAlertService.GetRuleAlert(id);
        return result;
    }

    @RequestMapping(value={"/alert/list"}, method={RequestMethod.GET})
    public Result GetRuleAlertList(Integer pageSize, Integer pageNo) {
        if (pageSize == null && pageNo == null) {
            return Result.fail((ErrorCode)ErrorCode.invalidParamError);
        }
        if (pageSize == null) {
            pageSize = Commons.COMMON_PAGE_SIZE;
        }
        if (pageNo == null) {
            pageNo = Commons.COMMON_PAGE_NO;
        }
        Result result = this.ruleAlertService.GetRuleAlertList(pageSize, pageNo);
        return result;
    }

    @RequestMapping(value={"/alert/enabled/{id}"}, method={RequestMethod.PUT})
    public Result EnabledRuleAlert(@PathVariable String id, String enabled) {
        if (id == null || StringUtils.isBlank((CharSequence)enabled) || !enabled.equals("0") && !enabled.equals("1")) {
            return Result.fail((ErrorCode)ErrorCode.invalidParamError);
        }
        Result result = this.ruleAlertService.EnabledRuleAlert(id, enabled);
        return result;
    }

    @RequestMapping(value={"/alert/sendAlert"}, method={RequestMethod.POST})
    public Result sendAlert(@RequestBody String body) {
        Result result = this.ruleAlertService.SendAlert(body);
        return result;
    }
}

