/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ozhera.operator.service;

import com.google.common.base.Preconditions;
import com.google.gson.Gson;
import io.fabric8.kubernetes.api.model.KubernetesResourceList;
import io.fabric8.kubernetes.api.model.LoadBalancerIngress;
import io.fabric8.kubernetes.api.model.LoadBalancerStatus;
import io.fabric8.kubernetes.api.model.Node;
import io.fabric8.kubernetes.api.model.NodeAddress;
import io.fabric8.kubernetes.api.model.NodeList;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.fabric8.kubernetes.api.model.Pod;
import io.fabric8.kubernetes.api.model.PodList;
import io.fabric8.kubernetes.api.model.Service;
import io.fabric8.kubernetes.api.model.ServiceList;
import io.fabric8.kubernetes.api.model.ServicePort;
import io.fabric8.kubernetes.api.model.ServiceSpec;
import io.fabric8.kubernetes.api.model.apps.Deployment;
import io.fabric8.kubernetes.api.model.apps.DeploymentList;
import io.fabric8.kubernetes.client.KubernetesClient;
import io.fabric8.kubernetes.client.dsl.MixedOperation;
import io.fabric8.kubernetes.client.dsl.NonNamespaceOperation;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.Reader;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.time.Instant;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantLock;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.text.StringSubstitutor;
import org.apache.ibatis.jdbc.ScriptRunner;
import org.apache.ozhera.operator.bo.HeraBootstrap;
import org.apache.ozhera.operator.bo.HeraObjectMeta;
import org.apache.ozhera.operator.bo.HeraResource;
import org.apache.ozhera.operator.bo.HeraSpec;
import org.apache.ozhera.operator.bo.HeraStatus;
import org.apache.ozhera.operator.bo.PropConf;
import org.apache.ozhera.operator.common.FileUtils;
import org.apache.ozhera.operator.common.K8sUtilBean;
import org.apache.ozhera.operator.common.ResourceTypeEnum;
import org.apache.ozhera.operator.dto.DeployStateDTO;
import org.apache.ozhera.operator.dto.HeraOperatorDefineDTO;
import org.apache.ozhera.operator.dto.PodStateDTO;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@com.xiaomi.youpin.docean.anno.Service
public class HeraBootstrapInitService {
    private static final Logger log = LoggerFactory.getLogger(HeraBootstrapInitService.class);
    private Gson gson = new Gson();
    @Resource
    private KubernetesClient kubernetesClient;
    @Resource(name="deploymentClient")
    private MixedOperation<Deployment, DeploymentList, io.fabric8.kubernetes.client.dsl.Resource<Deployment>> deploymentClient;
    @Resource
    private K8sUtilBean k8sUtilBean;
    private volatile HeraOperatorDefineDTO heraOperatorDefine = new HeraOperatorDefineDTO();
    private ReentrantLock lock = new ReentrantLock();

    public void init() {
        try {
            HeraSpec heraSpec = new HeraSpec();
            HeraObjectMeta heraMeta = new HeraObjectMeta();
            heraMeta.setName("ozhera-bootstrap");
            heraMeta.setNamespace("ozhera-namespace");
            ArrayList<HeraResource> resourceList = new ArrayList<HeraResource>();
            heraSpec.setResourceList(resourceList);
            HeraResource mysql = HeraResource.builder().needCreate(true).required(true).defaultYamlPath("/ozhera_init/mysql/ozhera_mysql.yaml").resourceType(ResourceTypeEnum.MYSQL.getTypeName()).resourceName("hera-mysql").remark("local pv, Make sure the disk directory has been created in advance.").build();
            mysql.setDefaultYaml();
            ArrayList<Map<String, String>> mysqlConnectionMapList = new ArrayList<Map<String, String>>();
            mysqlConnectionMapList.add(this.kvMap("hera.datasource.url", "mone-db-all:3306", "mysql address\uff0chost:port"));
            mysqlConnectionMapList.add(this.kvMap("hera.datasource.username", "root", "user name"));
            mysqlConnectionMapList.add(this.kvMap("hera.datasource.password", "Mone_123456", "password"));
            mysql.setConnectionMapList(mysqlConnectionMapList);
            resourceList.add(mysql);
            HeraResource redis = HeraResource.builder().needCreate(true).required(true).defaultYamlPath("/ozhera_init/redis/ozhera_redis.yaml").resourceType(ResourceTypeEnum.REDIS.getTypeName()).resourceName("hera-redis").remark("local redis.").build();
            redis.setDefaultYaml();
            ArrayList<Map<String, String>> redisConnectionMapList = new ArrayList<Map<String, String>>();
            redisConnectionMapList.add(this.kvMap("hera.redis.url", "redis-service:6379", "redis address, host:port"));
            redisConnectionMapList.add(this.kvMap("hera.redis.password", "", "redis pwd, optional", "0"));
            redis.setConnectionMapList(redisConnectionMapList);
            resourceList.add(redis);
            HeraResource es = HeraResource.builder().needCreate(true).required(true).defaultYamlPath("/ozhera_init/es/ozhera_es.yaml").resourceType(ResourceTypeEnum.ES.getTypeName()).resourceName("hera-es").remark("local es").build();
            es.setDefaultYaml();
            ArrayList<Map<String, String>> esConnectionMapList = new ArrayList<Map<String, String>>();
            esConnectionMapList.add(this.kvMap("hera.es.url", "elasticsearch:9200", "es address, host:port"));
            esConnectionMapList.add(this.kvMap("hera.es.username", "", "es user name, optional", "0"));
            esConnectionMapList.add(this.kvMap("hera.es.password", "", "es password, optional", "0"));
            es.setConnectionMapList(esConnectionMapList);
            resourceList.add(es);
            HeraResource rocketMQ = HeraResource.builder().needCreate(true).required(true).defaultYamlPath("/ozhera_init/rocketmq/ozhera_rocketmq.yaml").resourceType(ResourceTypeEnum.ROCKETMQ.getTypeName()).resourceName("hera-rocketMQ").remark("local rocketMQ").build();
            rocketMQ.setDefaultYaml();
            ArrayList<Map<String, String>> rocketMQConnectionMapList = new ArrayList<Map<String, String>>();
            rocketMQConnectionMapList.add(this.kvMap("hera.rocketmq.nameserver", "rocketmq-name-server-service:9876", "rocketMQ address\uff0chost:port"));
            rocketMQConnectionMapList.add(this.kvMap("hera.rocketmq.ak", "", "rocketMQ accessKey\uff0coptional", "0"));
            rocketMQConnectionMapList.add(this.kvMap("hera.rocketmq.sk", "", "rocketMQ secretKey\uff0coptional", "0"));
            rocketMQ.setConnectionMapList(rocketMQConnectionMapList);
            resourceList.add(rocketMQ);
            HeraResource nacos = HeraResource.builder().needCreate(true).required(true).defaultYamlPath("/ozhera_init/nacos/ozhera_nacos.yml").resourceType(ResourceTypeEnum.Nacos.getTypeName()).resourceName("hera-nacos").remark("load nacos").defaultExtendConfigPath(new String[]{"/ozhera_init/nacos/config/hera_app_config_#_DEFAULT_GROUP.properties", "/ozhera_init/nacos/config/hera_log_manager_open_#_DEFAULT_GROUP.properties", "/ozhera_init/nacos/config/hera_trace_config_#_DEFAULT_GROUP.properties", "/ozhera_init/nacos/config/log_stream_dataId_open_#_DEFAULT_GROUP.properties", "/ozhera_init/nacos/config/mi_tpc_#_DEFAULT_GROUP.properties", "/ozhera_init/nacos/config/mi_tpc_login_#_DEFAULT_GROUP.properties", "/ozhera_init/nacos/config/mimonitor_open_config_#_DEFAULT_GROUP.properties", "/ozhera_init/nacos/config/prometheus_agent_open_config_#_DEFAULT_GROUP.properties"}).build();
            nacos.setDefaultYaml();
            nacos.setDefaultExtendConfig();
            ArrayList<Map<String, String>> connectionMapList = new ArrayList<Map<String, String>>();
            connectionMapList.add(this.kvMap("hera.nacos.address", "nacos:80", "nacos address, host:ip"));
            connectionMapList.add(this.kvMap("hera.nacos.username", "nacos", "nacos user name, optional", "0"));
            connectionMapList.add(this.kvMap("hera.nacos.password", "nacos", "nacos password, optional", "0"));
            nacos.setConnectionMapList(connectionMapList);
            resourceList.add(nacos);
            HeraResource tpcLoginFe = HeraResource.builder().needCreate(true).required(true).defaultYamlPath("/ozhera_init/tpc-login-fe/ozhera_tpc_login_fe.yml").resourceType(ResourceTypeEnum.HERA_FE.getTypeName()).resourceName("hera-tpc-login-fe").remark("load tpc-login-fe").build();
            tpcLoginFe.setDefaultYaml();
            ArrayList<Map<String, String>> tpcLoginFeConnectionMapList = new ArrayList<Map<String, String>>();
            tpcLoginFe.setConnectionMapList(tpcLoginFeConnectionMapList);
            resourceList.add(tpcLoginFe);
            HeraResource grafana = HeraResource.builder().needCreate(true).required(true).defaultYamlPath("/ozhera_init/grafana/ozhera_grafana.yaml").resourceType(ResourceTypeEnum.GRAFANA.getTypeName()).resourceName("hera-grafana").remark("local pv, Make sure the disk directory has been created in advance.").build();
            grafana.setDefaultYaml();
            ArrayList<Map<String, String>> grafanaConnectionMapList = new ArrayList<Map<String, String>>();
            grafana.setConnectionMapList(grafanaConnectionMapList);
            resourceList.add(grafana);
            HeraResource prometheus = HeraResource.builder().needCreate(true).required(true).defaultYamlPath("/ozhera_init/prometheus/ozhera_prometheus.yaml").resourceType(ResourceTypeEnum.PROMETHEUS.getTypeName()).resourceName("hera-prometheus").remark("local pv, Make sure the disk directory has been created in advance.").build();
            prometheus.setDefaultYaml();
            ArrayList<Map<String, String>> prometheusConnectionMapList = new ArrayList<Map<String, String>>();
            prometheus.setConnectionMapList(prometheusConnectionMapList);
            resourceList.add(prometheus);
            HeraResource heraFe = HeraResource.builder().needCreate(true).required(true).defaultYamlPath("/ozhera_init/hera-fe/ozhera_fe.yml").resourceType(ResourceTypeEnum.HERA_FE.getTypeName()).resourceName("hera-fe").remark("load hera-fe").build();
            heraFe.setDefaultYaml();
            ArrayList<Map<String, String>> heraFeConnectionMapList = new ArrayList<Map<String, String>>();
            heraFe.setConnectionMapList(heraFeConnectionMapList);
            resourceList.add(heraFe);
            HeraResource alertManager = HeraResource.builder().needCreate(true).required(true).defaultYamlPath("/ozhera_init/alertManager/ozhera_alertmanager.yaml").resourceType(ResourceTypeEnum.ALERT_MANAGER.getTypeName()).resourceName("hera-alertmanager").remark("local pv, Make sure the disk directory has been created in advance.").build();
            alertManager.setDefaultYaml();
            resourceList.add(alertManager);
            HeraResource tpcLogin = HeraResource.builder().needCreate(true).required(true).defaultYamlPath("/ozhera_init/tpc-login/ozhera_tpc_login.yml").resourceType(ResourceTypeEnum.HERA_APP.getTypeName()).resourceName("hera-tpc-login").remark("load tpc-login").build();
            tpcLogin.setDefaultYaml();
            resourceList.add(tpcLogin);
            HeraResource traceEtlEs = HeraResource.builder().needCreate(true).required(true).defaultYamlPath("/ozhera_init/trace-etl-es/ozhera_trace_etl_es.yml").resourceType(ResourceTypeEnum.HERA_APP.getTypeName()).resourceName("trace-etl-es").remark("load trace-etl-es").build();
            traceEtlEs.setDefaultYaml();
            resourceList.add(traceEtlEs);
            HeraResource cadvisor = HeraResource.builder().needCreate(true).required(true).defaultYamlPath("/ozhera_init/cadvisor/ozhera_cadvisor.yaml").resourceType(ResourceTypeEnum.CADVISOR.getTypeName()).resourceName("hera-cadvisor").remark("local pv, Make sure the disk directory has been created in advance.").build();
            cadvisor.setDefaultYaml();
            ArrayList<Map<String, String>> cadvisorConnectionMapList = new ArrayList<Map<String, String>>();
            cadvisor.setConnectionMapList(cadvisorConnectionMapList);
            resourceList.add(cadvisor);
            HeraResource node_exporter = HeraResource.builder().needCreate(true).required(true).defaultYamlPath("/ozhera_init/node-exporter/ozhera_node-exporter.yaml").resourceType(ResourceTypeEnum.NODE_EXPORTER.getTypeName()).resourceName("hera-node-exporter").remark("local pv, Make sure the disk directory has been created in advance.").build();
            node_exporter.setDefaultYaml();
            ArrayList<Map<String, String>> node_exporterConnectionMapList = new ArrayList<Map<String, String>>();
            node_exporter.setConnectionMapList(node_exporterConnectionMapList);
            resourceList.add(node_exporter);
            HeraResource heraApp = HeraResource.builder().needCreate(true).required(true).defaultYamlPath("/ozhera_init/hera-app/ozhera_app.yml").resourceType(ResourceTypeEnum.HERA_APP.getTypeName()).resourceName("hera-app").remark("load hera-app").build();
            heraApp.setDefaultYaml();
            resourceList.add(heraApp);
            HeraResource logManager = HeraResource.builder().needCreate(true).required(true).defaultYamlPath("/ozhera_init/log-manager/ozhera_log_manager.yml").resourceType(ResourceTypeEnum.HERA_APP.getTypeName()).resourceName("hera-log-manager").remark("load log-manager").build();
            logManager.setDefaultYaml();
            resourceList.add(logManager);
            HeraResource logAgentServer = HeraResource.builder().needCreate(true).required(true).defaultYamlPath("/ozhera_init/log-agent-server/ozhera_log_agent-server.yml").resourceType(ResourceTypeEnum.HERA_APP.getTypeName()).resourceName("hera-log-agent-server").remark("load log-agent-server").build();
            logAgentServer.setDefaultYaml();
            resourceList.add(logAgentServer);
            HeraResource logStream = HeraResource.builder().needCreate(true).required(true).defaultYamlPath("/ozhera_init/log-stream/ozhera_log_stream.yml").resourceType(ResourceTypeEnum.HERA_APP.getTypeName()).resourceName("hera-log-stream").remark("load log-stream").build();
            logStream.setDefaultYaml();
            resourceList.add(logStream);
            HeraResource mimonitor = HeraResource.builder().needCreate(true).required(true).defaultYamlPath("/ozhera_init/mimonitor/ozhera_mimonitor.yml").resourceType(ResourceTypeEnum.HERA_APP.getTypeName()).resourceName("hera-mimonitor").remark("load mimonitor").build();
            mimonitor.setDefaultYaml();
            resourceList.add(mimonitor);
            HeraResource tpc = HeraResource.builder().needCreate(true).required(true).defaultYamlPath("/ozhera_init/tpc/ozhera_tpc.yml").resourceType(ResourceTypeEnum.HERA_APP.getTypeName()).resourceName("hera-tpc").remark("load tpc").build();
            tpc.setDefaultYaml();
            resourceList.add(tpc);
            HeraResource tpcFe = HeraResource.builder().needCreate(true).required(true).defaultYamlPath("/ozhera_init/tpc-fe/ozhera_tpc_fe.yml").resourceType(ResourceTypeEnum.HERA_FE.getTypeName()).resourceName("hera-tpc-fe").remark("load tpc-fe").build();
            tpcFe.setDefaultYaml();
            resourceList.add(tpcFe);
            HeraResource traceEtlManager = HeraResource.builder().needCreate(true).required(true).defaultYamlPath("/ozhera_init/trace-etl-manager/ozhera_trace_etl_manager.yml").resourceType(ResourceTypeEnum.HERA_APP.getTypeName()).resourceName("hera-trace_etl_manager").remark("load trace-etl-manager").build();
            traceEtlManager.setDefaultYaml();
            resourceList.add(traceEtlManager);
            HeraResource traceEtlServer = HeraResource.builder().needCreate(true).required(true).defaultYamlPath("/ozhera_init/trace-etl-server/ozhera_trace_etl_server.yml").resourceType(ResourceTypeEnum.HERA_APP.getTypeName()).resourceName("hera-trace-etl-server").remark("load trace-etl-server").build();
            traceEtlServer.setDefaultYaml();
            resourceList.add(traceEtlServer);
            HeraResource heraWebhook = HeraResource.builder().needCreate(true).required(true).defaultYamlPath("/ozhera_init/webhook/ozhera_webhook_server.yaml").resourceType(ResourceTypeEnum.HERA_WEBHOOK.getTypeName()).resourceName("hera-webhook").remark("load hera-webhook").build();
            heraWebhook.setDefaultYaml();
            resourceList.add(heraWebhook);
            HeraResource demoServer = HeraResource.builder().needCreate(true).required(true).defaultYamlPath("/ozhera_init/demo/ozhera_demo_server.yml").resourceType(ResourceTypeEnum.OTHER.getTypeName()).resourceName("hera-demo-server").remark("load hera-demo-server").build();
            demoServer.setDefaultYaml();
            resourceList.add(demoServer);
            HeraResource demoClient = HeraResource.builder().needCreate(true).required(true).defaultYamlPath("/ozhera_init/demo/ozhera_demo_client.yml").resourceType(ResourceTypeEnum.OTHER.getTypeName()).resourceName("hera-demo-client").remark("load hera-demo-client").build();
            demoClient.setDefaultYaml();
            resourceList.add(demoClient);
            this.heraOperatorDefine.setHeraSpec(heraSpec);
            this.heraOperatorDefine.setHeraMeta(heraMeta);
            log.warn("##heraOperatorDefine load success##");
        }
        catch (Exception e) {
            log.error("HeraOperatorController init error:", (Throwable)e);
            throw new RuntimeException("HeraOperatorController init error");
        }
    }

    public HeraOperatorDefineDTO getResource() {
        return this.heraOperatorDefine;
    }

    public HeraOperatorDefineDTO updateResource(HeraOperatorDefineDTO heraOperatorDefine) {
        this.lock.lock();
        try {
            this.preCheck(heraOperatorDefine);
            this.replacePlaceholder(heraOperatorDefine);
            HeraOperatorDefineDTO heraOperatorDefineDTO = this.heraOperatorDefine = heraOperatorDefine;
            return heraOperatorDefineDTO;
        }
        finally {
            this.lock.unlock();
        }
    }

    private void replacePlaceholder(HeraOperatorDefineDTO heraOperatorDefine) {
        HeraSpec heraSpec = heraOperatorDefine.getHeraSpec();
        HashMap<String, String> params = new HashMap<String, String>();
        for (HeraResource heraResource : heraSpec.getResourceList()) {
            List<PropConf> propList;
            if (null != heraResource.getConnectionMapList()) {
                for (Map<String, String> m : heraResource.getConnectionMapList()) {
                    params.put(m.get("key"), m.get("value"));
                }
            }
            if (!ResourceTypeEnum.Nacos.getTypeName().equals(heraResource.getResourceType()) || null == (propList = heraResource.getPropList())) continue;
            StringSubstitutor sub = new StringSubstitutor(params);
            for (PropConf propConf : propList) {
                String properties = propConf.getValue();
                String replacedString = sub.replace(properties);
                propConf.setValue(replacedString);
            }
        }
    }

    private void preCheck(HeraOperatorDefineDTO heraOperatorDefine) {
        Preconditions.checkArgument((null != heraOperatorDefine.getHeraMeta() ? 1 : 0) != 0, (Object)"heraMeta can not be null");
        Preconditions.checkArgument((null != heraOperatorDefine.getHeraMeta().getName() ? 1 : 0) != 0);
        Preconditions.checkArgument((null != heraOperatorDefine.getHeraMeta().getNamespace() ? 1 : 0) != 0);
        Preconditions.checkArgument((null != heraOperatorDefine.getHeraSpec() ? 1 : 0) != 0);
        Preconditions.checkArgument((null != heraOperatorDefine.getHeraSpec().getResourceList() ? 1 : 0) != 0);
        List<HeraResource> resourceList = heraOperatorDefine.getHeraSpec().getResourceList();
        HashSet<String> resourceNameSet = new HashSet<String>();
        for (HeraResource hr : resourceList) {
            String resourceName = hr.getResourceName();
            Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)resourceName));
            if (resourceNameSet.contains(resourceName)) {
                throw new IllegalArgumentException(String.format("resourceName:%s must be unique", resourceName));
            }
            resourceNameSet.add(resourceName);
            if (null == hr.getNeedCreate() || !hr.getNeedCreate().booleanValue()) continue;
            Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)hr.getYamlStr()), (Object)String.format("resource:%s yaml content can not be empty", resourceName));
        }
    }

    public List<DeployStateDTO> crState() {
        ArrayList<DeployStateDTO> result = new ArrayList<DeployStateDTO>();
        String namespace = this.heraOperatorDefine.getHeraMeta().getNamespace();
        DeploymentList deploymentList = (DeploymentList)((NonNamespaceOperation)this.deploymentClient.inNamespace(namespace)).list();
        List list = deploymentList.getItems();
        if (CollectionUtils.isEmpty((Collection)list)) {
            new ArrayList();
        }
        for (Deployment deployment : list) {
            Integer readyReplicas;
            DeployStateDTO deployStateDTO = new DeployStateDTO();
            boolean ready = true;
            String deploymentName = deployment.getMetadata().getName();
            Integer replicas = deployment.getStatus().getReplicas();
            if (replicas != (readyReplicas = deployment.getStatus().getReadyReplicas())) {
                ready = false;
            }
            deployStateDTO.setReady(ready);
            deployStateDTO.setDeploymentName(deploymentName);
            deployStateDTO.setReadyState((null == readyReplicas ? 0 : readyReplicas) + "/" + replicas);
            deployStateDTO.setAge(deployment.getMetadata().getCreationTimestamp());
            result.add(deployStateDTO);
        }
        return result;
    }

    public List<PodStateDTO> crState1() {
        ArrayList<PodStateDTO> podStateDTOList = new ArrayList<PodStateDTO>();
        String namespace = this.heraOperatorDefine.getHeraMeta().getNamespace();
        PodList podList = (PodList)((NonNamespaceOperation)this.kubernetesClient.pods().inNamespace(namespace)).list();
        for (Pod pod : podList.getItems()) {
            List containerStatusList = pod.getStatus().getContainerStatuses();
            if (CollectionUtils.isEmpty((Collection)containerStatusList)) continue;
            containerStatusList.stream().forEach(c -> {
                PodStateDTO podStateDTO = new PodStateDTO();
                podStateDTO.setPodName(pod.getMetadata().getName());
                podStateDTO.setNamespace(pod.getMetadata().getNamespace());
                podStateDTO.setImage(c.getImage());
                podStateDTO.setContainerID(c.getContainerID());
                podStateDTO.setReady(c.getReady());
                podStateDTO.setStarted(c.getStarted());
                podStateDTO.setLastState(c.getLastState());
                podStateDTO.setState(c.getState());
                podStateDTOList.add(podStateDTO);
            });
        }
        log.warn("hera operator status:{}", (Object)this.gson.toJson(podStateDTOList));
        return podStateDTOList;
    }

    public boolean crExists(String namespace) {
        MixedOperation heraMixedOperation = this.kubernetesClient.resources(HeraBootstrap.class);
        List crList = ((KubernetesResourceList)heraMixedOperation.list()).getItems();
        return CollectionUtils.isNotEmpty((Collection)crList);
    }

    public HeraStatus createOrReplaceCr() {
        HeraBootstrap result;
        HeraBootstrap heraBootstrap = new HeraBootstrap();
        HeraStatus heraStatus = new HeraStatus();
        ObjectMeta objectMeta = new ObjectMeta();
        String namespace = this.heraOperatorDefine.getHeraMeta().getNamespace();
        MixedOperation heraMixedOperation = this.kubernetesClient.resources(HeraBootstrap.class);
        List crList = ((KubernetesResourceList)heraMixedOperation.list()).getItems();
        if (CollectionUtils.isEmpty((Collection)crList)) {
            objectMeta.setNamespace(namespace);
            objectMeta.setName(this.heraOperatorDefine.getHeraMeta().getName());
            heraBootstrap.setSpec(this.heraOperatorDefine.getHeraSpec());
            heraBootstrap.setStatus(heraStatus);
            heraBootstrap.setMetadata(objectMeta);
            result = (HeraBootstrap)((Object)((NonNamespaceOperation)heraMixedOperation.inNamespace(namespace)).create((Object)heraBootstrap));
        } else {
            HeraBootstrap exists = (HeraBootstrap)((Object)crList.get(0));
            exists.setSpec(this.heraOperatorDefine.getHeraSpec());
            exists.setStatus(heraStatus);
            result = (HeraBootstrap)((Object)((NonNamespaceOperation)heraMixedOperation.inNamespace(namespace)).replace((Object)exists));
        }
        log.warn("hera operator result:{}", (Object)this.gson.toJson((Object)result));
        return (HeraStatus)result.getStatus();
    }

    public Boolean deleteCr() {
        HeraBootstrap heraBootstrap = new HeraBootstrap();
        HeraStatus heraStatus = new HeraStatus();
        ObjectMeta objectMeta = new ObjectMeta();
        String namespace = this.heraOperatorDefine.getHeraMeta().getNamespace();
        objectMeta.setNamespace(namespace);
        objectMeta.setName(this.heraOperatorDefine.getHeraMeta().getName());
        heraBootstrap.setSpec(this.heraOperatorDefine.getHeraSpec());
        heraBootstrap.setStatus(heraStatus);
        heraBootstrap.setMetadata(objectMeta);
        MixedOperation heraMixedOperation = this.kubernetesClient.resources(HeraBootstrap.class);
        Boolean result = ((NonNamespaceOperation)heraMixedOperation.inNamespace(namespace)).delete((Object[])new HeraBootstrap[]{heraBootstrap});
        log.warn("hera operator delete result:{}", (Object)result);
        return result;
    }

    public void deleteService(List<String> serviceNameList, String namespace, String serviceType) {
        List<Service> serviceList = this.listService(serviceNameList, namespace, serviceType);
        if (CollectionUtils.isNotEmpty(serviceList)) {
            ((NonNamespaceOperation)this.kubernetesClient.services().inNamespace(namespace)).delete(serviceList);
        }
    }

    public List<Service> createAndListService(List<String> serviceNameList, String namespace, String yamlPath, String serviceType) throws InterruptedException {
        List<Service> serviceList = this.listService(serviceNameList, namespace);
        if (CollectionUtils.isEmpty(serviceList)) {
            String yaml = FileUtils.readResourceFile((String)yamlPath);
            this.k8sUtilBean.applyYaml(yaml, namespace, "add");
        }
        TimeUnit.SECONDS.sleep(2L);
        return this.listService(serviceNameList, namespace, serviceType);
    }

    public boolean checkLbServiceFailed(List<Service> serviceList, String serviceType) {
        if (CollectionUtils.isEmpty(serviceList)) {
            return true;
        }
        Map<String, String> ipPortMap = this.getServiceIpPort(serviceList, serviceType);
        if (ipPortMap.size() == serviceList.size()) {
            return false;
        }
        for (Service s : serviceList) {
            String timestamp = s.getMetadata().getCreationTimestamp();
            Long seconds = this.diffSeconds(timestamp);
            if (seconds <= 37L) continue;
            log.warn("serviceType:{} create failed : cost too many time:{}s", (Object)serviceType, (Object)seconds);
            return true;
        }
        return false;
    }

    private long diffSeconds(String timestamp) {
        Instant instant = Instant.parse(timestamp);
        ZonedDateTime utcDateTime = ZonedDateTime.ofInstant(instant, ZoneId.of("UTC"));
        ZonedDateTime beijingDateTime = utcDateTime.withZoneSameInstant(ZoneId.of("Asia/Shanghai"));
        ZonedDateTime currentDateTime = ZonedDateTime.now(ZoneId.of("Asia/Shanghai"));
        long diffSeconds = currentDateTime.toEpochSecond() - beijingDateTime.toEpochSecond();
        return diffSeconds;
    }

    private List<Service> listService(List<String> serviceNameList, String namespace) {
        ServiceList serviceList = (ServiceList)((NonNamespaceOperation)this.kubernetesClient.services().inNamespace(namespace)).list();
        return serviceList.getItems().stream().filter(s -> serviceNameList.contains(s.getMetadata().getName())).collect(Collectors.toList());
    }

    private List<Service> listService(List<String> serviceNameList, String namespace, String serviceType) {
        ServiceList serviceList = (ServiceList)((NonNamespaceOperation)this.kubernetesClient.services().inNamespace(namespace)).list();
        return serviceList.getItems().stream().filter(s -> serviceNameList.contains(s.getMetadata().getName())).filter(s -> serviceType.equalsIgnoreCase(s.getSpec().getType())).collect(Collectors.toList());
    }

    public Map<String, String> getServiceIpPort(List<Service> serviceList, String serviceType) {
        HashMap<String, String> ipPortMap = new HashMap<String, String>();
        String nodePortIP = null;
        if ("NodePort".equals(serviceType)) {
            List nodeList = ((NodeList)this.kubernetesClient.nodes().list()).getItems();
            Optional<NodeAddress> nodeAddress = ((Node)nodeList.get(0)).getStatus().getAddresses().stream().filter(address -> "InternalIP".equals(address.getType())).findAny();
            if (!nodeAddress.isPresent()) {
                throw new RuntimeException("cluster node have no internalIP");
            }
            nodePortIP = nodeAddress.get().getAddress();
            if (StringUtils.isBlank((CharSequence)nodePortIP)) {
                throw new RuntimeException("cluster node get null [NodePort] IP");
            }
        }
        for (Service service : serviceList) {
            LoadBalancerStatus lsStatus;
            List lbIngress;
            String serviceName = service.getMetadata().getName();
            ServiceSpec serviceSpec = service.getSpec();
            String type = serviceSpec.getType();
            if ("NodePort".equals(type)) {
                Integer nodePort = ((ServicePort)serviceSpec.getPorts().get(0)).getNodePort();
                ipPortMap.put(serviceName, nodePortIP + ":" + nodePort);
                continue;
            }
            if (!"LoadBalancer".equals(type) || !CollectionUtils.isNotEmpty((Collection)(lbIngress = (lsStatus = service.getStatus().getLoadBalancer()).getIngress()))) continue;
            ipPortMap.put(serviceName, ((LoadBalancerIngress)lbIngress.get(0)).getIp() + ":80");
        }
        return ipPortMap;
    }

    public String getServiceType(List<Service> serviceList) {
        Iterator<Service> iterator = serviceList.iterator();
        if (iterator.hasNext()) {
            Service service = iterator.next();
            ServiceSpec serviceSpec = service.getSpec();
            String type = serviceSpec.getType();
            return type;
        }
        return "";
    }

    private Map<String, String> kvMap(String key, String value, String remark) {
        return this.kvMap(key, value, remark, "1");
    }

    private Map<String, String> kvMap(String key, String value, String remark, String required) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("key", key);
        map.put("value", value);
        map.put("remark", remark);
        map.put("required", required);
        return map;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void executeSqlScript(File[] sqlFiles, String url, String userName, String pwd) {
        Connection con = null;
        try {
            DriverManager.registerDriver((Driver)new com.mysql.cj.jdbc.Driver());
            con = DriverManager.getConnection(url, userName, pwd);
            System.out.println("Connection established......");
            for (File sqlFile : sqlFiles) {
                ScriptRunner sr = new ScriptRunner(con);
                BufferedReader reader = new BufferedReader(new FileReader(sqlFile));
                sr.runScript((Reader)reader);
                ((Reader)reader).close();
            }
        }
        catch (Exception e) {
            log.error("sql execute error", (Throwable)e);
        }
        finally {
            if (null != con) {
                try {
                    con.close();
                }
                catch (SQLException throwables) {
                    throwables.printStackTrace();
                }
            }
        }
    }
}

