/*
 * Decompiled with CFR 0.152.
 */
package org.nutz.mvc.impl;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.nutz.lang.Lang;
import org.nutz.lang.Strings;
import org.nutz.mvc.ActionContext;

public class MappingNode<T> {
    private T obj;
    private T asterisk;
    private T remain;
    private MappingNode<T> quesmark;
    private Map<String, MappingNode<T>> map = new HashMap<String, MappingNode<T>>();

    private void add(T obj, String[] ss, int off) {
        if (off < ss.length) {
            String key = ss[off].toLowerCase();
            ++off;
            if ("*".equals(key)) {
                if (off < ss.length) {
                    throw Lang.makeThrow("char '*' should be the last item in a Path '../**/%s'", Lang.concat(off, ss.length - off, "/", ss));
                }
                this.asterisk = obj;
            } else if ("**".equals(key)) {
                if (off < ss.length) {
                    throw Lang.makeThrow("'**' should be the last item in a Path '../**/%s'", Lang.concat(off, ss.length - off, "/", ss));
                }
                this.remain = obj;
            } else if ("?".equals(key)) {
                if (this.quesmark == null) {
                    this.quesmark = new MappingNode<T>();
                }
                super.add(obj, ss, off);
            } else {
                MappingNode<T> node = this.map.get(key);
                if (null == node) {
                    node = new MappingNode<T>();
                    this.map.put(key, node);
                }
                super.add(obj, ss, off);
            }
        } else {
            this.obj = obj;
        }
    }

    private T get(ActionContext ac, String[] ss, int off) {
        T t;
        if (off >= ss.length) {
            return this.obj == null ? (this.asterisk == null ? this.remain : this.asterisk) : this.obj;
        }
        String key = ss[off];
        MappingNode<T> node = this.map.get(key.toLowerCase());
        if (null != node && (t = super.get(ac, ss, off + 1)) != null) {
            return t;
        }
        if (this.quesmark != null) {
            ac.getPathArgs().add(key);
            t = super.get(ac, ss, off + 1);
            if (t != null) {
                return t;
            }
            ac.getPathArgs().remove(ac.getPathArgs().size() - 1);
        }
        if (null != this.asterisk) {
            List<String> pathArgs = ac.getPathArgs();
            while (off < ss.length) {
                pathArgs.add(ss[off++]);
            }
            return this.asterisk;
        }
        if (null != this.remain) {
            String ph = Lang.concat(off, ss.length - off, "/", ss).toString();
            if (!Strings.isBlank(ac.getSuffix())) {
                HttpServletRequest req = ac.getRequest();
                String url = Strings.sBlank(req.getPathInfo(), req.getServletPath());
                if (url.endsWith("/." + ac.getSuffix())) {
                    ph = ph + "/";
                }
                ph = ph + "." + ac.getSuffix();
            }
            ac.getPathArgs().add(ph);
            return this.remain;
        }
        return null;
    }

    public void add(String path, T obj) {
        try {
            String[] ss = Strings.splitIgnoreBlank(path, "/");
            this.add(obj, ss, 0);
        }
        catch (Exception e) {
            throw Lang.wrapThrow(e, "Wrong Url path format '%s'", path);
        }
    }

    public T get(ActionContext ac, String path) {
        return this.get(ac, path, null);
    }

    public T get(ActionContext ac, String path, String suffix) {
        ac.setPath(path);
        ac.setPathArgs(new LinkedList<String>());
        String[] ss = Strings.splitIgnoreBlank(path, "/");
        return this.get(ac, ss, 0);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        this.appendTo(sb, 0);
        return sb.toString();
    }

    private void appendTo(StringBuilder sb, int indent) {
        String prefix = Strings.dup("   ", indent);
        sb.append(prefix).append('<').append(Strings.sNull(this.obj, "null")).append('>');
        prefix = "\n   " + prefix;
        if (null != this.asterisk) {
            sb.append(prefix).append(" * : ").append(this.asterisk.toString());
        }
        if (null != this.quesmark) {
            sb.append(prefix).append(" ? : ");
            super.appendTo(sb, indent + 1);
        }
        for (String key : this.map.keySet()) {
            sb.append(prefix).append(" '" + key + "' : ");
            super.appendTo(sb, indent + 1);
        }
    }
}

