/*
 * Decompiled with CFR 0.152.
 */
package org.nutz.mvc.upload.util;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.nutz.lang.Encoding;
import org.nutz.lang.Lang;
import org.nutz.lang.Streams;
import org.nutz.lang.stream.StringOutputStream;
import org.nutz.mvc.upload.util.MarkMode;
import org.nutz.mvc.upload.util.RemountBytes;
import org.nutz.mvc.upload.util.RingItem;

public class BufferRing {
    private InputStream ins;
    RingItem item;
    long readed;

    private static void assertRingLength(int len) {
        if (len < 2) {
            throw Lang.makeThrow("BufferRing length can not less than 2", new Object[0]);
        }
    }

    public BufferRing(InputStream ins, int len, int width) {
        BufferRing.assertRingLength(len);
        this.ins = ins;
        this.item = new RingItem(width);
        for (int i = 1; i < len; ++i) {
            this.item = this.item.createNext();
        }
    }

    public MarkMode mark(RemountBytes rb) throws IOException {
        return this.mark(rb.bytes, rb.fails);
    }

    private MarkMode mark(byte[] bs, int[] fails) throws IOException {
        int re;
        RingItem ri = this.item;
        while ((re = ri.mark(bs, fails)) >= 0 && ri.isDone4Mark()) {
            if (re > 0) {
                if (!ri.next.isLoaded) {
                    ri.next.load(this.ins);
                    this.readed += (long)ri.next.max;
                } else if (ri.next == this.item) {
                    ri.nextmark = ri.r;
                    return MarkMode.NOT_FOUND;
                }
                if (ri.next.matchHeadingWithRemain(bs, re)) {
                    return MarkMode.FOUND;
                }
                ri.r = ri.max;
                ri.nextmark = ri.max;
            }
            if (ri.isStreamEnd) break;
            ri = ri.next;
            if (!ri.isLoaded) {
                ri.load(this.ins);
                this.readed += (long)ri.max;
            }
            if (ri != this.item) continue;
        }
        if (re == -1) {
            return MarkMode.FOUND;
        }
        return ri.isStreamEnd ? MarkMode.STREAM_END : MarkMode.NOT_FOUND;
    }

    public void dump(OutputStream ops) throws IOException {
        while (this.item.isLoaded) {
            this.item.dump(ops);
            if (this.item.isLoaded) break;
            this.item = this.item.next;
        }
        ops.flush();
    }

    String dumpAsString() throws IOException {
        StringBuilder sb = new StringBuilder();
        StringOutputStream ops = new StringOutputStream(sb, Encoding.defaultEncoding());
        this.dump(ops);
        return sb.toString();
    }

    public String dumpAsString(String charset) throws IOException {
        StringBuilder sb = new StringBuilder();
        StringOutputStream ops = new StringOutputStream(sb, charset);
        this.dump(ops);
        return sb.toString();
    }

    public void skipMark() throws IOException {
        this.dump(new OutputStream(){

            @Override
            public void write(int b) throws IOException {
            }

            @Override
            public void close() throws IOException {
            }

            @Override
            public void flush() throws IOException {
            }

            @Override
            public void write(byte[] b, int off, int len) throws IOException {
            }

            @Override
            public void write(byte[] b) throws IOException {
            }
        });
    }

    public long load() throws IOException {
        if (this.item.isStreamEnd) {
            return this.readed;
        }
        RingItem ri = this.item;
        while (!ri.isLoaded) {
            ri.load(this.ins);
            if (ri.max > 0) {
                this.readed += (long)ri.max;
            }
            ri = ri.next;
        }
        return this.readed;
    }

    public long readed() {
        return this.readed;
    }

    public void close() {
        Streams.safeClose(this.ins);
    }
}

