/*
 * Decompiled with CFR 0.152.
 */
package org.nutz.resource.impl;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;
import javax.servlet.ServletContext;
import org.nutz.resource.NutResource;
import org.nutz.resource.impl.ResourceLocation;

public class WebClassesResourceLocation
extends ResourceLocation {
    protected ServletContext sc;
    public int priority = 125;

    public WebClassesResourceLocation(ServletContext sc) {
        this.sc = sc;
    }

    @Override
    public String id() {
        return "/WEB-INF/classes/";
    }

    @Override
    public void scan(String base, Pattern pattern, List<NutResource> list) {
        if (!base.startsWith("/")) {
            base = "/" + base;
        }
        ArrayList<String> paths = new ArrayList<String>();
        this.getResources("/WEB-INF/classes" + base, paths);
        for (String path : paths) {
            if (path.equals(base)) {
                list.add(new WebClassesResource(path, base));
                continue;
            }
            String name = path.substring(path.lastIndexOf(47));
            if (pattern != null && !pattern.matcher(name).find()) continue;
            list.add(new WebClassesResource(path, base));
        }
    }

    public void getResources(String base, List<String> list) {
        Set paths = this.sc.getResourcePaths(base);
        if (paths == null) {
            return;
        }
        for (String path : paths) {
            if (path.endsWith("/")) {
                this.getResources(path, list);
                continue;
            }
            list.add(path);
        }
    }

    public class WebClassesResource
    extends NutResource {
        protected String path;
        protected String base;

        public WebClassesResource(String path, String base) {
            this.setSource("webapp:" + path);
            this.path = path;
            this.base = base;
            if (path.equals("/WEB-INF/classes" + base)) {
                this.setName(path);
            } else {
                this.setName(path.substring(("/WEB-INF/classes" + base).length()));
            }
            this.setPriority(this.priority);
        }

        @Override
        public InputStream getInputStream() throws IOException {
            return WebClassesResourceLocation.this.sc.getResourceAsStream(this.path);
        }

        @Override
        public String toString() {
            return "webapp:" + this.path;
        }
    }
}

