/*
 * Decompiled with CFR 0.152.
 */
package org.mapstruct.ap.internal.model.common;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZonedDateTime;
import org.mapstruct.ap.internal.model.common.DateFormatValidationResult;
import org.mapstruct.ap.internal.model.common.DateFormatValidator;
import org.mapstruct.ap.internal.model.common.Type;
import org.mapstruct.ap.internal.util.Message;

final class DateFormatValidatorFactory {
    private static final String JAVA_UTIL_DATE = "java.util.Date";
    private static final String JAVA_TIME_FORMAT_DATE_TIME_FORMATTER = "java.time.format.DateTimeFormatter";
    private static final String OF_PATTERN = "ofPattern";
    private static final String ORG_JODA_TIME_FORMAT_DATE_TIME_FORMAT = "org.joda.time.format.DateTimeFormat";
    private static final String FOR_PATTERN = "forPattern";

    private DateFormatValidatorFactory() {
    }

    public static DateFormatValidator forTypes(final Type sourceType, final Type targetType) {
        DateFormatValidator dateFormatValidator = DateFormatValidatorFactory.isJavaUtilDateSupposed(sourceType, targetType) ? new SimpleDateFormatValidator() : (DateFormatValidatorFactory.isXmlGregorianCalendarSupposedToBeMapped(sourceType, targetType) ? new SimpleDateFormatValidator() : (DateFormatValidatorFactory.isJava8DateTimeSupposed(sourceType, targetType) ? new JavaDateTimeDateFormatValidator() : (DateFormatValidatorFactory.isJodaDateTimeSupposed(sourceType, targetType) ? new JodaTimeDateFormatValidator() : new DateFormatValidator(){

            @Override
            public DateFormatValidationResult validate(String dateFormat) {
                return new DateFormatValidationResult(true, Message.GENERAL_UNSUPPORTED_DATE_FORMAT_CHECK, sourceType, targetType);
            }
        })));
        return dateFormatValidator;
    }

    private static boolean isXmlGregorianCalendarSupposedToBeMapped(Type sourceType, Type targetType) {
        return DateFormatValidatorFactory.typesEqualsOneOf(sourceType, targetType, "javax.xml.datatype.XMLGregorianCalendar");
    }

    private static boolean isJodaDateTimeSupposed(Type sourceType, Type targetType) {
        return DateFormatValidatorFactory.typesEqualsOneOf(sourceType, targetType, "org.joda.time.LocalDate", "org.joda.time.LocalTime", "org.joda.time.LocalDateTime", "org.joda.time.DateTime");
    }

    private static boolean isJava8DateTimeSupposed(Type sourceType, Type targetType) {
        return DateFormatValidatorFactory.typesEqualsOneOf(sourceType, targetType, LocalDate.class.getCanonicalName(), LocalTime.class.getCanonicalName(), LocalDateTime.class.getCanonicalName(), ZonedDateTime.class.getCanonicalName());
    }

    private static boolean isJavaUtilDateSupposed(Type sourceType, Type targetType) {
        return JAVA_UTIL_DATE.equals(sourceType.getFullyQualifiedName()) || JAVA_UTIL_DATE.equals(targetType.getFullyQualifiedName());
    }

    private static boolean typesEqualsOneOf(Type sourceType, Type targetType, String ... typeNames) {
        for (String typeName : typeNames) {
            if (!typeName.equals(sourceType.getFullyQualifiedName()) && !typeName.equals(targetType.getFullyQualifiedName())) continue;
            return true;
        }
        return false;
    }

    private static DateFormatValidationResult validDateFormat(String dateFormat) {
        return new DateFormatValidationResult(true, Message.GENERAL_VALID_DATE, dateFormat);
    }

    private static DateFormatValidationResult invalidDateFormat(String dateFormat, Throwable e) {
        return new DateFormatValidationResult(false, Message.GENERAL_INVALID_DATE, dateFormat, e.getMessage());
    }

    private static DateFormatValidationResult noJodaOnClassPath() {
        return new DateFormatValidationResult(false, Message.GENERAL_JODA_NOT_ON_CLASSPATH, new Object[0]);
    }

    private static class SimpleDateFormatValidator
    implements DateFormatValidator {
        private SimpleDateFormatValidator() {
        }

        @Override
        public DateFormatValidationResult validate(String dateFormat) {
            try {
                Class<?> aClass = Class.forName(SimpleDateFormat.class.getCanonicalName());
                aClass.getConstructor(String.class).newInstance(dateFormat);
                return DateFormatValidatorFactory.validDateFormat(dateFormat);
            }
            catch (InvocationTargetException e) {
                return DateFormatValidatorFactory.invalidDateFormat(dateFormat, e.getCause());
            }
            catch (Exception e) {
                return DateFormatValidatorFactory.invalidDateFormat(dateFormat, e);
            }
        }
    }

    private static class JodaTimeDateFormatValidator
    implements DateFormatValidator {
        private JodaTimeDateFormatValidator() {
        }

        @Override
        public DateFormatValidationResult validate(String dateFormat) {
            try {
                Class<?> aClass = Class.forName(DateFormatValidatorFactory.ORG_JODA_TIME_FORMAT_DATE_TIME_FORMAT);
                Method forPatternMethod = aClass.getMethod(DateFormatValidatorFactory.FOR_PATTERN, String.class);
                forPatternMethod.invoke(aClass, dateFormat);
                return DateFormatValidatorFactory.validDateFormat(dateFormat);
            }
            catch (InvocationTargetException e) {
                return DateFormatValidatorFactory.invalidDateFormat(dateFormat, e.getCause());
            }
            catch (ClassNotFoundException e) {
                return DateFormatValidatorFactory.noJodaOnClassPath();
            }
            catch (Exception e) {
                return DateFormatValidatorFactory.invalidDateFormat(dateFormat, e);
            }
        }
    }

    private static class JavaDateTimeDateFormatValidator
    implements DateFormatValidator {
        private JavaDateTimeDateFormatValidator() {
        }

        @Override
        public DateFormatValidationResult validate(String dateFormat) {
            try {
                Class<?> aClass = Class.forName(DateFormatValidatorFactory.JAVA_TIME_FORMAT_DATE_TIME_FORMATTER);
                Method ofPatternMethod = aClass.getMethod(DateFormatValidatorFactory.OF_PATTERN, String.class);
                ofPatternMethod.invoke(aClass, dateFormat);
                return DateFormatValidatorFactory.validDateFormat(dateFormat);
            }
            catch (InvocationTargetException e) {
                return DateFormatValidatorFactory.invalidDateFormat(dateFormat, e.getCause());
            }
            catch (Exception e) {
                return DateFormatValidatorFactory.invalidDateFormat(dateFormat, e);
            }
        }
    }
}

