/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fastjson2.reader;

import com.alibaba.fastjson2.JSONException;
import com.alibaba.fastjson2.JSONReader;
import com.alibaba.fastjson2.reader.FieldReaderDateTimeCodec;
import com.alibaba.fastjson2.reader.ObjectReader;
import com.alibaba.fastjson2.reader.ObjectReaderImplLocalDateTime;
import com.alibaba.fastjson2.schema.JSONSchema;
import com.alibaba.fastjson2.util.DateUtils;
import com.alibaba.fastjson2.util.UnsafeUtils;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZonedDateTime;
import java.util.Date;
import java.util.Locale;
import java.util.function.BiConsumer;

public class FieldReaderLocalDateTime<T>
extends FieldReaderDateTimeCodec<T> {
    final BiConsumer<T, ZonedDateTime> function;

    FieldReaderLocalDateTime(String fieldName, Type fieldType, Class fieldClass, int ordinal, long features, String format, Locale locale, Object defaultValue, JSONSchema schema, Field field, Method method, BiConsumer<T, ZonedDateTime> function) {
        super(fieldName, fieldType, fieldClass, ordinal, features, format, locale, defaultValue, schema, method, field);
        this.function = function;
    }

    @Override
    public boolean supportAcceptType(Class valueClass) {
        return this.fieldClass == Instant.class || this.fieldClass == Long.class;
    }

    @Override
    public void accept(Object object, long value) {
        Instant instant = Instant.ofEpochMilli(value);
        ZonedDateTime zdt = instant.atZone(DateUtils.DEFAULT_ZONE_ID);
        LocalDateTime ldt = zdt.toLocalDateTime();
        this.accept(object, ldt);
    }

    @Override
    protected void accept(Object object, Date value) {
        Instant instant = value.toInstant();
        ZonedDateTime zdt = instant.atZone(DateUtils.DEFAULT_ZONE_ID);
        LocalDateTime ldt = zdt.toLocalDateTime();
        this.accept(object, ldt);
    }

    @Override
    protected void acceptNull(Object object) {
        this.accept(object, (LocalDateTime)null);
    }

    @Override
    protected void accept(Object object, Instant instant) {
        ZonedDateTime zdt = instant.atZone(DateUtils.DEFAULT_ZONE_ID);
        LocalDateTime ldt = zdt.toLocalDateTime();
        this.accept(object, ldt);
    }

    @Override
    protected void accept(Object object, ZonedDateTime zdt) {
        LocalDateTime ldt = zdt.toLocalDateTime();
        this.accept(object, ldt);
    }

    @Override
    protected Object apply(Date value) {
        Instant instant = value.toInstant();
        ZonedDateTime zdt = instant.atZone(DateUtils.DEFAULT_ZONE_ID);
        return zdt.toLocalDateTime();
    }

    @Override
    protected Object apply(Instant instant) {
        ZonedDateTime zdt = instant.atZone(DateUtils.DEFAULT_ZONE_ID);
        return zdt.toLocalDateTime();
    }

    @Override
    protected Object apply(ZonedDateTime zdt) {
        return zdt.toLocalDateTime();
    }

    @Override
    protected Object apply(LocalDateTime ldt) {
        return ldt;
    }

    @Override
    protected Object apply(long millis) {
        Instant instant = Instant.ofEpochMilli(millis);
        ZonedDateTime zdt = instant.atZone(DateUtils.DEFAULT_ZONE_ID);
        return zdt.toLocalDateTime();
    }

    @Override
    public void accept(Object object, LocalDateTime value) {
        if (this.schema != null) {
            this.schema.assertValidate(value);
        }
        if (object == null) {
            throw new JSONException("set " + this.fieldName + " error, object is null");
        }
        if (value == null && (this.features & JSONReader.Feature.IgnoreSetNullValue.mask) != 0L) {
            return;
        }
        if (this.fieldOffset != -1L) {
            UnsafeUtils.putObject(object, this.fieldOffset, value);
            return;
        }
        try {
            this.field.set(object, value);
        }
        catch (Exception e) {
            throw new JSONException("set " + this.fieldName + " error", e);
        }
    }

    @Override
    public ObjectReader getObjectReader(JSONReader jsonReader) {
        if (this.dateReader == null) {
            this.dateReader = this.format == null ? ObjectReaderImplLocalDateTime.INSTANCE : new ObjectReaderImplLocalDateTime(this.format, this.locale);
        }
        return this.dateReader;
    }

    @Override
    public ObjectReader getObjectReader(JSONReader.Context context) {
        if (this.dateReader == null) {
            this.dateReader = this.format == null ? ObjectReaderImplLocalDateTime.INSTANCE : new ObjectReaderImplLocalDateTime(this.format, this.locale);
        }
        return this.dateReader;
    }
}

