/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.oidc.common.runtime.config;

import io.quarkus.runtime.annotations.ConfigDocDefault;
import io.quarkus.runtime.annotations.ConfigDocSection;
import io.quarkus.runtime.annotations.ConfigGroup;
import io.smallrye.config.WithDefault;
import java.nio.file.Path;
import java.time.Duration;
import java.util.Optional;
import java.util.OptionalInt;

@ConfigGroup
public interface OidcCommonConfig {
    public Optional<String> authServerUrl();

    @ConfigDocDefault(value="true")
    public Optional<Boolean> discoveryEnabled();

    public Optional<String> registrationPath();

    public Optional<Duration> connectionDelay();

    @WithDefault(value="3")
    public int connectionRetryCount();

    @WithDefault(value="10s")
    public Duration connectionTimeout();

    @WithDefault(value="false")
    public boolean useBlockingDnsLookup();

    public OptionalInt maxPoolSize();

    @WithDefault(value="true")
    public boolean followRedirects();

    @ConfigDocSection
    public Proxy proxy();

    @ConfigDocSection
    public Tls tls();

    public static interface Proxy {
        public Optional<String> host();

        @WithDefault(value="80")
        public int port();

        public Optional<String> username();

        public Optional<String> password();
    }

    public static interface Tls {
        public Optional<String> tlsConfigurationName();

        @Deprecated
        public Optional<Verification> verification();

        @Deprecated
        public Optional<Path> keyStoreFile();

        @Deprecated
        public Optional<String> keyStoreFileType();

        @Deprecated
        public Optional<String> keyStoreProvider();

        @Deprecated
        public Optional<String> keyStorePassword();

        @Deprecated
        public Optional<String> keyStoreKeyAlias();

        @Deprecated
        public Optional<String> keyStoreKeyPassword();

        @Deprecated
        public Optional<Path> trustStoreFile();

        @Deprecated
        public Optional<String> trustStorePassword();

        @Deprecated
        public Optional<String> trustStoreCertAlias();

        @Deprecated
        public Optional<String> trustStoreFileType();

        @Deprecated
        public Optional<String> trustStoreProvider();

        public static enum Verification {
            REQUIRED,
            CERTIFICATE_VALIDATION,
            NONE;

        }
    }
}

