/*
 * Decompiled with CFR 0.152.
 */
package org.apache.toree.interpreter.broker;

import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.Map;
import java.util.UUID;
import org.apache.commons.exec.CommandLine;
import org.apache.commons.exec.DefaultExecutor;
import org.apache.commons.exec.ExecuteWatchdog;
import org.apache.commons.exec.Executor;
import org.apache.commons.exec.PumpStreamHandler;
import org.apache.commons.exec.environment.EnvironmentUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOUtils;
import org.apache.toree.interpreter.broker.BrokerBridge;
import org.apache.toree.interpreter.broker.BrokerException;
import org.apache.toree.interpreter.broker.BrokerName;
import org.apache.toree.interpreter.broker.BrokerProcess$;
import org.apache.toree.interpreter.broker.BrokerProcessHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005\rf\u0001B\u0012%\u0001=B\u0001B\u000f\u0001\u0003\u0006\u0004%Ia\u000f\u0005\t\u000f\u0002\u0011\t\u0011)A\u0005y!A\u0001\n\u0001BC\u0002\u0013%1\b\u0003\u0005J\u0001\t\u0005\t\u0015!\u0003=\u0011!Q\u0005A!b\u0001\n\u0013Y\u0005\u0002C+\u0001\u0005\u0003\u0005\u000b\u0011\u0002'\t\u0011Y\u0003!Q1A\u0005\n]C\u0001b\u0017\u0001\u0003\u0002\u0003\u0006I\u0001\u0017\u0005\t9\u0002\u0011)\u0019!C\u0005;\"A\u0011\r\u0001B\u0001B\u0003%a\f\u0003\u0005c\u0001\t\u0015\r\u0011\"\u0003L\u0011!\u0019\u0007A!A!\u0002\u0013a\u0005\"\u00023\u0001\t\u0003)\u0007bB7\u0001\u0005\u0004%IA\u001c\u0005\u0007k\u0002\u0001\u000b\u0011B8\t\u000fY\u0004!\u0019!C\u0005o\"9\u0011\u0011\u0001\u0001!\u0002\u0013A\b\"CA\u0002\u0001\t\u0007I\u0011BA\u0003\u0011!\tY\u0001\u0001Q\u0001\n\u0005\u001d\u0001BCA\u0007\u0001\u0001\u0007I\u0011\u0001\u0013\u0002\u0010!Q\u0011q\u0005\u0001A\u0002\u0013\u0005A%!\u000b\t\u0011\u0005U\u0002\u0001)Q\u0005\u0003#Aa!a\u0010\u0001\t#Y\u0004\"CA!\u0001!\u0015\r\u0011\"\u0005<\u0011\u001d\t\u0019\u0005\u0001C\t\u0003\u000bBq!a\u001a\u0001\t#\tI\u0007C\u0004\u0002p\u0001!\t\"!\u001d\t\u000f\u0005e\u0004\u0001\"\u0005\u0002|!9\u0011Q\u0010\u0001\u0005\u0002\u0005}\u0004bBAA\u0001\u0011\u0005\u0011qP\u0004\n\u0003\u0007#\u0013\u0011!E\u0001\u0003\u000b3\u0001b\t\u0013\u0002\u0002#\u0005\u0011q\u0011\u0005\u0007I\u0002\"\t!!#\t\u0013\u0005-\u0005%%A\u0005\u0002\u00055%!\u0004\"s_.,'\u000f\u0015:pG\u0016\u001c8O\u0003\u0002&M\u00051!M]8lKJT!a\n\u0015\u0002\u0017%tG/\u001a:qe\u0016$XM\u001d\u0006\u0003S)\nQ\u0001^8sK\u0016T!a\u000b\u0017\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005i\u0013aA8sO\u000e\u00011c\u0001\u00011mA\u0011\u0011\u0007N\u0007\u0002e)\t1'A\u0003tG\u0006d\u0017-\u0003\u00026e\t1\u0011I\\=SK\u001a\u0004\"a\u000e\u001d\u000e\u0003\u0011J!!\u000f\u0013\u0003\u0015\t\u0013xn[3s\u001d\u0006lW-A\u0006qe>\u001cWm]:OC6,W#\u0001\u001f\u0011\u0005u\"eB\u0001 C!\ty$'D\u0001A\u0015\t\te&\u0001\u0004=e>|GOP\u0005\u0003\u0007J\na\u0001\u0015:fI\u00164\u0017BA#G\u0005\u0019\u0019FO]5oO*\u00111IM\u0001\raJ|7-Z:t\u001d\u0006lW\rI\u0001\u000eK:$(/\u001f*fg>,(oY3\u0002\u001d\u0015tGO]=SKN|WO]2fA\u0005qq\u000e\u001e5feJ+7o\\;sG\u0016\u001cX#\u0001'\u0011\u00075\u0013FH\u0004\u0002O!:\u0011qhT\u0005\u0002g%\u0011\u0011KM\u0001\ba\u0006\u001c7.Y4f\u0013\t\u0019FKA\u0002TKFT!!\u0015\u001a\u0002\u001f=$\b.\u001a:SKN|WO]2fg\u0002\nAB\u0019:pW\u0016\u0014(I]5eO\u0016,\u0012\u0001\u0017\t\u0003oeK!A\u0017\u0013\u0003\u0019\t\u0013xn[3s\u0005JLGmZ3\u0002\u001b\t\u0014xn[3s\u0005JLGmZ3!\u0003Q\u0011'o\\6feB\u0013xnY3tg\"\u000bg\u000e\u001a7feV\ta\f\u0005\u00028?&\u0011\u0001\r\n\u0002\u0015\u0005J|7.\u001a:Qe>\u001cWm]:IC:$G.\u001a:\u0002+\t\u0014xn[3s!J|7-Z:t\u0011\u0006tG\r\\3sA\u0005I\u0011M]4v[\u0016tGo]\u0001\u000bCJ<W/\\3oiN\u0004\u0013A\u0002\u001fj]&$h\bF\u0004gO\"L'n\u001b7\u0011\u0005]\u0002\u0001\"\u0002\u001e\u000e\u0001\u0004a\u0004\"\u0002%\u000e\u0001\u0004a\u0004\"\u0002&\u000e\u0001\u0004a\u0005\"\u0002,\u000e\u0001\u0004A\u0006\"\u0002/\u000e\u0001\u0004q\u0006b\u00022\u000e!\u0003\u0005\r\u0001T\u0001\u0007Y><w-\u001a:\u0016\u0003=\u0004\"\u0001]:\u000e\u0003ET!A\u001d\u0017\u0002\u000bMdg\r\u000e6\n\u0005Q\f(A\u0002'pO\u001e,'/A\u0004m_\u001e<WM\u001d\u0011\u0002\u0017\rd\u0017m]:M_\u0006$WM]\u000b\u0002qB\u0011\u0011P`\u0007\u0002u*\u00111\u0010`\u0001\u0005Y\u0006twMC\u0001~\u0003\u0011Q\u0017M^1\n\u0005}T(aC\"mCN\u001cHj\\1eKJ\fAb\u00197bgNdu.\u00193fe\u0002\n\u0011b\\;uaV$H)\u001b:\u0016\u0005\u0005\u001d\u0001cA=\u0002\n%\u0011QI_\u0001\u000b_V$\b/\u001e;ESJ\u0004\u0013aD2veJ,g\u000e^#yK\u000e,Ho\u001c:\u0016\u0005\u0005E\u0001#B\u0019\u0002\u0014\u0005]\u0011bAA\u000be\t1q\n\u001d;j_:\u0004B!!\u0007\u0002$5\u0011\u00111\u0004\u0006\u0005\u0003;\ty\"\u0001\u0003fq\u0016\u001c'bAA\u0011U\u000591m\\7n_:\u001c\u0018\u0002BA\u0013\u00037\u0011\u0001\"\u0012=fGV$xN]\u0001\u0014GV\u0014(/\u001a8u\u000bb,7-\u001e;pe~#S-\u001d\u000b\u0005\u0003W\t\t\u0004E\u00022\u0003[I1!a\f3\u0005\u0011)f.\u001b;\t\u0013\u0005MR#!AA\u0002\u0005E\u0011a\u0001=%c\u0005\u00012-\u001e:sK:$X\t_3dkR|'\u000f\t\u0015\u0004-\u0005e\u0002cA\u0019\u0002<%\u0019\u0011Q\b\u001a\u0003\u0011Y|G.\u0019;jY\u0016\fqbZ3u)6\u0004H)\u001b:fGR|'/_\u0001\u0010O\u0016$8+\u001e2ESJ,7\r^8ss\u0006!1m\u001c9z)\u0019\t9%!\u0014\u0002^A\u0019\u0011'!\u0013\n\u0007\u0005-#GA\u0002J]RDq!a\u0014\u001a\u0001\u0004\t\t&A\u0006j]B,Ho\u0015;sK\u0006l\u0007\u0003BA*\u00033j!!!\u0016\u000b\u0007\u0005]C0\u0001\u0002j_&!\u00111LA+\u0005-Ie\u000e];u'R\u0014X-Y7\t\u000f\u0005}\u0013\u00041\u0001\u0002b\u0005aq.\u001e;qkR\u001cFO]3b[B!\u00111KA2\u0013\u0011\t)'!\u0016\u0003\u0019=+H\u000f];u'R\u0014X-Y7\u0002#\r|\u0007/\u001f*fg>,(oY3U_Rk\u0007\u000fF\u0002=\u0003WBa!!\u001c\u001b\u0001\u0004a\u0014\u0001\u0003:fg>,(oY3\u0002+9,w\u000f\u0015:pG\u0016\u001c8/\u00128wSJ|g.\\3oiR\u0011\u00111\u000f\t\u0006{\u0005UD\bP\u0005\u0004\u0003o2%aA'ba\u0006Ya.Z<Fq\u0016\u001cW\u000f^8s)\t\t9\"A\u0003ti\u0006\u0014H\u000f\u0006\u0002\u0002,\u0005!1\u000f^8q\u00035\u0011%o\\6feB\u0013xnY3tgB\u0011q\u0007I\n\u0003AA\"\"!!\"\u00027\u0011bWm]:j]&$He\u001a:fCR,'\u000f\n3fM\u0006,H\u000e\u001e\u00137+\t\tyIK\u0002M\u0003#[#!a%\u0011\t\u0005U\u0015qT\u0007\u0003\u0003/SA!!'\u0002\u001c\u0006IQO\\2iK\u000e\\W\r\u001a\u0006\u0004\u0003;\u0013\u0014AC1o]>$\u0018\r^5p]&!\u0011\u0011UAL\u0005E)hn\u00195fG.,GMV1sS\u0006t7-\u001a")
public class BrokerProcess
implements BrokerName {
    private String getSubDirectory;
    private final String processName;
    private final String entryResource;
    private final Seq<String> otherResources;
    private final BrokerBridge brokerBridge;
    private final BrokerProcessHandler brokerProcessHandler;
    private final Seq<String> arguments;
    private final Logger logger;
    private final ClassLoader classLoader;
    private final String outputDir;
    private volatile Option<Executor> currentExecutor;
    private final String brokerName;
    private volatile boolean bitmap$0;

    public static Seq<String> $lessinit$greater$default$6() {
        return BrokerProcess$.MODULE$.$lessinit$greater$default$6();
    }

    @Override
    public String brokerName() {
        return this.brokerName;
    }

    @Override
    public void org$apache$toree$interpreter$broker$BrokerName$_setter_$brokerName_$eq(String x$1) {
        this.brokerName = x$1;
    }

    private String processName() {
        return this.processName;
    }

    private String entryResource() {
        return this.entryResource;
    }

    private Seq<String> otherResources() {
        return this.otherResources;
    }

    private BrokerBridge brokerBridge() {
        return this.brokerBridge;
    }

    private BrokerProcessHandler brokerProcessHandler() {
        return this.brokerProcessHandler;
    }

    private Seq<String> arguments() {
        return this.arguments;
    }

    private Logger logger() {
        return this.logger;
    }

    private ClassLoader classLoader() {
        return this.classLoader;
    }

    private String outputDir() {
        return this.outputDir;
    }

    public Option<Executor> currentExecutor() {
        return this.currentExecutor;
    }

    public void currentExecutor_$eq(Option<Executor> x$1) {
        this.currentExecutor = x$1;
    }

    public String getTmpDirectory() {
        return System.getProperty("java.io.tmpdir");
    }

    private String getSubDirectory$lzycompute() {
        BrokerProcess brokerProcess = this;
        synchronized (brokerProcess) {
            if (!this.bitmap$0) {
                this.getSubDirectory = new StringBuilder(8).append("kernel-").append(this.brokerName()).append("-").append(UUID.randomUUID().toString()).toString();
                this.bitmap$0 = true;
            }
        }
        return this.getSubDirectory;
    }

    public String getSubDirectory() {
        return !this.bitmap$0 ? this.getSubDirectory$lzycompute() : this.getSubDirectory;
    }

    public int copy(InputStream inputStream, OutputStream outputStream) {
        return IOUtils.copy((InputStream)inputStream, (OutputStream)outputStream);
    }

    public String copyResourceToTmp(String resource) {
        InputStream brokerRunnerResourceStream = this.classLoader().getResourceAsStream(resource);
        String tmpDirectory = (String)Option$.MODULE$.apply((Object)this.getTmpDirectory()).getOrElse((Function0 & Serializable & scala.Serializable)() -> {
            throw new BrokerException("java.io.tmpdir is not set!");
        });
        String subDirectory = (String)Option$.MODULE$.apply((Object)this.getSubDirectory()).getOrElse((Function0 & Serializable & scala.Serializable)() -> "");
        String outputName = FilenameUtils.getName((String)resource);
        String outputDir = ((TraversableOnce)((TraversableLike)new .colon.colon((Object)tmpDirectory, (List)new .colon.colon((Object)subDirectory, (List)Nil$.MODULE$))).filter((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)BrokerProcess.$anonfun$copyResourceToTmp$3(x$1)))).mkString("/");
        File outputScript = new File(FilenameUtils.concat((String)outputDir, (String)outputName));
        if (outputScript.exists() && outputScript.isDirectory()) {
            throw new BrokerException(new StringBuilder(25).append("Failed to create script: ").append(outputScript).toString());
        }
        File outputDirFile = new File(outputDir);
        Object object = !outputDirFile.exists() ? BoxesRunTime.boxToBoolean((boolean)outputDirFile.mkdirs()) : BoxedUnit.UNIT;
        FileOutputStream outputScriptStream = new FileOutputStream(outputScript);
        this.copy(brokerRunnerResourceStream, outputScriptStream);
        outputScriptStream.close();
        String destination = outputScript.getPath();
        this.logger().debug(new StringBuilder(24).append("Successfully copied ").append(resource).append(" to ").append(destination).toString());
        return destination;
    }

    public scala.collection.immutable.Map<String, String> newProcessEnvironment() {
        Map<String, String> procEnvironment = EnvironmentUtils.getProcEnvironment();
        return ((TraversableOnce)JavaConverters$.MODULE$.mapAsScalaMapConverter(procEnvironment).asScala()).toMap(Predef$.MODULE$.$conforms());
    }

    public Executor newExecutor() {
        return new DefaultExecutor();
    }

    public void start() {
        Option<Executor> option2 = this.currentExecutor();
        synchronized (option2) {
            Predef$.MODULE$.assert(this.currentExecutor().isEmpty(), (Function0 & Serializable & scala.Serializable)() -> "Process has already been started!");
            String capitalizedBrokerName = new StringOps(Predef$.MODULE$.augmentString(this.brokerName())).capitalize();
            String script = this.copyResourceToTmp(this.entryResource());
            this.logger().debug(new StringBuilder(21).append("New ").append(this.brokerName()).append(" script created: ").append(script).toString());
            Seq createdResources = (Seq)this.otherResources().map((Function1 & Serializable & scala.Serializable)resource -> this.copyResourceToTmp((String)resource), Seq$.MODULE$.canBuildFrom());
            String string2 = script;
            boolean createdResult = ((IterableLike)((TraversableLike)((TraversableLike)createdResources.$plus$colon((Object)string2, Seq$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)x$3 -> new File((String)x$3), Seq$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)f -> BoxesRunTime.boxToBoolean((boolean)BrokerProcess.$anonfun$start$4(this, f)), Seq$.MODULE$.canBuildFrom())).forall((Function1 & Serializable & scala.Serializable)x$4 -> BoxesRunTime.boxToBoolean((boolean)BrokerProcess.$anonfun$start$5(BoxesRunTime.unboxToBoolean((Object)x$4))));
            if (!createdResult) {
                throw new BrokerException(new StringBuilder(31).append("Failed to create resources for ").append(capitalizedBrokerName).toString());
            }
            CommandLine commandLine = CommandLine.parse(this.processName()).addArgument(script);
            this.arguments().foreach((Function1 & Serializable & scala.Serializable)x$1 -> commandLine.addArgument((String)x$1));
            this.logger().debug(new StringBuilder(10).append(capitalizedBrokerName).append(" command: ").append(commandLine.toString()).toString());
            Executor executor = this.newExecutor();
            executor.setStreamHandler(new PumpStreamHandler(System.out, System.err, System.in));
            executor.setExitValue(1);
            executor.setWatchdog(new ExecuteWatchdog(-1L));
            Map processEnvironment = (Map)JavaConverters$.MODULE$.mapAsJavaMapConverter(this.newProcessEnvironment()).asJava();
            this.logger().debug(new StringBuilder(14).append(capitalizedBrokerName).append(" environment: ").append(processEnvironment).toString());
            executor.execute(commandLine, processEnvironment, this.brokerProcessHandler());
            this.currentExecutor_$eq((Option<Executor>)new Some((Object)executor));
        }
    }

    public void stop() {
        Option<Executor> option2 = this.currentExecutor();
        synchronized (option2) {
            this.currentExecutor().foreach((Function1 & Serializable & scala.Serializable)executor -> {
                BrokerProcess.$anonfun$stop$1(this, executor);
                return BoxedUnit.UNIT;
            });
            this.currentExecutor_$eq((Option<Executor>)None$.MODULE$);
        }
    }

    public static final /* synthetic */ boolean $anonfun$copyResourceToTmp$3(String x$1) {
        return new StringOps(Predef$.MODULE$.augmentString(x$1.trim())).nonEmpty();
    }

    public static final /* synthetic */ boolean $anonfun$start$4(BrokerProcess $this, File f) {
        boolean bl;
        if (f.exists()) {
            bl = true;
        } else {
            String resource = f.getPath();
            $this.logger().warn(new StringBuilder(27).append("Failed to create resource: ").append(resource).toString());
            bl = false;
        }
        return bl;
    }

    public static final /* synthetic */ boolean $anonfun$start$5(boolean x$4) {
        return x$4;
    }

    public static final /* synthetic */ void $anonfun$stop$1(BrokerProcess $this, Executor executor) {
        $this.logger().debug(new StringBuilder(17).append("Stopping ").append($this.brokerName()).append(" process").toString());
        executor.getWatchdog().destroyProcess();
    }

    public BrokerProcess(String processName, String entryResource, Seq<String> otherResources, BrokerBridge brokerBridge, BrokerProcessHandler brokerProcessHandler, Seq<String> arguments) {
        this.processName = processName;
        this.entryResource = entryResource;
        this.otherResources = otherResources;
        this.brokerBridge = brokerBridge;
        this.brokerProcessHandler = brokerProcessHandler;
        this.arguments = arguments;
        BrokerName.$init$(this);
        Predef$.MODULE$.require(processName != null && new StringOps(Predef$.MODULE$.augmentString(processName.trim())).nonEmpty(), (Function0 & Serializable & scala.Serializable)() -> "Process name cannot be null or pure whitespace!");
        Predef$.MODULE$.require(entryResource != null && new StringOps(Predef$.MODULE$.augmentString(entryResource.trim())).nonEmpty(), (Function0 & Serializable & scala.Serializable)() -> "Entry resource cannot be null or pure whitespace!");
        this.logger = LoggerFactory.getLogger(this.getClass());
        this.classLoader = this.getClass().getClassLoader();
        this.outputDir = new StringBuilder(8).append("kernel-").append(this.brokerName()).append("-").append(UUID.randomUUID().toString()).toString();
        this.currentExecutor = None$.MODULE$;
    }
}

