/*
 * Decompiled with CFR 0.152.
 */
package zmq.socket;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import zmq.Msg;
import zmq.pipe.Pipe;
import zmq.util.Errno;
import zmq.util.ValueReference;

public class LB {
    private final List<Pipe> pipes = new ArrayList<Pipe>();
    private int active = 0;
    private int current = 0;
    private boolean more = false;
    private boolean dropping = false;

    public void attach(Pipe pipe) {
        this.pipes.add(pipe);
        this.activated(pipe);
    }

    public void terminated(Pipe pipe) {
        int index = this.pipes.indexOf(pipe);
        if (index == this.current && this.more) {
            this.dropping = true;
        }
        if (index < this.active) {
            --this.active;
            Collections.swap(this.pipes, index, this.active);
            if (this.current == this.active) {
                this.current = 0;
            }
        }
        this.pipes.remove(pipe);
    }

    public void activated(Pipe pipe) {
        Collections.swap(this.pipes, this.pipes.indexOf(pipe), this.active);
        ++this.active;
    }

    public boolean sendpipe(Msg msg, Errno errno, ValueReference<Pipe> pipe) {
        if (this.dropping) {
            this.dropping = this.more = msg.hasMore();
            return true;
        }
        while (this.active > 0) {
            if (this.pipes.get(this.current).write(msg)) {
                if (pipe == null) break;
                pipe.set(this.pipes.get(this.current));
                break;
            }
            assert (!this.more);
            --this.active;
            if (this.current < this.active) {
                Collections.swap(this.pipes, this.current, this.active);
                continue;
            }
            this.current = 0;
        }
        if (this.active == 0) {
            errno.set(35);
            return false;
        }
        this.more = msg.hasMore();
        if (!this.more) {
            this.pipes.get(this.current).flush();
            if (++this.current >= this.active) {
                this.current = 0;
            }
        }
        return true;
    }

    public boolean hasOut() {
        if (this.more) {
            return true;
        }
        while (this.active > 0) {
            if (this.pipes.get(this.current).checkWrite()) {
                return true;
            }
            --this.active;
            Collections.swap(this.pipes, this.current, this.active);
            if (this.current != this.active) continue;
            this.current = 0;
        }
        return false;
    }
}

