/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.stack.core.types.enumerated;

import org.eclipse.milo.opcua.stack.core.serialization.SerializationContext;
import org.eclipse.milo.opcua.stack.core.serialization.UaDecoder;
import org.eclipse.milo.opcua.stack.core.serialization.UaEncoder;
import org.eclipse.milo.opcua.stack.core.serialization.UaEnumeration;
import org.eclipse.milo.opcua.stack.core.serialization.codecs.GenericDataTypeCodec;
import org.eclipse.milo.opcua.stack.core.types.builtin.ExpandedNodeId;
import org.jetbrains.annotations.Nullable;

public enum AxisScaleEnumeration implements UaEnumeration
{
    Linear(0),
    Log(1),
    Ln(2);

    private final int value;

    private AxisScaleEnumeration(int value) {
        this.value = value;
    }

    @Override
    public int getValue() {
        return this.value;
    }

    @Nullable
    public static AxisScaleEnumeration from(int value) {
        switch (value) {
            case 0: {
                return Linear;
            }
            case 1: {
                return Log;
            }
            case 2: {
                return Ln;
            }
        }
        return null;
    }

    public static ExpandedNodeId getTypeId() {
        return ExpandedNodeId.parse("nsu=http://opcfoundation.org/UA/;i=12077");
    }

    public static class Codec
    extends GenericDataTypeCodec<AxisScaleEnumeration> {
        @Override
        public Class<AxisScaleEnumeration> getType() {
            return AxisScaleEnumeration.class;
        }

        @Override
        public AxisScaleEnumeration decode(SerializationContext context, UaDecoder decoder) {
            return decoder.readEnum(null, AxisScaleEnumeration.class);
        }

        @Override
        public void encode(SerializationContext context, UaEncoder encoder, AxisScaleEnumeration value) {
            encoder.writeEnum(null, value);
        }
    }
}

