/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.protocol.client;

import org.apache.iotdb.common.rpc.thrift.TSStatus;
import org.apache.iotdb.commons.conf.IoTDBConstant;
import org.apache.iotdb.db.auth.AuthorityChecker;
import org.apache.iotdb.db.conf.IoTDBConfig;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.db.exception.runtime.IntoProcessException;
import org.apache.iotdb.db.protocol.session.IClientSession;
import org.apache.iotdb.db.protocol.session.InternalClientSession;
import org.apache.iotdb.db.protocol.session.SessionManager;
import org.apache.iotdb.db.protocol.thrift.OperationType;
import org.apache.iotdb.db.queryengine.common.SessionInfo;
import org.apache.iotdb.db.queryengine.plan.Coordinator;
import org.apache.iotdb.db.queryengine.plan.analyze.ClusterPartitionFetcher;
import org.apache.iotdb.db.queryengine.plan.analyze.IPartitionFetcher;
import org.apache.iotdb.db.queryengine.plan.analyze.schema.ClusterSchemaFetcher;
import org.apache.iotdb.db.queryengine.plan.analyze.schema.ISchemaFetcher;
import org.apache.iotdb.db.queryengine.plan.execution.ExecutionResult;
import org.apache.iotdb.db.queryengine.plan.planner.LocalExecutionPlanner;
import org.apache.iotdb.db.queryengine.plan.relational.metadata.Metadata;
import org.apache.iotdb.db.queryengine.plan.relational.sql.parser.SqlParser;
import org.apache.iotdb.db.queryengine.plan.statement.Statement;
import org.apache.iotdb.db.queryengine.plan.statement.StatementType;
import org.apache.iotdb.db.queryengine.plan.statement.crud.InsertMultiTabletsStatement;
import org.apache.iotdb.db.queryengine.plan.statement.crud.InsertTabletStatement;
import org.apache.iotdb.db.utils.CommonUtils;
import org.apache.iotdb.db.utils.ErrorHandlingUtils;
import org.apache.iotdb.rpc.TSStatusCode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataNodeInternalClient {
    private static final Logger LOGGER = LoggerFactory.getLogger(DataNodeInternalClient.class);
    private static final Coordinator COORDINATOR = Coordinator.getInstance();
    private static final SessionManager SESSION_MANAGER = SessionManager.getInstance();
    private static final IoTDBConfig config = IoTDBDescriptor.getInstance().getConfig();
    private final IPartitionFetcher partitionFetcher = ClusterPartitionFetcher.getInstance();
    private final ISchemaFetcher schemaFetcher = ClusterSchemaFetcher.getInstance();
    private final IClientSession session;
    private final SqlParser relationSqlParser;
    private final Metadata metadata;

    public DataNodeInternalClient(SessionInfo sessionInfo) {
        this.metadata = LocalExecutionPlanner.getInstance().metadata;
        this.relationSqlParser = new SqlParser();
        try {
            this.session = new InternalClientSession("SELECT_INTO");
            this.session.setSqlDialect(sessionInfo.getSqlDialect());
            SESSION_MANAGER.supplySession(this.session, sessionInfo.getUserName(), sessionInfo.getZoneId(), IoTDBConstant.ClientVersion.V_1_0);
            LOGGER.info("User: {}, opens internal Session-{}.", (Object)sessionInfo.getUserName(), (Object)this.session);
        }
        catch (Exception e) {
            LOGGER.warn("User {} opens internal Session failed.", (Object)sessionInfo.getUserName(), (Object)e);
            throw new IntoProcessException(String.format("User %s opens internal Session failed.", sessionInfo.getUserName()));
        }
    }

    public TSStatus insertTablets(InsertMultiTabletsStatement statement) {
        try {
            TSStatus status = AuthorityChecker.checkAuthority((Statement)statement, this.session);
            if (status.getCode() != TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
                return status;
            }
            long queryId = SESSION_MANAGER.requestQueryId();
            ExecutionResult result = COORDINATOR.executeForTreeModel(statement, queryId, SESSION_MANAGER.getSessionInfo(this.session), "", this.partitionFetcher, this.schemaFetcher);
            return result.status;
        }
        catch (Exception e) {
            return ErrorHandlingUtils.onQueryException(e, OperationType.INSERT_TABLETS.getName(), TSStatusCode.EXECUTE_STATEMENT_ERROR);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TSStatus insertRelationalTablet(InsertTabletStatement statement) {
        long startTime = System.nanoTime();
        try {
            long queryId = SESSION_MANAGER.requestQueryId();
            ExecutionResult result = COORDINATOR.executeForTableModel(statement, this.relationSqlParser, this.session, queryId, SESSION_MANAGER.getSessionInfo(this.session), "", this.metadata, config.getConnectionTimeoutInMS());
            TSStatus tSStatus = result.status;
            return tSStatus;
        }
        catch (Exception e) {
            TSStatus tSStatus = ErrorHandlingUtils.onQueryException(e, OperationType.SELECT_INTO.getName(), TSStatusCode.EXECUTE_STATEMENT_ERROR);
            return tSStatus;
        }
        finally {
            CommonUtils.addStatementExecutionLatency(OperationType.SELECT_INTO, StatementType.SELECT_INTO.name(), System.nanoTime() - startTime);
        }
    }

    public void close() {
        SESSION_MANAGER.closeSession(this.session, COORDINATOR::cleanupQueryExecution);
    }
}

