/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.jackrabbit.core.jdkcompat;

import javax.security.auth.Subject;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.util.concurrent.Callable;

/**
 * This class contains methods replacing the deprecated
 * {@link Subject#getSubject(AccessControlContext)} 
 * and associated methods, which changed their behavior
 * with Java 23 (@see https://inside.java/2024/07/08/quality-heads-up).
 * <p>
 * Subset borrowed from org.apache.jackrabbit.oak.commons.jdkcompat
 * (see JCR-5121 and OAK-11199).
 */
public class Java23Subject {

    static Method current;

    static {
        try {
            current = Subject.class.getMethod("current");
        } catch (NoSuchMethodException ignored) {}
    }

    public static Subject getSubject() {
        Subject result;
        if (current != null) {
            try {
                result = (Subject) current.invoke(null);
            } catch (InvocationTargetException | IllegalAccessException e) {
                throw new SecurityException(e);
            }
        } else {
            result = Subject.getSubject(AccessController.getContext());
        }
        return result;
    }
}
