/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.image;

import java.util.Objects;
import org.apache.kafka.raft.OffsetAndEpoch;
import org.apache.kafka.snapshot.Snapshots;

public final class MetadataProvenance {
    public static final MetadataProvenance EMPTY = new MetadataProvenance(-1L, -1, -1L, false);
    private final long lastContainedOffset;
    private final int lastContainedEpoch;
    private final long lastContainedLogTimeMs;
    private final boolean isOffsetBatchAligned;

    public MetadataProvenance(long lastContainedOffset, int lastContainedEpoch, long lastContainedLogTimeMs, boolean isOffsetBatchAligned) {
        this.lastContainedOffset = lastContainedOffset;
        this.lastContainedEpoch = lastContainedEpoch;
        this.lastContainedLogTimeMs = lastContainedLogTimeMs;
        this.isOffsetBatchAligned = isOffsetBatchAligned;
    }

    public OffsetAndEpoch snapshotId() {
        return new OffsetAndEpoch(this.lastContainedOffset + 1L, this.lastContainedEpoch);
    }

    public long lastContainedOffset() {
        return this.lastContainedOffset;
    }

    public int lastContainedEpoch() {
        return this.lastContainedEpoch;
    }

    public long lastContainedLogTimeMs() {
        return this.lastContainedLogTimeMs;
    }

    public boolean isOffsetBatchAligned() {
        return this.isOffsetBatchAligned;
    }

    public String snapshotName() {
        return String.format("snapshot %s", Snapshots.filenameFromSnapshotId((OffsetAndEpoch)this.snapshotId()));
    }

    public boolean equals(Object o) {
        if (o == null || !o.getClass().equals(this.getClass())) {
            return false;
        }
        MetadataProvenance other = (MetadataProvenance)o;
        return this.lastContainedOffset == other.lastContainedOffset && this.lastContainedEpoch == other.lastContainedEpoch && this.lastContainedLogTimeMs == other.lastContainedLogTimeMs && this.isOffsetBatchAligned == other.isOffsetBatchAligned;
    }

    public int hashCode() {
        return Objects.hash(this.lastContainedOffset, this.lastContainedEpoch, this.lastContainedLogTimeMs, this.isOffsetBatchAligned);
    }

    public String toString() {
        return "MetadataProvenance(lastContainedOffset=" + this.lastContainedOffset + ", lastContainedEpoch=" + this.lastContainedEpoch + ", lastContainedLogTimeMs=" + this.lastContainedLogTimeMs + ", isOffsetBatchAligned=" + this.isOffsetBatchAligned + ")";
    }
}

