/*
 * Decompiled with CFR 0.152.
 */
package kafka.log;

import com.typesafe.scalalogging.Logger;
import java.io.File;
import java.io.Serializable;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import kafka.log.UnifiedLog;
import kafka.utils.Logging;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.internals.Topic;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.server.util.Scheduler;
import org.apache.kafka.storage.internals.checkpoint.LeaderEpochCheckpointFile;
import org.apache.kafka.storage.internals.epoch.LeaderEpochFileCache;
import org.apache.kafka.storage.internals.log.LoadedLogOffsets;
import org.apache.kafka.storage.internals.log.LocalLog;
import org.apache.kafka.storage.internals.log.LogConfig;
import org.apache.kafka.storage.internals.log.LogDirFailureChannel;
import org.apache.kafka.storage.internals.log.LogFileUtils;
import org.apache.kafka.storage.internals.log.LogLoader;
import org.apache.kafka.storage.internals.log.LogOffsetsListener;
import org.apache.kafka.storage.internals.log.LogSegment;
import org.apache.kafka.storage.internals.log.LogSegments;
import org.apache.kafka.storage.internals.log.LogValidator;
import org.apache.kafka.storage.internals.log.ProducerStateManager;
import org.apache.kafka.storage.internals.log.ProducerStateManagerConfig;
import org.apache.kafka.storage.log.metrics.BrokerTopicMetrics;
import org.apache.kafka.storage.log.metrics.BrokerTopicStats;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.Iterable;
import scala.collection.Seq;
import scala.jdk.CollectionConverters$;

public final class UnifiedLog$
implements Logging {
    public static final UnifiedLog$ MODULE$ = new UnifiedLog$();
    private static final String LogFileSuffix = ".log";
    private static final String IndexFileSuffix = ".index";
    private static final String TimeIndexFileSuffix = ".timeindex";
    private static final String TxnIndexFileSuffix = ".txnindex";
    private static final String CleanedFileSuffix = ".cleaned";
    private static final String SwapFileSuffix = ".swap";
    private static final String DeleteDirSuffix = "-delete";
    private static final String StrayDirSuffix = "-stray";
    private static final long UnknownOffset = -1L;
    private static Logger logger;
    private static String logIdent;
    private static volatile boolean bitmap$0;

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!bitmap$0) {
                logger = Logging.logger$(this);
                bitmap$0 = true;
            }
        }
        return logger;
    }

    @Override
    public Logger logger() {
        if (!bitmap$0) {
            return this.logger$lzycompute();
        }
        return logger;
    }

    @Override
    public String logIdent() {
        return logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        logIdent = x$1;
    }

    public boolean $lessinit$greater$default$9() {
        return false;
    }

    public LogOffsetsListener $lessinit$greater$default$10() {
        return LogOffsetsListener.NO_OP_OFFSETS_LISTENER;
    }

    public String LogFileSuffix() {
        return LogFileSuffix;
    }

    public String IndexFileSuffix() {
        return IndexFileSuffix;
    }

    public String TimeIndexFileSuffix() {
        return TimeIndexFileSuffix;
    }

    public String TxnIndexFileSuffix() {
        return TxnIndexFileSuffix;
    }

    public String CleanedFileSuffix() {
        return CleanedFileSuffix;
    }

    public String SwapFileSuffix() {
        return SwapFileSuffix;
    }

    public String DeleteDirSuffix() {
        return DeleteDirSuffix;
    }

    public String StrayDirSuffix() {
        return StrayDirSuffix;
    }

    public long UnknownOffset() {
        return UnknownOffset;
    }

    public boolean isRemoteLogEnabled(boolean remoteStorageSystemEnable, LogConfig config, String topic) {
        return remoteStorageSystemEnable && !config.compact && !Topic.isInternal((String)topic) && !"__remote_log_metadata".equals(topic) && !"__cluster_metadata".equals(topic) && config.remoteStorageEnable();
    }

    public UnifiedLog apply(File dir, LogConfig config, long logStartOffset, long recoveryPoint, Scheduler scheduler, BrokerTopicStats brokerTopicStats, Time time, int maxTransactionTimeoutMs, ProducerStateManagerConfig producerStateManagerConfig, int producerIdExpirationCheckIntervalMs, LogDirFailureChannel logDirFailureChannel, boolean lastShutdownClean, Option<Uuid> topicId, boolean keepPartitionMetadataFile, ConcurrentMap<String, Integer> numRemainingSegments, boolean remoteStorageSystemEnable, LogOffsetsListener logOffsetsListener) {
        Files.createDirectories(dir.toPath(), new FileAttribute[0]);
        TopicPartition topicPartition = LocalLog.parseTopicPartitionName((File)dir);
        LogSegments segments = new LogSegments(topicPartition);
        LeaderEpochFileCache leaderEpochCache = this.createLeaderEpochCache(dir, topicPartition, logDirFailureChannel, (Option<LeaderEpochFileCache>)None$.MODULE$, scheduler);
        ProducerStateManager producerStateManager = new ProducerStateManager(topicPartition, dir, maxTransactionTimeoutMs, producerStateManagerConfig, time);
        boolean isRemoteLogEnabled = this.isRemoteLogEnabled(remoteStorageSystemEnable, config, topicPartition.topic());
        LoadedLogOffsets offsets = new LogLoader(dir, topicPartition, config, scheduler, time, logDirFailureChannel, lastShutdownClean, segments, logStartOffset, recoveryPoint, leaderEpochCache, producerStateManager, numRemainingSegments, isRemoteLogEnabled).load();
        LocalLog localLog = new LocalLog(dir, config, segments, offsets.recoveryPoint, offsets.nextOffsetMetadata, scheduler, time, topicPartition, logDirFailureChannel);
        return new UnifiedLog(offsets.logStartOffset, localLog, brokerTopicStats, producerIdExpirationCheckIntervalMs, leaderEpochCache, producerStateManager, topicId, keepPartitionMetadataFile, remoteStorageSystemEnable, logOffsetsListener);
    }

    public boolean apply$default$12() {
        return true;
    }

    public ConcurrentMap<String, Integer> apply$default$15() {
        return new ConcurrentHashMap<String, Integer>();
    }

    public boolean apply$default$16() {
        return false;
    }

    public LogOffsetsListener apply$default$17() {
        return LogOffsetsListener.NO_OP_OFFSETS_LISTENER;
    }

    public String logDeleteDirName(TopicPartition topicPartition) {
        return LocalLog.logDeleteDirName((TopicPartition)topicPartition);
    }

    public String logFutureDirName(TopicPartition topicPartition) {
        return LocalLog.logFutureDirName((TopicPartition)topicPartition);
    }

    public String logStrayDirName(TopicPartition topicPartition) {
        return LocalLog.logStrayDirName((TopicPartition)topicPartition);
    }

    public String logDirName(TopicPartition topicPartition) {
        return LocalLog.logDirName((TopicPartition)topicPartition);
    }

    public File transactionIndexFile(File dir, long offset, String suffix) {
        return LogFileUtils.transactionIndexFile((File)dir, (long)offset, (String)suffix);
    }

    public String transactionIndexFile$default$3() {
        return "";
    }

    public long offsetFromFile(File file) {
        return Predef$.MODULE$.Long2long(LogFileUtils.offsetFromFile((File)file));
    }

    public long sizeInBytes(Collection<LogSegment> segments) {
        return LogSegments.sizeInBytes(segments);
    }

    public TopicPartition parseTopicPartitionName(File dir) {
        return LocalLog.parseTopicPartitionName((File)dir);
    }

    public LeaderEpochFileCache createLeaderEpochCache(File dir, TopicPartition topicPartition, LogDirFailureChannel logDirFailureChannel, Option<LeaderEpochFileCache> currentCache, Scheduler scheduler) {
        File leaderEpochFile = new File(dir, "leader-epoch-checkpoint");
        LeaderEpochCheckpointFile checkpointFile = new LeaderEpochCheckpointFile(leaderEpochFile, logDirFailureChannel);
        return (LeaderEpochFileCache)currentCache.map((Function1 & Serializable)x$18 -> x$18.withCheckpoint(checkpointFile)).getOrElse((Function0 & Serializable)() -> new LeaderEpochFileCache(topicPartition, checkpointFile, scheduler));
    }

    public Iterable<LogSegment> replaceSegments(LogSegments existingSegments, Seq<LogSegment> newSegments, Seq<LogSegment> oldSegments, File dir, TopicPartition topicPartition, LogConfig config, Scheduler scheduler, LogDirFailureChannel logDirFailureChannel, String logPrefix, boolean isRecoveredSwapFile) {
        return CollectionConverters$.MODULE$.ListHasAsScala(LocalLog.replaceSegments((LogSegments)existingSegments, (List)CollectionConverters$.MODULE$.SeqHasAsJava(newSegments).asJava(), (List)CollectionConverters$.MODULE$.SeqHasAsJava(oldSegments).asJava(), (File)dir, (TopicPartition)topicPartition, (LogConfig)config, (Scheduler)scheduler, (LogDirFailureChannel)logDirFailureChannel, (String)logPrefix, (boolean)isRecoveredSwapFile)).asScala();
    }

    public boolean replaceSegments$default$10() {
        return false;
    }

    public LocalLog.SplitSegmentResult splitOverflowedSegment(LogSegment segment, LogSegments existingSegments, File dir, TopicPartition topicPartition, LogConfig config, Scheduler scheduler, LogDirFailureChannel logDirFailureChannel, String logPrefix) {
        return LocalLog.splitOverflowedSegment((LogSegment)segment, (LogSegments)existingSegments, (File)dir, (TopicPartition)topicPartition, (LogConfig)config, (Scheduler)scheduler, (LogDirFailureChannel)logDirFailureChannel, (String)logPrefix);
    }

    public LogSegment createNewCleanedSegment(File dir, LogConfig logConfig, long baseOffset) {
        return LocalLog.createNewCleanedSegment((File)dir, (LogConfig)logConfig, (long)baseOffset);
    }

    public LogValidator.MetricsRecorder newValidatorMetricsRecorder(BrokerTopicMetrics allTopicsStats) {
        return new LogValidator.MetricsRecorder(allTopicsStats){
            private final BrokerTopicMetrics allTopicsStats$1;

            public void recordInvalidMagic() {
                this.allTopicsStats$1.invalidMagicNumberRecordsPerSec().mark();
            }

            public void recordInvalidOffset() {
                this.allTopicsStats$1.invalidOffsetOrSequenceRecordsPerSec().mark();
            }

            public void recordInvalidSequence() {
                this.allTopicsStats$1.invalidOffsetOrSequenceRecordsPerSec().mark();
            }

            public void recordInvalidChecksums() {
                this.allTopicsStats$1.invalidMessageCrcRecordsPerSec().mark();
            }

            public void recordNoKeyCompactedTopic() {
                this.allTopicsStats$1.noKeyCompactedTopicRecordsPerSec().mark();
            }
            {
                this.allTopicsStats$1 = allTopicsStats$1;
            }
        };
    }

    public long localRetentionMs(LogConfig config, boolean remoteLogEnabledAndRemoteCopyEnabled) {
        if (remoteLogEnabledAndRemoteCopyEnabled) {
            return config.localRetentionMs();
        }
        return config.retentionMs;
    }

    public long localRetentionSize(LogConfig config, boolean remoteLogEnabledAndRemoteCopyEnabled) {
        if (remoteLogEnabledAndRemoteCopyEnabled) {
            return config.localRetentionBytes();
        }
        return config.retentionSize;
    }

    public <T> Option<T> nextOption(Iterator<T> iterator) {
        if (iterator.hasNext()) {
            return new Some(iterator.next());
        }
        return None$.MODULE$;
    }

    private UnifiedLog$() {
    }
}

