/*
 * Decompiled with CFR 0.152.
 */
package org.apache.knox.gateway.topology.discovery.cm;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.knox.gateway.i18n.messages.MessagesFactory;
import org.apache.knox.gateway.topology.discovery.ServiceDiscovery;
import org.apache.knox.gateway.topology.discovery.cm.ClouderaManagerServiceDiscoveryMessages;
import org.apache.knox.gateway.topology.discovery.cm.ServiceModel;
import org.apache.knox.gateway.topology.discovery.cm.collector.ServiceURLCollectors;

public class ClouderaManagerCluster
implements ServiceDiscovery.Cluster {
    private static final ClouderaManagerServiceDiscoveryMessages log = (ClouderaManagerServiceDiscoveryMessages)MessagesFactory.get(ClouderaManagerServiceDiscoveryMessages.class);
    private String name;
    private Map<String, List<ServiceModel>> serviceModels = new HashMap<String, List<ServiceModel>>();

    ClouderaManagerCluster(String clusterName) {
        this.name = clusterName;
    }

    public String getName() {
        return this.name;
    }

    public List<String> getServiceURLs(String serviceName) {
        return this.getServiceURLs(serviceName, null);
    }

    public List<String> getServiceURLs(String serviceName, Map<String, String> serviceParams) {
        ArrayList<String> urls = new ArrayList<String>();
        if (this.serviceModels.containsKey(serviceName)) {
            HashMap<String, List<ServiceModel>> roleModels = new HashMap<String, List<ServiceModel>>();
            for (ServiceModel model : this.serviceModels.get(serviceName)) {
                boolean isMatchingModel = true;
                if (serviceParams != null) {
                    for (Map.Entry<String, String> serviceParam : serviceParams.entrySet()) {
                        String serviceParamKey = serviceParam.getKey();
                        if (!serviceParamKey.startsWith("discovery-") || serviceParam.getValue().equals(model.getQualifyingServiceParam(serviceParamKey))) continue;
                        isMatchingModel = false;
                        log.qualifyingServiceParamMismatch(serviceName, serviceParamKey, serviceParam.getValue(), model.getQualifyingServiceParam(serviceParamKey));
                        break;
                    }
                }
                if (!isMatchingModel) continue;
                roleModels.computeIfAbsent(model.getRoleType(), l -> new ArrayList()).add(model);
            }
            urls.addAll(ServiceURLCollectors.getCollector(serviceName).collect(roleModels));
        }
        return urls;
    }

    public ServiceDiscovery.Cluster.ZooKeeperConfig getZooKeeperConfiguration(String serviceName) {
        return null;
    }

    void addServiceModels(Set<ServiceModel> serviceModels) {
        for (ServiceModel model : serviceModels) {
            this.serviceModels.computeIfAbsent(model.getService(), l -> new ArrayList()).add(model);
        }
    }

    public Map<String, List<ServiceModel>> getServiceModels() {
        return this.serviceModels;
    }
}

