/*
 * Decompiled with CFR 0.152.
 */
package org.apache.knox.gateway.topology.discovery.ambari;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.knox.gateway.i18n.messages.MessagesFactory;
import org.apache.knox.gateway.topology.discovery.ambari.AmbariCluster;
import org.apache.knox.gateway.topology.discovery.ambari.AmbariServiceDiscoveryMessages;
import org.apache.knox.gateway.topology.discovery.ambari.ServiceURLCreator;

public abstract class HDFSURLCreatorBase
implements ServiceURLCreator {
    static final String CONFIG_SERVICE_NAMENODE = "NAMENODE";
    static final String CONFIG_SERVICE_HDFS = "HDFS";
    static final String CONFIG_TYPE_HDFS_SITE = "hdfs-site";
    static final String CONFIG_TYPE_CORE_SITE = "core-site";
    static final String HTTP_POLICY_PROPERTY = "dfs.http.policy";
    static final String HTTP_ONLY_POLICY = "HTTP_ONLY";
    static final String HTTPS_ONLY_POLICY = "HTTPS_ONLY";
    static final String SCHEME_HTTP = "http";
    static final String SCHEME_HTTPS = "https";
    static final String HTTP_ADDRESS_PROPERTY = "dfs.namenode.http-address";
    static final String HTTPS_ADDRESS_PROPERTY = "dfs.namenode.https-address";
    static final String NAMESERVICE_PARAM = "discovery-nameservice";
    protected AmbariServiceDiscoveryMessages log = (AmbariServiceDiscoveryMessages)MessagesFactory.get(AmbariServiceDiscoveryMessages.class);
    private AmbariCluster cluster;

    @Override
    public void init(AmbariCluster cluster) {
        this.cluster = cluster;
    }

    @Override
    public List<String> create(String service, Map<String, String> serviceParams) {
        AmbariCluster.ServiceConfiguration sc;
        ArrayList<String> urls = new ArrayList<String>();
        if (this.getTargetService().equals(service) && (sc = this.cluster.getServiceConfiguration(CONFIG_SERVICE_HDFS, CONFIG_TYPE_HDFS_SITE)) != null) {
            String nameServices = sc.getProperties().get("dfs.nameservices");
            if (nameServices != null && !nameServices.isEmpty()) {
                Map<String, String> props;
                String nameServiceNodes;
                String nsParam;
                String ns = null;
                String[] namespaces = nameServices.split(",");
                String string = nsParam = serviceParams != null ? serviceParams.get(NAMESERVICE_PARAM) : null;
                if (namespaces.length > 1 || nsParam != null) {
                    if (nsParam != null) {
                        if (!HDFSURLCreatorBase.validateDeclaredNameService(namespaces, nsParam)) {
                            this.log.undefinedHDFSNameService(nsParam);
                        }
                        ns = nsParam;
                    } else {
                        String defaultFS;
                        AmbariCluster.ServiceConfiguration coreSite = this.cluster.getServiceConfiguration(CONFIG_SERVICE_HDFS, CONFIG_TYPE_CORE_SITE);
                        if (coreSite != null && (defaultFS = coreSite.getProperties().get("fs.defaultFS")) != null) {
                            ns = defaultFS.substring(defaultFS.lastIndexOf(47) + 1);
                        }
                    }
                }
                if (ns == null) {
                    ns = namespaces[0];
                }
                if ((nameServiceNodes = (props = sc.getProperties()).get("dfs.ha.namenodes." + ns)) != null) {
                    String[] nodes;
                    String addressPropertyPrefix = this.getAddressPropertyPrefix();
                    for (String node : nodes = nameServiceNodes.split(",")) {
                        String propertyValue = HDFSURLCreatorBase.getHANameNodeHttpAddress(addressPropertyPrefix, props, ns, node);
                        if (propertyValue == null) continue;
                        urls.add(this.createURL(propertyValue));
                    }
                } else {
                    String addressPropertyPrefix = this.getAddressPropertyPrefix();
                    int i = 1;
                    String propertyValue = HDFSURLCreatorBase.getHANameNodeHttpAddress(addressPropertyPrefix, props, ns, i++);
                    while (propertyValue != null) {
                        urls.add(this.createURL(propertyValue));
                        propertyValue = HDFSURLCreatorBase.getHANameNodeHttpAddress(addressPropertyPrefix, props, ns, i++);
                    }
                }
            } else {
                urls.add(this.createURL(sc.getProperties().get(this.getAddressPropertyPrefix())));
            }
        }
        return urls;
    }

    private static boolean validateDeclaredNameService(String[] namespaces, String declaredNameService) {
        boolean isValid = false;
        if (namespaces != null) {
            for (String ns : namespaces) {
                if (!ns.equals(declaredNameService)) continue;
                isValid = true;
                break;
            }
        }
        return isValid;
    }

    private static String getHANameNodeHttpAddress(String addressPropertyPrefix, Map<String, String> props, String nameService, int index) {
        return props.get(addressPropertyPrefix + "." + nameService + ".nn" + index);
    }

    private static String getHANameNodeHttpAddress(String addressPropertyPrefix, Map<String, String> props, String nameService, String node) {
        return props.get(addressPropertyPrefix + "." + nameService + "." + node);
    }

    private String getAddressPropertyPrefix() {
        return HTTPS_ONLY_POLICY.equals(this.getHttpPolicy()) ? HTTPS_ADDRESS_PROPERTY : HTTP_ADDRESS_PROPERTY;
    }

    private String getHttpPolicy() {
        String propertyValue;
        String httpPolicy = HTTP_ONLY_POLICY;
        AmbariCluster.ServiceConfiguration sc = this.cluster.getServiceConfiguration(CONFIG_SERVICE_HDFS, CONFIG_TYPE_HDFS_SITE);
        if (sc != null && (propertyValue = sc.getProperties().get(HTTP_POLICY_PROPERTY)) != null && !propertyValue.isEmpty()) {
            httpPolicy = propertyValue;
        }
        return httpPolicy;
    }

    protected abstract String createURL(String var1);

    protected String getURLScheme() {
        return HTTPS_ONLY_POLICY.equals(this.getHttpPolicy()) ? SCHEME_HTTPS : SCHEME_HTTP;
    }
}

