/*
 * Decompiled with CFR 0.152.
 */
package org.apache.knox.gateway;

import java.util.Set;
import org.apache.knox.gateway.i18n.messages.Message;
import org.apache.knox.gateway.i18n.messages.MessageLevel;
import org.apache.knox.gateway.i18n.messages.Messages;
import org.apache.knox.gateway.i18n.messages.StackTrace;
import org.apache.knox.gateway.plang.AbstractSyntaxTree;
import org.apache.knox.gateway.plang.SyntaxException;

@Messages(logger="org.apache.knox.gateway")
public interface IdentityAsserterMessages {
    @Message(level=MessageLevel.ERROR, text="Required subject/identity not available.  Check authentication/federation provider for proper configuration.")
    public void subjectNotAvailable();

    @Message(level=MessageLevel.WARN, text="Invalid mapping parameter name: Missing required group name.")
    public void missingVirtualGroupName();

    @Message(level=MessageLevel.WARN, text="Invalid mapping {0}={1}, Parse error: {2}")
    public void parseError(String var1, String var2, SyntaxException var3);

    @Message(level=MessageLevel.WARN, text="Invalid result: {2}. Expected boolean when evaluating group {0} mapping value {1}.")
    public void invalidResult(String var1, AbstractSyntaxTree var2, Object var3);

    @Message(level=MessageLevel.DEBUG, text="Adding user {0} to group {1} based on predicate {2}")
    public void addingUserToVirtualGroup(String var1, String var2, AbstractSyntaxTree var3);

    @Message(level=MessageLevel.DEBUG, text="Checking whether user {0} (with group(s) {1}) should be added to group {2} based on predicate {3}")
    public void checkingVirtualGroup(String var1, Set<String> var2, String var3, AbstractSyntaxTree var4);

    @Message(level=MessageLevel.DEBUG, text="User {0} (with group(s) {1}) added to group(s) {2}")
    public void virtualGroups(String var1, Set<String> var2, Set<String> var3);

    @Message(level=MessageLevel.INFO, text="Using configured impersonation parameters: {0}")
    public void impersonationConfig(String var1);

    @Message(level=MessageLevel.WARN, text="Ignoring the proxyuser configuration in favor of the HadoopAuth provider's configuration.")
    public void ignoreProxyuserConfig();

    @Message(level=MessageLevel.DEBUG, text="doAsUser = {0}, RemoteUser = {1} , RemoteAddress = {2}")
    public void hadoopAuthDoAsUser(String var1, String var2, String var3);

    @Message(level=MessageLevel.DEBUG, text="Proxy user Authentication successful")
    public void hadoopAuthProxyUserSuccess();

    @Message(level=MessageLevel.ERROR, text="Proxy user Authentication failed: {0}")
    public void hadoopAuthProxyUserFailed(@StackTrace Throwable var1);

    @Message(level=MessageLevel.WARN, text="Invalid result: {2}. Expected String when evaluating mapping: {1} for user: {0}.")
    public void invalidAdvancedPrincipalMappingResult(String var1, AbstractSyntaxTree var2, Object var3);
}

