/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.impl.model.profile;

import org.apache.maven.api.di.Named;
import org.apache.maven.api.di.Singleton;
import org.apache.maven.api.model.Activation;
import org.apache.maven.api.model.ActivationProperty;
import org.apache.maven.api.model.Profile;
import org.apache.maven.api.services.BuilderProblem;
import org.apache.maven.api.services.ModelProblem;
import org.apache.maven.api.services.ModelProblemCollector;
import org.apache.maven.api.services.model.ProfileActivationContext;
import org.apache.maven.api.services.model.ProfileActivator;

@Named(value="property")
@Singleton
public class PropertyProfileActivator
implements ProfileActivator {
    @Override
    public boolean isActive(Profile profile, ProfileActivationContext context, ModelProblemCollector problems) {
        String propValue;
        Activation activation = profile.getActivation();
        if (activation == null) {
            return false;
        }
        ActivationProperty property = activation.getProperty();
        if (property == null) {
            return false;
        }
        String name = property.getName();
        boolean reverseName = false;
        if (name != null && name.startsWith("!")) {
            reverseName = true;
            name = name.substring(1);
        }
        if (name == null || name.isEmpty()) {
            problems.add(BuilderProblem.Severity.ERROR, ModelProblem.Version.BASE, "The property name is required to activate the profile " + profile.getId(), property.getLocation((Object)""));
            return false;
        }
        String sysValue = context.getUserProperty(name);
        if (sysValue == null && "packaging".equals(name)) {
            sysValue = context.getModelPackaging();
        }
        if (sysValue == null) {
            sysValue = context.getSystemProperty(name);
        }
        if ((propValue = property.getValue()) != null && !propValue.isEmpty()) {
            boolean reverseValue = false;
            if (propValue.startsWith("!")) {
                reverseValue = true;
                propValue = propValue.substring(1);
            }
            return reverseValue != propValue.equals(sysValue);
        }
        return reverseName != (sysValue != null && !sysValue.isEmpty());
    }

    @Override
    public boolean presentInConfig(Profile profile, ProfileActivationContext context, ModelProblemCollector problems) {
        Activation activation = profile.getActivation();
        if (activation == null) {
            return false;
        }
        ActivationProperty property = activation.getProperty();
        return property != null;
    }
}

