/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.view.facelets.compiler;

import jakarta.faces.component.UIComponent;
import jakarta.faces.component.UIViewRoot;
import jakarta.faces.context.ExternalContext;
import jakarta.faces.context.FacesContext;
import jakarta.faces.context.FacesContextWrapper;
import jakarta.faces.view.facelets.TagDecorator;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.myfaces.config.RuntimeConfig;
import org.apache.myfaces.config.element.ComponentTagDeclaration;
import org.apache.myfaces.config.element.facelets.FaceletTagLibrary;
import org.apache.myfaces.config.webparameters.MyfacesConfig;
import org.apache.myfaces.util.WebConfigParamUtils;
import org.apache.myfaces.util.lang.ClassUtils;
import org.apache.myfaces.view.facelets.compiler.Compiler;
import org.apache.myfaces.view.facelets.compiler.TagLibraryConfig;
import org.apache.myfaces.view.facelets.tag.ComponentTagDeclarationLibrary;
import org.apache.myfaces.view.facelets.tag.TagLibrary;
import org.apache.myfaces.view.facelets.tag.composite.CompositeLibrary;
import org.apache.myfaces.view.facelets.tag.composite.CompositeResourceLibrary;
import org.apache.myfaces.view.facelets.tag.faces.JsfLibrary;
import org.apache.myfaces.view.facelets.tag.faces.PassThroughLibrary;
import org.apache.myfaces.view.facelets.tag.faces.core.CoreLibrary;
import org.apache.myfaces.view.facelets.tag.faces.html.HtmlLibrary;
import org.apache.myfaces.view.facelets.tag.jstl.core.JstlCoreLibrary;
import org.apache.myfaces.view.facelets.tag.jstl.core.LegacyJstlCoreLibrary;
import org.apache.myfaces.view.facelets.tag.jstl.fn.JstlFnLibrary;
import org.apache.myfaces.view.facelets.tag.ui.LegacyUILibrary;
import org.apache.myfaces.view.facelets.tag.ui.UILibrary;

public class FaceletsCompilerSupport {
    private static final Logger log = Logger.getLogger(FaceletsCompilerSupport.class.getName());

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadLibraries(FacesContext context, Compiler compiler) {
        ExternalContext eContext = context.getExternalContext();
        MyfacesConfig config = MyfacesConfig.getCurrentInstance(context);
        compiler.addTagLibrary(new CoreLibrary());
        compiler.addTagLibrary(new HtmlLibrary());
        if (config.isStrictJsf2FaceletsCompatibility()) {
            compiler.addTagLibrary(new LegacyUILibrary());
            compiler.addTagLibrary(new LegacyJstlCoreLibrary());
            compiler.addTagLibrary(new LegacyJstlCoreLibrary("http://java.sun.com/jstl/core"));
        } else {
            compiler.addTagLibrary(new UILibrary());
            compiler.addTagLibrary(new JstlCoreLibrary());
            compiler.addTagLibrary(new JstlCoreLibrary("http://java.sun.com/jstl/core"));
        }
        compiler.addTagLibrary(new JstlFnLibrary());
        compiler.addTagLibrary(new CompositeLibrary());
        compiler.addTagLibrary(new CompositeResourceLibrary(context, "jakarta.faces.composite/"));
        compiler.addTagLibrary(new CompositeResourceLibrary(context, "http://xmlns.jcp.org/jsf/composite/"));
        compiler.addTagLibrary(new CompositeResourceLibrary(context, "http://java.sun.com/jsf/composite/"));
        compiler.addTagLibrary(new JsfLibrary());
        compiler.addTagLibrary(new PassThroughLibrary());
        RuntimeConfig runtimeConfig = RuntimeConfig.getCurrentInstance(eContext);
        if (!runtimeConfig.getComponentTagDeclarations().isEmpty()) {
            ComponentTagDeclarationLibrary componentTagDeclarationLibrary = new ComponentTagDeclarationLibrary();
            LoadComponentTagDeclarationFacesContextWrapper wrappedFacesContext = new LoadComponentTagDeclarationFacesContextWrapper(context);
            try {
                wrappedFacesContext.setWrapperAsCurrentFacesContext();
                UIViewRoot root = new UIViewRoot();
                root.setRenderKitId("HTML_BASIC");
                wrappedFacesContext.setViewRoot(new UIViewRoot());
                for (ComponentTagDeclaration declaration : runtimeConfig.getComponentTagDeclarations()) {
                    UIComponent component = context.getApplication().createComponent(declaration.getComponentType());
                    componentTagDeclarationLibrary.addComponent(declaration.getNamespace(), declaration.getTagName(), declaration.getComponentType(), component.getRendererType());
                }
            }
            finally {
                wrappedFacesContext.restoreCurrentFacesContext();
            }
            compiler.addTagLibrary(componentTagDeclarationLibrary);
        }
        List<FaceletTagLibrary> faceletTagLibraries = runtimeConfig.getFaceletTagLibraries();
        for (FaceletTagLibrary faceletTagLibrary : faceletTagLibraries) {
            TagLibrary tl = TagLibraryConfig.create(context, faceletTagLibrary);
            if (tl == null) continue;
            compiler.addTagLibrary(tl);
        }
    }

    public void loadDecorators(FacesContext context, Compiler compiler) {
        String param = WebConfigParamUtils.getStringInitParameter(context.getExternalContext(), "jakarta.faces.FACELETS_DECORATORS");
        if (param != null) {
            for (String decorator : param.split(";")) {
                try {
                    compiler.addTagDecorator((TagDecorator)ClassUtils.forName(decorator).newInstance());
                    if (!log.isLoggable(Level.FINE)) continue;
                    log.fine("Successfully loaded decorator: " + decorator);
                }
                catch (Exception e) {
                    log.log(Level.SEVERE, "Error Loading decorator: " + decorator, e);
                }
            }
        }
    }

    public void loadOptions(FacesContext context, Compiler compiler) {
        ExternalContext eContext = context.getExternalContext();
        compiler.setTrimmingComments(WebConfigParamUtils.getBooleanInitParameter(eContext, "jakarta.faces.FACELETS_SKIP_COMMENTS", false));
        compiler.setFaceletsProcessingConfigurations(RuntimeConfig.getCurrentInstance(context.getExternalContext()).getFaceletProcessingConfigurations());
    }

    private static class LoadComponentTagDeclarationFacesContextWrapper
    extends FacesContextWrapper {
        private FacesContext delegate;
        private UIViewRoot root;

        public LoadComponentTagDeclarationFacesContextWrapper(FacesContext delegate) {
            this.delegate = delegate;
        }

        @Override
        public UIViewRoot getViewRoot() {
            return this.root;
        }

        @Override
        public void setViewRoot(UIViewRoot root) {
            this.root = root;
        }

        @Override
        public FacesContext getWrapped() {
            return this.delegate;
        }

        void setWrapperAsCurrentFacesContext() {
            LoadComponentTagDeclarationFacesContextWrapper.setCurrentInstance(this);
        }

        void restoreCurrentFacesContext() {
            LoadComponentTagDeclarationFacesContextWrapper.setCurrentInstance(this.delegate);
        }
    }
}

