/*
 * Decompiled with CFR 0.152.
 */
package jakarta.faces.component.behavior;

import jakarta.faces.component.UIComponent;
import jakarta.faces.context.FacesContext;
import java.util.Collection;
import org.apache.myfaces.core.api.shared.lang.Assert;

public abstract class ClientBehaviorContext {
    public static final String BEHAVIOR_SOURCE_PARAM_NAME = "jakarta.faces.source";
    public static final String BEHAVIOR_EVENT_PARAM_NAME = "jakarta.faces.behavior.event";

    public static ClientBehaviorContext createClientBehaviorContext(FacesContext context, UIComponent component, String eventName, String sourceId, Collection<Parameter> parameters) {
        Assert.notNull(context, "context");
        Assert.notNull(component, "component");
        Assert.notNull(eventName, "eventName");
        return new ClientBehaviorContextImpl(context, component, eventName, sourceId, parameters);
    }

    public abstract UIComponent getComponent();

    public abstract String getEventName();

    public abstract FacesContext getFacesContext();

    public abstract Collection<Parameter> getParameters();

    public abstract String getSourceId();

    private static final class ClientBehaviorContextImpl
    extends ClientBehaviorContext {
        private FacesContext _facesContext;
        private UIComponent _component;
        private String _eventName;
        private String _sourceId;
        private Collection<Parameter> _parameters;

        public ClientBehaviorContextImpl(FacesContext context, UIComponent component, String eventName, String sourceId, Collection<Parameter> parameters) {
            this._facesContext = context;
            this._component = component;
            this._eventName = eventName;
            this._sourceId = sourceId;
            this._parameters = parameters;
        }

        @Override
        public UIComponent getComponent() {
            return this._component;
        }

        @Override
        public String getEventName() {
            return this._eventName;
        }

        @Override
        public FacesContext getFacesContext() {
            return this._facesContext;
        }

        @Override
        public Collection<Parameter> getParameters() {
            return this._parameters;
        }

        @Override
        public String getSourceId() {
            return this._sourceId;
        }
    }

    public static class Parameter {
        private String name;
        private Object value;

        public Parameter(String name, Object value) {
            Assert.notNull(name, "name");
            this.name = name;
            this.value = value;
        }

        public String getName() {
            return this.name;
        }

        public Object getValue() {
            return this.value;
        }
    }
}

