/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.extensions.validator.beanval.interceptor;

import java.lang.reflect.Method;
import java.util.List;
import javax.el.MethodExpression;
import javax.faces.component.ActionSource2;
import javax.faces.component.EditableValueHolder;
import javax.faces.component.UIComponent;
import javax.faces.component.behavior.AjaxBehavior;
import javax.faces.context.FacesContext;
import javax.faces.event.ActionEvent;
import javax.faces.event.AjaxBehaviorEvent;
import javax.faces.event.FacesEvent;
import org.apache.myfaces.extensions.validator.beanval.ExtValBeanValidationContext;
import org.apache.myfaces.extensions.validator.beanval.annotation.BeanValidation;
import org.apache.myfaces.extensions.validator.beanval.group.SkipValidation;
import org.apache.myfaces.extensions.validator.core.el.ELHelper;
import org.apache.myfaces.extensions.validator.core.el.ValueBindingExpression;
import org.apache.myfaces.extensions.validator.core.factory.ExtValAjaxBehavior;
import org.apache.myfaces.extensions.validator.core.interceptor.ViewRootInterceptor;
import org.apache.myfaces.extensions.validator.util.ExtValUtils;
import org.apache.myfaces.extensions.validator.util.ProxyUtils;
import org.apache.myfaces.extensions.validator.util.ReflectionUtils;

public class BeanValidationViewRootInterceptor
implements ViewRootInterceptor {
    public void afterQueueEvent(FacesEvent event) {
        UIComponent uiComponent = event.getComponent();
        if (event instanceof ActionEvent && uiComponent instanceof ActionSource2) {
            this.tryToProcessActionMethod((ActionSource2)event.getComponent());
        }
        if (event instanceof AjaxBehaviorEvent && uiComponent instanceof EditableValueHolder && ((AjaxBehaviorEvent)event).getBehavior() instanceof AjaxBehavior) {
            this.tryToProcessAjaxListener((AjaxBehavior)((AjaxBehaviorEvent)event).getBehavior());
        }
    }

    private void tryToProcessActionMethod(ActionSource2 commandComponent) {
        String actionString;
        MethodExpression actionExpression = commandComponent.getActionExpression();
        if (actionExpression == null) {
            return;
        }
        ELHelper elHelper = ExtValUtils.getELHelper();
        if (!elHelper.isELTermWellFormed((Object)(actionString = actionExpression.getExpressionString()))) {
            return;
        }
        ValueBindingExpression valueBindingExpression = new ValueBindingExpression(actionString);
        FacesContext facesContext = FacesContext.getCurrentInstance();
        if (!ExtValUtils.getELHelper().isELTermValid(facesContext, valueBindingExpression.getBaseExpression().getExpressionString())) {
            return;
        }
        this.processBypassValidation(facesContext, valueBindingExpression, elHelper, ActionEvent.class);
    }

    private void tryToProcessAjaxListener(AjaxBehavior ajaxBehavior) {
        if (!(ajaxBehavior instanceof ExtValAjaxBehavior)) {
            return;
        }
        List listenerExpressions = ((ExtValAjaxBehavior)ajaxBehavior).getListenerExpressions();
        ELHelper elHelper = ExtValUtils.getELHelper();
        for (MethodExpression listenerExpression : listenerExpressions) {
            String actionString = listenerExpression.getExpressionString();
            if (!elHelper.isELTermWellFormed((Object)actionString)) continue;
            ValueBindingExpression valueBindingExpression = new ValueBindingExpression(actionString);
            FacesContext facesContext = FacesContext.getCurrentInstance();
            if (!ExtValUtils.getELHelper().isELTermValid(facesContext, valueBindingExpression.getBaseExpression().getExpressionString())) continue;
            this.processBypassValidation(facesContext, valueBindingExpression, elHelper, AjaxBehaviorEvent.class);
        }
    }

    private void processBypassValidation(FacesContext facesContext, ValueBindingExpression valueBindingExpression, ELHelper elHelper, Class ... parameterTypes) {
        Method actionMethod;
        Object base = elHelper.getValueOfExpression(facesContext, valueBindingExpression.getBaseExpression());
        if (base == null) {
            return;
        }
        String methodName = valueBindingExpression.getProperty();
        if (methodName.contains("(")) {
            methodName = methodName.substring(0, methodName.indexOf("("));
        }
        if ((actionMethod = ReflectionUtils.tryToGetMethod((Class)ProxyUtils.getUnproxiedClass(base.getClass()), (String)methodName)) == null) {
            actionMethod = ReflectionUtils.tryToGetMethod((Class)ProxyUtils.getUnproxiedClass(base.getClass()), (String)methodName, (Class[])parameterTypes);
        }
        if (actionMethod == null) {
            return;
        }
        BeanValidation beanValidation = actionMethod.getAnnotation(BeanValidation.class);
        if (beanValidation == null) {
            return;
        }
        ExtValBeanValidationContext extValBeanValidationContext = ExtValBeanValidationContext.getCurrentInstance();
        String viewId = facesContext.getViewRoot().getViewId();
        for (String condition : beanValidation.conditions()) {
            if (!elHelper.isELTermWellFormed((Object)condition) || !elHelper.isELTermValid(facesContext, condition) || !Boolean.FALSE.equals(elHelper.getValueOfExpression(facesContext, new ValueBindingExpression(condition)))) continue;
            return;
        }
        boolean skippedValidation = false;
        for (Class currentGroupClass : beanValidation.useGroups()) {
            if (SkipValidation.class.isAssignableFrom(currentGroupClass)) {
                skippedValidation = true;
                break;
            }
            extValBeanValidationContext.addGroup(currentGroupClass, viewId, null);
        }
        for (Class currentGroupClass : beanValidation.restrictGroups()) {
            extValBeanValidationContext.restrictGroup(currentGroupClass, viewId, null);
        }
        if (skippedValidation) {
            extValBeanValidationContext.resetGroups(viewId);
            extValBeanValidationContext.addGroup(SkipValidation.class, viewId, null);
            extValBeanValidationContext.lockGroups(viewId);
        }
    }
}

