/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.extensions.validator.core.factory;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Logger;
import org.apache.myfaces.extensions.validator.core.CustomInformation;
import org.apache.myfaces.extensions.validator.core.ExtValContext;
import org.apache.myfaces.extensions.validator.core.ExtValCoreConfiguration;
import org.apache.myfaces.extensions.validator.core.el.DefaultELHelperFactory;
import org.apache.myfaces.extensions.validator.core.factory.FactoryFinder;
import org.apache.myfaces.extensions.validator.core.factory.FactoryNames;
import org.apache.myfaces.extensions.validator.core.metadata.extractor.DefaultComponentMetaDataExtractorFactory;
import org.apache.myfaces.extensions.validator.core.metadata.transformer.DefaultMetaDataTransformerFactory;
import org.apache.myfaces.extensions.validator.core.renderkit.DefaultRenderKitWrapperFactory;
import org.apache.myfaces.extensions.validator.core.storage.DefaultStorageManagerFactory;
import org.apache.myfaces.extensions.validator.core.validation.message.DefaultFacesMessageFactory;
import org.apache.myfaces.extensions.validator.core.validation.message.resolver.DefaultMessageResolverFactory;
import org.apache.myfaces.extensions.validator.core.validation.parameter.DefaultValidationParameterExtractorFactory;
import org.apache.myfaces.extensions.validator.core.validation.parameter.DefaultValidationParameterFactory;
import org.apache.myfaces.extensions.validator.core.validation.strategy.DefaultValidationStrategyFactory;
import org.apache.myfaces.extensions.validator.internal.Priority;
import org.apache.myfaces.extensions.validator.internal.ToDo;
import org.apache.myfaces.extensions.validator.internal.UsageCategory;
import org.apache.myfaces.extensions.validator.internal.UsageInformation;
import org.apache.myfaces.extensions.validator.util.ClassUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@UsageInformation(value={UsageCategory.INTERNAL})
public class DefaultFactoryFinder
implements FactoryFinder {
    protected final Logger logger = Logger.getLogger(this.getClass().getName());
    protected Map<FactoryNames, Object> factoryMap = new ConcurrentHashMap<FactoryNames, Object>();
    private static FactoryFinder factoryFinder = new DefaultFactoryFinder();

    protected DefaultFactoryFinder() {
        this.logger.fine(this.getClass().getName() + " instantiated");
    }

    public static FactoryFinder getInstance() {
        return factoryFinder;
    }

    @Override
    public final <T> T getFactory(FactoryNames factoryName, Class<T> targetClass) {
        if (!this.factoryMap.containsKey((Object)factoryName)) {
            this.initFactory(factoryName);
        }
        return (T)this.factoryMap.get((Object)factoryName);
    }

    private void initFactory(FactoryNames factoryName) {
        Object factory = null;
        switch (factoryName) {
            case COMPONENT_META_DATA_EXTRACTOR_FACTORY: {
                factory = this.createComponentMetaDataExtractorFactory();
                break;
            }
            case VALIDATION_STRATEGY_FACTORY: {
                factory = this.createValidationStrategyFactory();
                break;
            }
            case MESSAGE_RESOLVER_FACTORY: {
                factory = this.createMessageResolverFactory();
                break;
            }
            case META_DATA_TRANSFORMER_FACTORY: {
                factory = this.createMetaDataTransformerFactory();
                break;
            }
            case RENDERKIT_WRAPPER_FACTORY: {
                factory = this.createRenderKitWrapperFactory();
                break;
            }
            case EL_HELPER_FACTORY: {
                factory = this.createELHelperFactory();
                break;
            }
            case FACES_MESSAGE_FACTORY: {
                factory = this.createFacesMessageFactory();
                break;
            }
            case VALIDATION_PARAMETER_EXTRACTOR_FACTORY: {
                factory = this.createValidationParameterExtractorFactory();
                break;
            }
            case STORAGE_MANAGER_FACTORY: {
                factory = this.createStorageManagerFactory();
                break;
            }
            case VALIDATION_PARAMETER_FACTORY: {
                factory = this.createValidationParameterFactory();
                break;
            }
        }
        if (factory == null) {
            throw new IllegalStateException("not possible to create factory " + (Object)((Object)factoryName));
        }
        this.factoryMap.put(factoryName, factory);
    }

    @ToDo(value=Priority.MEDIUM, description="add global property extension point")
    protected Object createComponentMetaDataExtractorFactory() {
        String className;
        Object factory = null;
        ArrayList<String> metaDataExtractorFactoryClassNames = new ArrayList<String>();
        metaDataExtractorFactoryClassNames.add(this.getCoreConfig().customComponentMetaDataExtractorFactoryClassName());
        metaDataExtractorFactoryClassNames.add(ExtValContext.getContext().getInformationProviderBean().get(CustomInformation.COMPONENT_META_DATA_EXTRACTOR_FACTORY));
        metaDataExtractorFactoryClassNames.add(DefaultComponentMetaDataExtractorFactory.class.getName());
        Iterator i$ = metaDataExtractorFactoryClassNames.iterator();
        while (i$.hasNext() && (factory = ClassUtils.tryToInstantiateClassForName(className = (String)i$.next())) == null) {
        }
        return factory;
    }

    @ToDo(value=Priority.MEDIUM, description="add global property extension point")
    protected Object createValidationStrategyFactory() {
        String className;
        Object factory = null;
        ArrayList<String> validationStrategyFactoryClassNames = new ArrayList<String>();
        validationStrategyFactoryClassNames.add(this.getCoreConfig().customValidationStrategyFactoryClassName());
        validationStrategyFactoryClassNames.add(ExtValContext.getContext().getInformationProviderBean().get(CustomInformation.VALIDATION_STRATEGY_FACTORY));
        validationStrategyFactoryClassNames.add(DefaultValidationStrategyFactory.class.getName());
        Iterator i$ = validationStrategyFactoryClassNames.iterator();
        while (i$.hasNext() && (factory = ClassUtils.tryToInstantiateClassForName(className = (String)i$.next())) == null) {
        }
        return factory;
    }

    @ToDo(value=Priority.MEDIUM, description="add global property extension point")
    protected Object createMessageResolverFactory() {
        String className;
        Object factory = null;
        ArrayList<String> messageResolverFactoryClassNames = new ArrayList<String>();
        messageResolverFactoryClassNames.add(this.getCoreConfig().customMessageResolverFactoryClassName());
        messageResolverFactoryClassNames.add(ExtValContext.getContext().getInformationProviderBean().get(CustomInformation.MESSAGE_RESOLVER_FACTORY));
        messageResolverFactoryClassNames.add(DefaultMessageResolverFactory.class.getName());
        Iterator i$ = messageResolverFactoryClassNames.iterator();
        while (i$.hasNext() && (factory = ClassUtils.tryToInstantiateClassForName(className = (String)i$.next())) == null) {
        }
        return factory;
    }

    @ToDo(value=Priority.MEDIUM, description="add global property extension point")
    protected Object createMetaDataTransformerFactory() {
        String className;
        Object factory = null;
        ArrayList<String> metaDataTransformerFactoryClassNames = new ArrayList<String>();
        metaDataTransformerFactoryClassNames.add(this.getCoreConfig().customMetaDataTransformerFactoryClassName());
        metaDataTransformerFactoryClassNames.add(ExtValContext.getContext().getInformationProviderBean().get(CustomInformation.META_DATA_TRANSFORMER_FACTORY));
        metaDataTransformerFactoryClassNames.add(DefaultMetaDataTransformerFactory.class.getName());
        Iterator i$ = metaDataTransformerFactoryClassNames.iterator();
        while (i$.hasNext() && (factory = ClassUtils.tryToInstantiateClassForName(className = (String)i$.next())) == null) {
        }
        return factory;
    }

    protected Object createRenderKitWrapperFactory() {
        return new DefaultRenderKitWrapperFactory();
    }

    @ToDo(value=Priority.MEDIUM, description="add global property extension point")
    protected Object createFacesMessageFactory() {
        String className;
        Object factory = null;
        ArrayList<String> facesMessageFactoryClassNames = new ArrayList<String>();
        facesMessageFactoryClassNames.add(this.getCoreConfig().customFacesMessageFactoryClassName());
        facesMessageFactoryClassNames.add(ExtValContext.getContext().getInformationProviderBean().get(CustomInformation.FACES_MESSAGE_FACTORY));
        Object target = ExtValContext.getContext().getGlobalProperty(CustomInformation.FACES_MESSAGE_FACTORY.name());
        if (target != null && target instanceof String) {
            facesMessageFactoryClassNames.add((String)target);
        }
        facesMessageFactoryClassNames.add(DefaultFacesMessageFactory.class.getName());
        Iterator i$ = facesMessageFactoryClassNames.iterator();
        while (i$.hasNext() && (factory = ClassUtils.tryToInstantiateClassForName(className = (String)i$.next())) == null) {
        }
        return factory;
    }

    protected Object createELHelperFactory() {
        return new DefaultELHelperFactory();
    }

    @ToDo(value=Priority.MEDIUM, description="add global property extension point")
    protected Object createValidationParameterExtractorFactory() {
        String className;
        Object factory = null;
        ArrayList<String> validationParameterExtractorFactoryClassNames = new ArrayList<String>();
        validationParameterExtractorFactoryClassNames.add(this.getCoreConfig().customValidationParameterExtractorFactoryClassName());
        validationParameterExtractorFactoryClassNames.add(ExtValContext.getContext().getInformationProviderBean().get(CustomInformation.VALIDATION_PARAMETER_EXTRACTOR_FACTORY));
        validationParameterExtractorFactoryClassNames.add(DefaultValidationParameterExtractorFactory.class.getName());
        Iterator i$ = validationParameterExtractorFactoryClassNames.iterator();
        while (i$.hasNext() && (factory = ClassUtils.tryToInstantiateClassForName(className = (String)i$.next())) == null) {
        }
        return factory;
    }

    protected Object createStorageManagerFactory() {
        String className;
        Object factory = null;
        ArrayList<String> storageManagerFactoryClassNames = new ArrayList<String>();
        storageManagerFactoryClassNames.add(this.getCoreConfig().customStorageManagerFactoryClassName());
        storageManagerFactoryClassNames.add(ExtValContext.getContext().getInformationProviderBean().get(CustomInformation.STORAGE_MANAGER_FACTORY));
        storageManagerFactoryClassNames.add(DefaultStorageManagerFactory.class.getName());
        Iterator i$ = storageManagerFactoryClassNames.iterator();
        while (i$.hasNext() && (factory = ClassUtils.tryToInstantiateClassForName(className = (String)i$.next())) == null) {
        }
        return factory;
    }

    private Object createValidationParameterFactory() {
        String className;
        Object factory = null;
        ArrayList<String> validationParameterFactoryClassNames = new ArrayList<String>();
        validationParameterFactoryClassNames.add(this.getCoreConfig().customValidationParameterFactoryClassName());
        validationParameterFactoryClassNames.add(ExtValContext.getContext().getInformationProviderBean().get(CustomInformation.VALIDATION_PARAMETER_FACTORY));
        validationParameterFactoryClassNames.add(DefaultValidationParameterFactory.class.getName());
        Iterator i$ = validationParameterFactoryClassNames.iterator();
        while (i$.hasNext() && (factory = ClassUtils.tryToInstantiateClassForName(className = (String)i$.next())) == null) {
        }
        return factory;
    }

    private ExtValCoreConfiguration getCoreConfig() {
        return ExtValCoreConfiguration.get();
    }
}

