/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.extensions.validator.util;

import java.util.Iterator;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import javax.faces.FactoryFinder;
import javax.faces.context.FacesContext;
import javax.faces.event.PhaseId;
import javax.faces.event.PhaseListener;
import javax.faces.lifecycle.Lifecycle;
import javax.faces.lifecycle.LifecycleFactory;
import org.apache.myfaces.extensions.validator.core.storage.FacesInformationStorage;
import org.apache.myfaces.extensions.validator.internal.UsageCategory;
import org.apache.myfaces.extensions.validator.internal.UsageInformation;
import org.apache.myfaces.extensions.validator.util.ExtValUtils;

@UsageInformation(value={UsageCategory.INTERNAL})
public class JsfUtils {
    public static void deregisterPhaseListener(PhaseListener phaseListener) {
        LifecycleFactory lifecycleFactory = (LifecycleFactory)FactoryFinder.getFactory((String)"javax.faces.lifecycle.LifecycleFactory");
        Iterator lifecycleIds = lifecycleFactory.getLifecycleIds();
        while (lifecycleIds.hasNext()) {
            String currentId = (String)lifecycleIds.next();
            Lifecycle currentLifecycle = lifecycleFactory.getLifecycle(currentId);
            currentLifecycle.removePhaseListener(phaseListener);
        }
    }

    public static void registerPhaseListener(PhaseListener phaseListener) {
        LifecycleFactory lifecycleFactory = (LifecycleFactory)FactoryFinder.getFactory((String)"javax.faces.lifecycle.LifecycleFactory");
        Iterator lifecycleIds = lifecycleFactory.getLifecycleIds();
        while (lifecycleIds.hasNext()) {
            String currentId = (String)lifecycleIds.next();
            Lifecycle currentLifecycle = lifecycleFactory.getLifecycle(currentId);
            currentLifecycle.addPhaseListener(phaseListener);
        }
    }

    public static ResourceBundle getDefaultFacesMessageBundle() {
        FacesContext facesContext = FacesContext.getCurrentInstance();
        return ResourceBundle.getBundle("javax.faces.Messages", facesContext.getViewRoot().getLocale());
    }

    public static ResourceBundle getCustomFacesMessageBundle() {
        FacesContext facesContext = FacesContext.getCurrentInstance();
        String bundleName = facesContext.getApplication().getMessageBundle();
        if (bundleName == null) {
            return null;
        }
        return ResourceBundle.getBundle(bundleName, facesContext.getViewRoot().getLocale());
    }

    public static String getMessageFromApplicationMessageBundle(String messageKey) {
        ResourceBundle customResourceBundle = JsfUtils.getCustomFacesMessageBundle();
        try {
            if (customResourceBundle != null) {
                return customResourceBundle.getString(messageKey);
            }
        }
        catch (MissingResourceException missingResourceException) {
            // empty catch block
        }
        return JsfUtils.getDefaultFacesMessageBundle().getString(messageKey);
    }

    public static boolean isRenderResponsePhase() {
        return PhaseId.RENDER_RESPONSE.equals(JsfUtils.getFacesInformationStorage().getCurrentPhaseId());
    }

    public static PhaseId getCurrentPhaseId() {
        return JsfUtils.getFacesInformationStorage().getCurrentPhaseId();
    }

    public static boolean isApplicationInitialized() {
        FacesContext facesContext = FacesContext.getCurrentInstance();
        return facesContext != null && (facesContext.getClass().getName().startsWith("org.apache.myfaces") || facesContext.getExternalContext().getRequestMap() != null && !facesContext.getExternalContext().getRequestMap().isEmpty());
    }

    private static FacesInformationStorage getFacesInformationStorage() {
        return ExtValUtils.getStorage(FacesInformationStorage.class, FacesInformationStorage.class.getName());
    }
}

