/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.server.core.uri.parser;

import java.util.Collection;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.olingo.commons.api.edm.Edm;
import org.apache.olingo.commons.api.edm.EdmElement;
import org.apache.olingo.commons.api.edm.EdmFunction;
import org.apache.olingo.commons.api.edm.EdmNavigationProperty;
import org.apache.olingo.commons.api.edm.EdmParameter;
import org.apache.olingo.commons.api.edm.EdmPrimitiveTypeKind;
import org.apache.olingo.commons.api.edm.EdmProperty;
import org.apache.olingo.commons.api.edm.EdmReturnType;
import org.apache.olingo.commons.api.edm.EdmStructuredType;
import org.apache.olingo.commons.api.edm.EdmType;
import org.apache.olingo.commons.api.edm.FullQualifiedName;
import org.apache.olingo.commons.api.edm.constants.EdmTypeKind;
import org.apache.olingo.server.api.OData;
import org.apache.olingo.server.api.uri.UriInfo;
import org.apache.olingo.server.api.uri.UriInfoResource;
import org.apache.olingo.server.api.uri.UriParameter;
import org.apache.olingo.server.api.uri.UriResource;
import org.apache.olingo.server.api.uri.UriResourcePartTyped;
import org.apache.olingo.server.api.uri.queryoption.AliasQueryOption;
import org.apache.olingo.server.api.uri.queryoption.ApplyItem;
import org.apache.olingo.server.api.uri.queryoption.ApplyOption;
import org.apache.olingo.server.api.uri.queryoption.ExpandItem;
import org.apache.olingo.server.api.uri.queryoption.ExpandOption;
import org.apache.olingo.server.api.uri.queryoption.FilterOption;
import org.apache.olingo.server.api.uri.queryoption.OrderByOption;
import org.apache.olingo.server.api.uri.queryoption.SearchOption;
import org.apache.olingo.server.api.uri.queryoption.SystemQueryOption;
import org.apache.olingo.server.api.uri.queryoption.SystemQueryOptionKind;
import org.apache.olingo.server.api.uri.queryoption.apply.Aggregate;
import org.apache.olingo.server.api.uri.queryoption.apply.AggregateExpression;
import org.apache.olingo.server.api.uri.queryoption.apply.BottomTop;
import org.apache.olingo.server.api.uri.queryoption.apply.Compute;
import org.apache.olingo.server.api.uri.queryoption.apply.Concat;
import org.apache.olingo.server.api.uri.queryoption.apply.CustomFunction;
import org.apache.olingo.server.api.uri.queryoption.apply.GroupBy;
import org.apache.olingo.server.api.uri.queryoption.apply.GroupByItem;
import org.apache.olingo.server.api.uri.queryoption.expression.Expression;
import org.apache.olingo.server.core.uri.UriInfoImpl;
import org.apache.olingo.server.core.uri.UriResourceComplexPropertyImpl;
import org.apache.olingo.server.core.uri.UriResourceCountImpl;
import org.apache.olingo.server.core.uri.UriResourceNavigationPropertyImpl;
import org.apache.olingo.server.core.uri.UriResourcePrimitivePropertyImpl;
import org.apache.olingo.server.core.uri.UriResourceStartingTypeFilterImpl;
import org.apache.olingo.server.core.uri.parser.ExpandParser;
import org.apache.olingo.server.core.uri.parser.ExpressionParser;
import org.apache.olingo.server.core.uri.parser.FilterParser;
import org.apache.olingo.server.core.uri.parser.OrderByParser;
import org.apache.olingo.server.core.uri.parser.ParserHelper;
import org.apache.olingo.server.core.uri.parser.SearchParser;
import org.apache.olingo.server.core.uri.parser.UriParserException;
import org.apache.olingo.server.core.uri.parser.UriParserSemanticException;
import org.apache.olingo.server.core.uri.parser.UriParserSyntaxException;
import org.apache.olingo.server.core.uri.parser.UriTokenizer;
import org.apache.olingo.server.core.uri.queryoption.ApplyOptionImpl;
import org.apache.olingo.server.core.uri.queryoption.ExpandItemImpl;
import org.apache.olingo.server.core.uri.queryoption.ExpandOptionImpl;
import org.apache.olingo.server.core.uri.queryoption.SkipOptionImpl;
import org.apache.olingo.server.core.uri.queryoption.TopOptionImpl;
import org.apache.olingo.server.core.uri.queryoption.apply.AggregateExpressionImpl;
import org.apache.olingo.server.core.uri.queryoption.apply.AggregateImpl;
import org.apache.olingo.server.core.uri.queryoption.apply.BottomTopImpl;
import org.apache.olingo.server.core.uri.queryoption.apply.ComputeExpressionImpl;
import org.apache.olingo.server.core.uri.queryoption.apply.ComputeImpl;
import org.apache.olingo.server.core.uri.queryoption.apply.ConcatImpl;
import org.apache.olingo.server.core.uri.queryoption.apply.CustomFunctionImpl;
import org.apache.olingo.server.core.uri.queryoption.apply.DynamicProperty;
import org.apache.olingo.server.core.uri.queryoption.apply.DynamicStructuredType;
import org.apache.olingo.server.core.uri.queryoption.apply.ExpandImpl;
import org.apache.olingo.server.core.uri.queryoption.apply.FilterImpl;
import org.apache.olingo.server.core.uri.queryoption.apply.GroupByImpl;
import org.apache.olingo.server.core.uri.queryoption.apply.GroupByItemImpl;
import org.apache.olingo.server.core.uri.queryoption.apply.IdentityImpl;
import org.apache.olingo.server.core.uri.queryoption.apply.OrderByImpl;
import org.apache.olingo.server.core.uri.queryoption.apply.SearchImpl;
import org.apache.olingo.server.core.uri.queryoption.apply.SkipImpl;
import org.apache.olingo.server.core.uri.queryoption.apply.TopImpl;
import org.apache.olingo.server.core.uri.queryoption.expression.MemberImpl;
import org.apache.olingo.server.core.uri.validator.UriValidationException;

public class ApplyParser {
    private static final Map<UriTokenizer.TokenKind, AggregateExpression.StandardMethod> TOKEN_KIND_TO_STANDARD_METHOD;
    private static final Map<UriTokenizer.TokenKind, BottomTop.Method> TOKEN_KIND_TO_BOTTOM_TOP_METHOD;
    private final Edm edm;
    private final OData odata;
    private UriTokenizer tokenizer;
    private Collection<String> crossjoinEntitySetNames;
    private Map<String, AliasQueryOption> aliases;

    public ApplyParser(Edm edm, OData odata) {
        this.edm = edm;
        this.odata = odata;
    }

    public ApplyOption parse(UriTokenizer tokenizer, EdmStructuredType referencedType, Collection<String> crossjoinEntitySetNames, Map<String, AliasQueryOption> aliases) throws UriParserException, UriValidationException {
        this.tokenizer = tokenizer;
        this.crossjoinEntitySetNames = crossjoinEntitySetNames;
        this.aliases = aliases;
        return this.parseApply(referencedType);
    }

    private ApplyOption parseApply(EdmStructuredType referencedType) throws UriParserException, UriValidationException {
        ApplyOptionImpl option = new ApplyOptionImpl();
        option.setEdmStructuredType(referencedType);
        do {
            option.add(this.parseTrafo(referencedType));
        } while (this.tokenizer.next(UriTokenizer.TokenKind.SLASH));
        return option;
    }

    private ApplyItem parseTrafo(EdmStructuredType referencedType) throws UriParserException, UriValidationException {
        if (this.tokenizer.next(UriTokenizer.TokenKind.AggregateTrafo)) {
            return this.parseAggregateTrafo(referencedType);
        }
        if (this.tokenizer.next(UriTokenizer.TokenKind.IDENTITY)) {
            return new IdentityImpl();
        }
        if (this.tokenizer.next(UriTokenizer.TokenKind.ComputeTrafo)) {
            return this.parseComputeTrafo(referencedType);
        }
        if (this.tokenizer.next(UriTokenizer.TokenKind.ConcatMethod)) {
            return this.parseConcatTrafo(referencedType);
        }
        if (this.tokenizer.next(UriTokenizer.TokenKind.ExpandTrafo)) {
            return new ExpandImpl().setExpandOption(this.parseExpandTrafo(referencedType));
        }
        if (this.tokenizer.next(UriTokenizer.TokenKind.FilterTrafo)) {
            FilterOption filterOption = new FilterParser(this.edm, this.odata).parse(this.tokenizer, (EdmType)referencedType, this.crossjoinEntitySetNames, this.aliases);
            ParserHelper.requireNext(this.tokenizer, UriTokenizer.TokenKind.CLOSE);
            return new FilterImpl().setFilterOption(filterOption);
        }
        if (this.tokenizer.next(UriTokenizer.TokenKind.GroupByTrafo)) {
            return this.parseGroupByTrafo(referencedType);
        }
        if (this.tokenizer.next(UriTokenizer.TokenKind.SearchTrafo)) {
            SearchOption searchOption = new SearchParser().parse(this.tokenizer);
            ParserHelper.requireNext(this.tokenizer, UriTokenizer.TokenKind.CLOSE);
            return new SearchImpl().setSearchOption(searchOption);
        }
        if (this.tokenizer.next(UriTokenizer.TokenKind.OrderByTrafo)) {
            OrderByOption orderByOption = new OrderByParser(this.edm, this.odata).parse(this.tokenizer, referencedType, this.crossjoinEntitySetNames, this.aliases);
            ParserHelper.requireNext(this.tokenizer, UriTokenizer.TokenKind.CLOSE);
            return new OrderByImpl().setOrderByOption(orderByOption);
        }
        if (this.tokenizer.next(UriTokenizer.TokenKind.TopTrafo)) {
            ParserHelper.requireNext(this.tokenizer, UriTokenizer.TokenKind.IntegerValue);
            int value = ParserHelper.parseNonNegativeInteger(SystemQueryOptionKind.TOP.toString(), this.tokenizer.getText(), true);
            TopOptionImpl topOption = new TopOptionImpl();
            topOption.setText(this.tokenizer.getText());
            topOption.setValue(value);
            ParserHelper.requireNext(this.tokenizer, UriTokenizer.TokenKind.CLOSE);
            return new TopImpl().setTopOption(topOption);
        }
        if (this.tokenizer.next(UriTokenizer.TokenKind.SkipTrafo)) {
            ParserHelper.requireNext(this.tokenizer, UriTokenizer.TokenKind.IntegerValue);
            int value = ParserHelper.parseNonNegativeInteger(SystemQueryOptionKind.SKIP.toString(), this.tokenizer.getText(), true);
            SkipOptionImpl skipOption = new SkipOptionImpl();
            skipOption.setText(this.tokenizer.getText());
            skipOption.setValue(value);
            ParserHelper.requireNext(this.tokenizer, UriTokenizer.TokenKind.CLOSE);
            return new SkipImpl().setSkipOption(skipOption);
        }
        if (this.tokenizer.next(UriTokenizer.TokenKind.QualifiedName)) {
            return this.parseCustomFunction(new FullQualifiedName(this.tokenizer.getText()), referencedType);
        }
        UriTokenizer.TokenKind kind = ParserHelper.next(this.tokenizer, UriTokenizer.TokenKind.BottomCountTrafo, UriTokenizer.TokenKind.BottomPercentTrafo, UriTokenizer.TokenKind.BottomSumTrafo, UriTokenizer.TokenKind.TopCountTrafo, UriTokenizer.TokenKind.TopPercentTrafo, UriTokenizer.TokenKind.TopSumTrafo);
        if (kind == null) {
            throw new UriParserSyntaxException("Invalid apply expression syntax.", UriParserSyntaxException.MessageKeys.SYNTAX, new String[0]);
        }
        return this.parseBottomTop(kind, referencedType);
    }

    private Aggregate parseAggregateTrafo(EdmStructuredType referencedType) throws UriParserException, UriValidationException {
        AggregateImpl aggregate = new AggregateImpl();
        HashSet<String> dynamicProps = new HashSet<String>();
        do {
            AggregateExpression aggregateExpr = this.parseAggregateExpr(referencedType, dynamicProps, Requirement.REQUIRED);
            aggregate.addExpression(aggregateExpr);
            dynamicProps.addAll(aggregateExpr.getDynamicProperties());
        } while (this.tokenizer.next(UriTokenizer.TokenKind.COMMA));
        dynamicProps.forEach(dp -> this.addPropertyToRefType(referencedType, (String)dp));
        ParserHelper.requireNext(this.tokenizer, UriTokenizer.TokenKind.CLOSE);
        return aggregate;
    }

    private void addPropertyToRefType(EdmStructuredType referencedType, String alias) {
        ((DynamicStructuredType)referencedType).addProperty(this.createDynamicProperty(alias, (EdmType)this.odata.createPrimitiveTypeInstance(EdmPrimitiveTypeKind.Decimal)));
    }

    public AggregateExpression parseAggregateMethodCallExpr(UriTokenizer tokenizer, EdmStructuredType referringType) throws UriParserException, UriValidationException {
        this.tokenizer = tokenizer;
        return this.parseAggregateExpr(referringType, Collections.emptySet(), Requirement.FORBIDDEN);
    }

    private AggregateExpression parseAggregateExpr(EdmStructuredType referencedType, Set<String> dynamicProps, Requirement aliasRequired) throws UriParserException, UriValidationException {
        AggregateExpressionImpl aggregateExpression = new AggregateExpressionImpl();
        this.tokenizer.saveState();
        UriInfoImpl uriInfo = new UriInfoImpl();
        String identifierLeft = this.parsePathPrefix(uriInfo, referencedType);
        if (identifierLeft != null) {
            this.customAggregate(referencedType, aggregateExpression, uriInfo);
        } else if (this.tokenizer.next(UriTokenizer.TokenKind.OPEN)) {
            UriResource lastResourcePart = uriInfo.getLastResourcePart();
            if (lastResourcePart == null) {
                throw new UriParserSyntaxException("Invalid 'aggregateExpr' syntax.", UriParserSyntaxException.MessageKeys.SYNTAX, new String[0]);
            }
            aggregateExpression.setPath(uriInfo);
            DynamicStructuredType inlineType = new DynamicStructuredType((EdmStructuredType)ParserHelper.getTypeInformation((UriResourcePartTyped)lastResourcePart));
            aggregateExpression.setInlineAggregateExpression(this.parseAggregateExpr(inlineType, dynamicProps, aliasRequired));
            ParserHelper.requireNext(this.tokenizer, UriTokenizer.TokenKind.CLOSE);
        } else if (this.tokenizer.next(UriTokenizer.TokenKind.COUNT)) {
            uriInfo.addResourcePart(new UriResourceCountImpl());
            aggregateExpression.setPath(uriInfo);
            String alias = this.parseAsAlias(referencedType, dynamicProps, aliasRequired);
            if (alias != null) {
                aggregateExpression.setAlias(alias);
                aggregateExpression.addDynamicProperty(alias);
            }
        } else {
            this.tokenizer.returnToSavedState();
            Expression expression = new ExpressionParser(this.edm, this.odata).parse(this.tokenizer, (EdmType)referencedType, this.crossjoinEntitySetNames, this.aliases);
            aggregateExpression.setExpression(expression);
            this.parseAggregateWith(aggregateExpression);
            if (aggregateExpression.getStandardMethod() == null && aggregateExpression.getCustomMethod() == null) {
                if (this.tokenizer.next(UriTokenizer.TokenKind.AsOperator)) {
                    throw new UriParserSyntaxException("Invalid 'aggregateExpr' syntax.", UriParserSyntaxException.MessageKeys.SYNTAX, new String[0]);
                }
                this.customAggregateNamedAsProperty(referencedType, aggregateExpression, uriInfo);
                return aggregateExpression;
            }
            String alias = this.parseAsAlias(referencedType, dynamicProps, aliasRequired);
            if (alias != null) {
                aggregateExpression.setAlias(alias);
                aggregateExpression.addDynamicProperty(alias);
            }
            this.parseAggregateFrom(aggregateExpression, referencedType);
        }
        return aggregateExpression;
    }

    private void customAggregate(EdmStructuredType referencedType, AggregateExpressionImpl aggregateExpression, UriInfoImpl uriInfo) throws UriParserException {
        String customAggregate = this.tokenizer.getText();
        uriInfo.addResourcePart(new UriResourcePrimitivePropertyImpl(this.createDynamicProperty(customAggregate, null)));
        aggregateExpression.setPath(uriInfo);
        String alias = this.parseAsAlias(referencedType, aggregateExpression.getDynamicProperties(), Requirement.OPTIONAL);
        if (alias != null) {
            aggregateExpression.setAlias(alias);
            aggregateExpression.addDynamicProperty(alias);
        }
        this.parseAggregateFrom(aggregateExpression, referencedType);
    }

    private void customAggregateNamedAsProperty(EdmStructuredType referencedType, AggregateExpressionImpl aggregateExpression, UriInfoImpl uriInfo) throws UriParserException {
        UriResource lastResourcePart = uriInfo.getLastResourcePart();
        String alias = lastResourcePart.getSegmentValue();
        EdmType edmType = ParserHelper.getTypeInformation((UriResourcePartTyped)lastResourcePart);
        aggregateExpression.setPath(uriInfo);
        aggregateExpression.setAlias(alias);
        aggregateExpression.setExpression(null);
        ((DynamicStructuredType)referencedType).addProperty(this.createDynamicProperty(alias, edmType));
    }

    private void parseAggregateWith(AggregateExpressionImpl aggregateExpression) throws UriParserException {
        if (this.tokenizer.next(UriTokenizer.TokenKind.WithOperator)) {
            UriTokenizer.TokenKind kind = ParserHelper.next(this.tokenizer, UriTokenizer.TokenKind.SUM, UriTokenizer.TokenKind.MIN, UriTokenizer.TokenKind.MAX, UriTokenizer.TokenKind.AVERAGE, UriTokenizer.TokenKind.COUNTDISTINCT, UriTokenizer.TokenKind.QualifiedName);
            if (kind == null) {
                throw new UriParserSyntaxException("Invalid 'with' syntax.", UriParserSyntaxException.MessageKeys.SYNTAX, new String[0]);
            }
            if (kind == UriTokenizer.TokenKind.QualifiedName) {
                aggregateExpression.setCustomMethod(new FullQualifiedName(this.tokenizer.getText()));
            } else {
                aggregateExpression.setStandardMethod(TOKEN_KIND_TO_STANDARD_METHOD.get((Object)kind));
            }
        }
    }

    private EdmType getTypeForAggregateMethod(AggregateExpression.StandardMethod method, EdmType type) {
        if (method == AggregateExpression.StandardMethod.SUM || method == AggregateExpression.StandardMethod.AVERAGE || method == AggregateExpression.StandardMethod.COUNT_DISTINCT) {
            return this.odata.createPrimitiveTypeInstance(EdmPrimitiveTypeKind.Decimal);
        }
        if (method == AggregateExpression.StandardMethod.MIN || method == AggregateExpression.StandardMethod.MAX) {
            return type;
        }
        return null;
    }

    private String parseAsAlias(EdmStructuredType referencedType, Set<String> dynamicProps, Requirement requirement) throws UriParserException {
        if (this.tokenizer.next(UriTokenizer.TokenKind.AsOperator)) {
            if (requirement == Requirement.FORBIDDEN) {
                throw new UriParserSyntaxException("Unexpected as alias found.", UriParserSyntaxException.MessageKeys.SYNTAX, new String[0]);
            }
            ParserHelper.requireNext(this.tokenizer, UriTokenizer.TokenKind.ODataIdentifier);
            String name = this.tokenizer.getText();
            if (((DynamicStructuredType)referencedType).hasStaticProperty(name) || dynamicProps.contains(name)) {
                throw new UriParserSemanticException("Alias '" + name + "' is already a property.", UriParserSemanticException.MessageKeys.IS_PROPERTY, name);
            }
            return name;
        }
        if (requirement == Requirement.REQUIRED) {
            throw new UriParserSyntaxException("Expected as alias not found.", UriParserSyntaxException.MessageKeys.SYNTAX, new String[0]);
        }
        return null;
    }

    private void parseAggregateFrom(AggregateExpressionImpl aggregateExpression, EdmStructuredType referencedType) throws UriParserException {
        while (this.tokenizer.next(UriTokenizer.TokenKind.FromOperator)) {
            AggregateExpressionImpl from = new AggregateExpressionImpl();
            from.setExpression((Expression)new MemberImpl((UriInfoResource)this.parseGroupingProperty(referencedType), (EdmType)referencedType));
            this.parseAggregateWith(from);
            aggregateExpression.addFrom(from);
        }
    }

    private DynamicProperty createDynamicProperty(String name, EdmType type) {
        return name == null ? null : new DynamicProperty(name, type);
    }

    private Compute parseComputeTrafo(EdmStructuredType referencedType) throws UriParserException, UriValidationException {
        ComputeImpl compute = new ComputeImpl();
        do {
            Expression expression;
            EdmType expressionType;
            if ((expressionType = ExpressionParser.getType(expression = new ExpressionParser(this.edm, this.odata).parse(this.tokenizer, (EdmType)referencedType, this.crossjoinEntitySetNames, this.aliases))).getKind() != EdmTypeKind.PRIMITIVE) {
                throw new UriParserSemanticException("Compute expressions must return primitive values.", UriParserSemanticException.MessageKeys.ONLY_FOR_PRIMITIVE_TYPES, "compute");
            }
            String alias = this.parseAsAlias(referencedType, Collections.emptySet(), Requirement.REQUIRED);
            ((DynamicStructuredType)referencedType).addProperty(this.createDynamicProperty(alias, expressionType));
            compute.addExpression(new ComputeExpressionImpl().setExpression(expression).setAlias(alias));
        } while (this.tokenizer.next(UriTokenizer.TokenKind.COMMA));
        ParserHelper.requireNext(this.tokenizer, UriTokenizer.TokenKind.CLOSE);
        return compute;
    }

    private Concat parseConcatTrafo(EdmStructuredType referencedType) throws UriParserException, UriValidationException {
        ConcatImpl concat = new ConcatImpl();
        concat.addApplyOption(this.parseApply(referencedType));
        ParserHelper.requireNext(this.tokenizer, UriTokenizer.TokenKind.COMMA);
        do {
            concat.addApplyOption(this.parseApply(referencedType));
        } while (this.tokenizer.next(UriTokenizer.TokenKind.COMMA));
        ParserHelper.requireNext(this.tokenizer, UriTokenizer.TokenKind.CLOSE);
        return concat;
    }

    private ExpandOption parseExpandTrafo(EdmStructuredType referencedType) throws UriParserException, UriValidationException {
        ExpandItemImpl item = new ExpandItemImpl();
        item.setResourcePath((UriInfoResource)ExpandParser.parseExpandPath(this.tokenizer, this.edm, referencedType, item));
        EdmType type = ParserHelper.getTypeInformation((UriResourcePartTyped)((UriInfoImpl)item.getResourcePath()).getLastResourcePart());
        if (this.tokenizer.next(UriTokenizer.TokenKind.COMMA)) {
            if (this.tokenizer.next(UriTokenizer.TokenKind.FilterTrafo)) {
                item.setSystemQueryOption((SystemQueryOption)new FilterParser(this.edm, this.odata).parse(this.tokenizer, type, this.crossjoinEntitySetNames, this.aliases));
                ParserHelper.requireNext(this.tokenizer, UriTokenizer.TokenKind.CLOSE);
            } else {
                ParserHelper.requireNext(this.tokenizer, UriTokenizer.TokenKind.ExpandTrafo);
                item.setSystemQueryOption((SystemQueryOption)this.parseExpandTrafo((EdmStructuredType)type));
            }
        }
        while (this.tokenizer.next(UriTokenizer.TokenKind.COMMA)) {
            ParserHelper.requireNext(this.tokenizer, UriTokenizer.TokenKind.ExpandTrafo);
            ExpandOption nestedExpand = this.parseExpandTrafo((EdmStructuredType)type);
            if (item.getExpandOption() == null) {
                item.setSystemQueryOption((SystemQueryOption)nestedExpand);
                continue;
            }
            ((ExpandOptionImpl)item.getExpandOption()).addExpandItem((ExpandItem)nestedExpand.getExpandItems().get(0));
        }
        ParserHelper.requireNext(this.tokenizer, UriTokenizer.TokenKind.CLOSE);
        ExpandOptionImpl expand = new ExpandOptionImpl();
        expand.addExpandItem(item);
        return expand;
    }

    private GroupBy parseGroupByTrafo(EdmStructuredType referencedType) throws UriParserException, UriValidationException {
        GroupByImpl groupBy = new GroupByImpl();
        this.parseGroupByList(groupBy, referencedType);
        if (this.tokenizer.next(UriTokenizer.TokenKind.COMMA)) {
            groupBy.setApplyOption(this.parseApply(referencedType));
        }
        ParserHelper.requireNext(this.tokenizer, UriTokenizer.TokenKind.CLOSE);
        return groupBy;
    }

    private void parseGroupByList(GroupByImpl groupBy, EdmStructuredType referencedType) throws UriParserException {
        ParserHelper.requireNext(this.tokenizer, UriTokenizer.TokenKind.OPEN);
        do {
            groupBy.addGroupByItem(this.parseGroupByElement(referencedType));
        } while (this.tokenizer.next(UriTokenizer.TokenKind.COMMA));
        ParserHelper.requireNext(this.tokenizer, UriTokenizer.TokenKind.CLOSE);
    }

    private GroupByItem parseGroupByElement(EdmStructuredType referencedType) throws UriParserException {
        if (this.tokenizer.next(UriTokenizer.TokenKind.RollUpSpec)) {
            return this.parseRollUpSpec(referencedType);
        }
        return new GroupByItemImpl().setPath(this.parseGroupingProperty(referencedType));
    }

    private GroupByItem parseRollUpSpec(EdmStructuredType referencedType) throws UriParserException {
        GroupByItemImpl item = new GroupByItemImpl();
        if (this.tokenizer.next(UriTokenizer.TokenKind.ROLLUP_ALL)) {
            item.setIsRollupAll();
        } else {
            item.addRollupItem(new GroupByItemImpl().setPath(this.parseGroupingProperty(referencedType)));
        }
        ParserHelper.requireNext(this.tokenizer, UriTokenizer.TokenKind.COMMA);
        do {
            item.addRollupItem(new GroupByItemImpl().setPath(this.parseGroupingProperty(referencedType)));
        } while (this.tokenizer.next(UriTokenizer.TokenKind.COMMA));
        ParserHelper.requireNext(this.tokenizer, UriTokenizer.TokenKind.CLOSE);
        return item;
    }

    private UriInfo parseGroupingProperty(EdmStructuredType referencedType) throws UriParserException {
        UriInfoImpl uriInfo = new UriInfoImpl();
        String identifierLeft = this.parsePathPrefix(uriInfo, referencedType);
        if (identifierLeft != null) {
            throw new UriParserSemanticException("Unknown identifier in grouping property path.", UriParserSemanticException.MessageKeys.EXPRESSION_PROPERTY_NOT_IN_TYPE, identifierLeft, uriInfo.getLastResourcePart() != null && uriInfo.getLastResourcePart() instanceof UriResourcePartTyped ? ((UriResourcePartTyped)uriInfo.getLastResourcePart()).getType().getFullQualifiedName().getFullQualifiedNameAsString() : "");
        }
        return uriInfo;
    }

    private String parsePathPrefix(UriInfoImpl uriInfo, EdmStructuredType referencedType) throws UriParserException {
        EdmStructuredType type;
        EdmStructuredType typeCast = ParserHelper.parseTypeCast(this.tokenizer, this.edm, referencedType);
        if (typeCast != null) {
            uriInfo.addResourcePart(new UriResourceStartingTypeFilterImpl((EdmType)typeCast, true));
            ParserHelper.requireNext(this.tokenizer, UriTokenizer.TokenKind.SLASH);
        }
        EdmStructuredType edmStructuredType = type = typeCast == null ? referencedType : typeCast;
        while (this.tokenizer.next(UriTokenizer.TokenKind.ODataIdentifier)) {
            String name = this.tokenizer.getText();
            EdmElement property = type.getProperty(name);
            UriResource segment = this.parsePathSegment(property);
            if (segment == null) {
                if (property == null) {
                    return name;
                }
                uriInfo.addResourcePart(property instanceof EdmNavigationProperty ? new UriResourceNavigationPropertyImpl((EdmNavigationProperty)property) : (property.getType().getKind() == EdmTypeKind.COMPLEX ? new UriResourceComplexPropertyImpl((EdmProperty)property) : new UriResourcePrimitivePropertyImpl((EdmProperty)property)));
                return null;
            }
            uriInfo.addResourcePart(segment);
            type = (EdmStructuredType)ParserHelper.getTypeInformation((UriResourcePartTyped)segment);
        }
        return null;
    }

    private UriResource parsePathSegment(EdmElement property) throws UriParserException {
        if (property == null || property.getType().getKind() != EdmTypeKind.COMPLEX && !(property instanceof EdmNavigationProperty)) {
            return null;
        }
        if (this.tokenizer.next(UriTokenizer.TokenKind.SLASH)) {
            EdmStructuredType typeCast = ParserHelper.parseTypeCast(this.tokenizer, this.edm, (EdmStructuredType)property.getType());
            if (typeCast != null) {
                ParserHelper.requireNext(this.tokenizer, UriTokenizer.TokenKind.SLASH);
            }
            return property.getType().getKind() == EdmTypeKind.COMPLEX ? new UriResourceComplexPropertyImpl((EdmProperty)property).setTypeFilter(typeCast) : new UriResourceNavigationPropertyImpl((EdmNavigationProperty)property).setCollectionTypeFilter((EdmType)typeCast);
        }
        return null;
    }

    private CustomFunction parseCustomFunction(FullQualifiedName functionName, EdmStructuredType referencedType) throws UriParserException, UriValidationException {
        List<UriParameter> parameters = ParserHelper.parseFunctionParameters(this.tokenizer, this.edm, (EdmType)referencedType, true, this.aliases);
        List<String> parameterNames = ParserHelper.getParameterNames(parameters);
        EdmFunction function = this.edm.getBoundFunction(functionName, referencedType.getFullQualifiedName(), Boolean.valueOf(true), parameterNames);
        if (function == null) {
            throw new UriParserSemanticException("No function '" + functionName + "' found.", UriParserSemanticException.MessageKeys.FUNCTION_NOT_FOUND, functionName.getFullQualifiedNameAsString());
        }
        ParserHelper.validateFunctionParameters(function, parameters, this.edm, (EdmType)referencedType, this.aliases);
        EdmParameter bindingParameter = function.getParameter((String)function.getParameterNames().get(0));
        EdmReturnType returnType = function.getReturnType();
        if (bindingParameter.getType().getKind() != EdmTypeKind.ENTITY && bindingParameter.getType().getKind() != EdmTypeKind.COMPLEX || !bindingParameter.isCollection() || returnType.getType().getKind() != EdmTypeKind.ENTITY && returnType.getType().getKind() != EdmTypeKind.COMPLEX || !returnType.isCollection()) {
            throw new UriParserSemanticException("Only entity- or complex-collection functions are allowed.", UriParserSemanticException.MessageKeys.FUNCTION_MUST_USE_COLLECTIONS, functionName.getFullQualifiedNameAsString());
        }
        return new CustomFunctionImpl().setFunction(function).setParameters(parameters);
    }

    private BottomTop parseBottomTop(UriTokenizer.TokenKind kind, EdmStructuredType referencedType) throws UriParserException, UriValidationException {
        BottomTopImpl bottomTop = new BottomTopImpl();
        bottomTop.setMethod(TOKEN_KIND_TO_BOTTOM_TOP_METHOD.get((Object)kind));
        ExpressionParser expressionParser = new ExpressionParser(this.edm, this.odata);
        Expression number = expressionParser.parse(this.tokenizer, (EdmType)referencedType, this.crossjoinEntitySetNames, this.aliases);
        expressionParser.checkIntegerType(number);
        bottomTop.setNumber(number);
        ParserHelper.requireNext(this.tokenizer, UriTokenizer.TokenKind.COMMA);
        Expression value = expressionParser.parse(this.tokenizer, (EdmType)referencedType, this.crossjoinEntitySetNames, this.aliases);
        expressionParser.checkNumericType(value);
        bottomTop.setValue(value);
        ParserHelper.requireNext(this.tokenizer, UriTokenizer.TokenKind.CLOSE);
        return bottomTop;
    }

    static {
        EnumMap<UriTokenizer.TokenKind, Object> temp = new EnumMap<UriTokenizer.TokenKind, Object>(UriTokenizer.TokenKind.class);
        temp.put(UriTokenizer.TokenKind.SUM, AggregateExpression.StandardMethod.SUM);
        temp.put(UriTokenizer.TokenKind.MIN, AggregateExpression.StandardMethod.MIN);
        temp.put(UriTokenizer.TokenKind.MAX, AggregateExpression.StandardMethod.MAX);
        temp.put(UriTokenizer.TokenKind.AVERAGE, AggregateExpression.StandardMethod.AVERAGE);
        temp.put(UriTokenizer.TokenKind.COUNTDISTINCT, AggregateExpression.StandardMethod.COUNT_DISTINCT);
        TOKEN_KIND_TO_STANDARD_METHOD = Collections.unmodifiableMap(temp);
        temp = new EnumMap(UriTokenizer.TokenKind.class);
        temp.put(UriTokenizer.TokenKind.BottomCountTrafo, BottomTop.Method.BOTTOM_COUNT);
        temp.put(UriTokenizer.TokenKind.BottomPercentTrafo, BottomTop.Method.BOTTOM_PERCENT);
        temp.put(UriTokenizer.TokenKind.BottomSumTrafo, BottomTop.Method.BOTTOM_SUM);
        temp.put(UriTokenizer.TokenKind.TopCountTrafo, BottomTop.Method.TOP_COUNT);
        temp.put(UriTokenizer.TokenKind.TopPercentTrafo, BottomTop.Method.TOP_PERCENT);
        temp.put(UriTokenizer.TokenKind.TopSumTrafo, BottomTop.Method.TOP_SUM);
        TOKEN_KIND_TO_BOTTOM_TOP_METHOD = Collections.unmodifiableMap(temp);
    }

    static enum Requirement {
        REQUIRED,
        OPTIONAL,
        FORBIDDEN;

    }
}

