/*
 * Decompiled with CFR 0.152.
 */
package io.oxia.client;

import io.oxia.client.api.GetResult;
import io.oxia.client.api.RangeScanConsumer;
import java.util.Iterator;
import java.util.NoSuchElementException;

public class GetResultIterator
implements Iterator<GetResult>,
RangeScanConsumer {
    private GetResult pendingResult;
    private Throwable error = null;
    private boolean completed = false;

    public synchronized void onNext(GetResult result) {
        while (this.pendingResult != null) {
            this.wait();
        }
        this.pendingResult = result;
        this.notifyAll();
    }

    public synchronized void onError(Throwable throwable) {
        this.error = new Exception("Range scan error", throwable);
        this.notifyAll();
    }

    public synchronized void onCompleted() {
        this.completed = true;
        this.notifyAll();
    }

    @Override
    public synchronized boolean hasNext() {
        while (this.error == null && !this.completed && this.pendingResult == null) {
            this.wait();
        }
        if (this.error != null) {
            throw new RuntimeException(this.error);
        }
        return this.pendingResult != null;
    }

    @Override
    public synchronized GetResult next() {
        while (this.error == null && !this.completed && this.pendingResult == null) {
            this.wait();
        }
        if (this.error != null) {
            throw new RuntimeException(this.error);
        }
        if (this.pendingResult != null) {
            GetResult res = this.pendingResult;
            this.pendingResult = null;
            this.notifyAll();
            return res;
        }
        throw new NoSuchElementException();
    }
}

